/*
 * Decompiled with CFR 0.152.
 */
package org.jpos.util;

public class ThroughputControl {
    private int[] period;
    private int[] max;
    private int[] cnt;
    private long[] start;
    private long[] sleep;

    public ThroughputControl(int maxTransactions, int periodInMillis) {
        this(new int[]{maxTransactions}, new int[]{periodInMillis});
    }

    public ThroughputControl(int[] maxTransactions, int[] periodInMillis) {
        int l = maxTransactions.length;
        this.period = new int[l];
        this.max = new int[l];
        this.cnt = new int[l];
        this.start = new long[l];
        this.sleep = new long[l];
        for (int i = 0; i < l; ++i) {
            this.max[i] = maxTransactions[i];
            this.period[i] = periodInMillis[i];
            this.sleep[i] = Math.min(Math.max((long)(periodInMillis[i] / 10), 500L), 50L);
            this.start[i] = System.currentTimeMillis();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long control() {
        boolean delayed = false;
        long init = System.currentTimeMillis();
        for (int i = 0; i < this.cnt.length; ++i) {
            ThroughputControl throughputControl = this;
            synchronized (throughputControl) {
                int n = i;
                this.cnt[n] = this.cnt[n] + 1;
            }
            do {
                if (this.cnt[i] > this.max[i]) {
                    delayed = true;
                    try {
                        Thread.sleep(this.sleep[i]);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                }
                throughputControl = this;
                synchronized (throughputControl) {
                    long now = System.currentTimeMillis();
                    if (now - this.start[i] > (long)this.period[i]) {
                        long elapsed = now - this.start[i];
                        int allowed = (int)(elapsed * (long)this.max[i] / (long)this.period[i]);
                        this.start[i] = now;
                        this.cnt[i] = Math.max(this.cnt[i] - allowed, 0);
                    }
                }
            } while (this.cnt[i] > this.max[i]);
        }
        return delayed ? System.currentTimeMillis() - init : 0L;
    }
}

