/*
 * Decompiled with CFR 0.152.
 */
package org.jpos.util;

import java.io.PrintStream;
import org.jpos.core.Configurable;
import org.jpos.core.Configuration;
import org.jpos.core.ConfigurationException;
import org.jpos.util.BlockingQueue;
import org.jpos.util.LogSource;
import org.jpos.util.Loggeable;
import org.jpos.util.Logger;
import org.jpos.util.NameRegistrar;
import org.jpos.util.ThreadPoolMBean;

public class ThreadPool
extends ThreadGroup
implements LogSource,
Loggeable,
Configurable,
ThreadPoolMBean {
    private static int poolNumber = 0;
    private static int threadNumber = 0;
    private int maxPoolSize = 1;
    private int available;
    private int running = 0;
    private int active = 0;
    private BlockingQueue pool = new BlockingQueue();
    private Logger logger;
    private String realm;
    private int jobs = 0;
    public static final int DEFAULT_MAX_THREADS = 100;

    public ThreadPool(int poolSize, int maxPoolSize) {
        this(poolSize, maxPoolSize, "ThreadPool-" + poolNumber++);
    }

    public ThreadPool(int poolSize, int maxPoolSize, String name) {
        super(name + "-" + poolNumber++);
        this.available = this.maxPoolSize = maxPoolSize > 0 ? maxPoolSize : 100;
        this.init(poolSize);
    }

    private void init(int poolSize) {
        while (this.running < Math.min(poolSize > 0 ? poolSize : 1, this.maxPoolSize)) {
            ++this.running;
            new PooledThread().start();
        }
    }

    public ThreadPool() {
        this(1, 100);
    }

    public void close() {
        this.pool.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void execute(Runnable action) throws BlockingQueue.Closed {
        if (!this.pool.ready()) {
            throw new BlockingQueue.Closed();
        }
        if (++this.jobs % this.maxPoolSize == 0 || this.pool.consumerCount() <= 0) {
            this.supervise();
        }
        BlockingQueue blockingQueue = this.pool;
        synchronized (blockingQueue) {
            if (this.running < this.maxPoolSize && this.pool.consumerCount() <= 0) {
                new PooledThread().start();
                ++this.running;
            }
        }
        --this.available;
        this.pool.enqueue(action);
    }

    @Override
    public void dump(PrintStream p, String indent) {
        String inner = indent + "  ";
        p.println(indent + "<thread-pool name=\"" + this.getName() + "\">");
        if (!this.pool.ready()) {
            p.println(inner + "<closed/>");
        }
        p.println(inner + "<jobs>" + this.getJobCount() + "</jobs>");
        p.println(inner + "<size>" + this.getPoolSize() + "</size>");
        p.println(inner + "<max>" + this.getMaxPoolSize() + "</max>");
        p.println(inner + "<active>" + this.getActiveCount() + "</active>");
        p.println(inner + "<idle>" + this.getIdleCount() + "</idle>");
        p.println(inner + "<active>" + this.getActiveCount() + "</active>");
        p.println(inner + "<pending>" + this.getPendingCount() + "</pending>");
        p.println(indent + "</thread-pool>");
    }

    @Override
    public int getJobCount() {
        return this.jobs;
    }

    @Override
    public int getPoolSize() {
        return this.running;
    }

    @Override
    public int getMaxPoolSize() {
        return this.maxPoolSize;
    }

    public int getActiveCount() {
        return this.active;
    }

    @Override
    public int getIdleCount() {
        return this.pool.consumerCount();
    }

    public synchronized int getAvailableCount() {
        return this.available;
    }

    @Override
    public int getPendingCount() {
        return this.pool.pending();
    }

    public void supervise() {
        Thread[] t = new Thread[this.maxPoolSize];
        int cnt = this.enumerate(t);
        for (int i = 0; i < cnt; ++i) {
            if (!(t[i] instanceof PooledThread)) continue;
            ((PooledThread)t[i]).supervise();
        }
    }

    @Override
    public void setLogger(Logger logger, String realm) {
        this.logger = logger;
        this.realm = realm;
    }

    @Override
    public String getRealm() {
        return this.realm;
    }

    @Override
    public Logger getLogger() {
        return this.logger;
    }

    @Override
    public void setConfiguration(Configuration cfg) throws ConfigurationException {
        this.maxPoolSize = cfg.getInt("max-size", 100);
        this.init(cfg.getInt("initial-size"));
    }

    public static ThreadPool getThreadPool(String name) throws NameRegistrar.NotFoundException {
        return (ThreadPool)NameRegistrar.get("thread.pool." + name);
    }

    private class PooledThread
    extends Thread {
        Object currentJob;

        public PooledThread() {
            super((ThreadGroup)ThreadPool.this, "PooledThread-" + threadNumber++);
            this.currentJob = null;
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            String name = this.getName();
            while (true) {
                try {
                    PooledThread pooledThread;
                    if (!ThreadPool.this.pool.ready()) break;
                    Object job = ThreadPool.this.pool.dequeue();
                    if (job instanceof Runnable) {
                        this.setName(name + "-running");
                        pooledThread = this;
                        synchronized (pooledThread) {
                            this.currentJob = job;
                        }
                        try {
                            ThreadPool.this.active++;
                            ((Runnable)job).run();
                            this.setName(name + "-idle");
                        }
                        catch (Throwable t) {
                            this.setName(name + "-idle-" + t.getMessage());
                        }
                        pooledThread = this;
                        synchronized (pooledThread) {
                            this.currentJob = null;
                            ThreadPool.this.available++;
                            ThreadPool.this.active--;
                            continue;
                        }
                    }
                    pooledThread = this;
                    synchronized (pooledThread) {
                        this.currentJob = null;
                        ThreadPool.this.available++;
                    }
                }
                catch (InterruptedException e) {
                    break;
                }
                catch (BlockingQueue.Closed closed) {
                    // empty catch block
                    break;
                }
            }
        }

        public synchronized void supervise() {
            if (this.currentJob != null && this.currentJob instanceof Supervised && ((Supervised)this.currentJob).expired()) {
                this.interrupt();
            }
        }
    }

    public static interface Supervised {
        public boolean expired();
    }
}

