/*
 * Decompiled with CFR 0.152.
 */
package org.jpos.util;

import java.io.PrintStream;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantLock;
import org.jpos.util.Loggeable;

public class TPS
implements Loggeable {
    AtomicInteger count;
    AtomicLong start;
    int peak;
    long peakWhen;
    static final long FROM_NANOS = 1000000L;
    long period;
    float tps;
    float avg;
    Timer timer;
    boolean autoupdate;
    final ReentrantLock lock = new ReentrantLock();

    public TPS() {
        this(1000L, false);
    }

    public TPS(boolean autoupdate) {
        this(1000L, autoupdate);
    }

    public TPS(final long period, boolean autoupdate) {
        this.count = new AtomicInteger(0);
        this.start = new AtomicLong(0L);
        this.period = period;
        this.autoupdate = autoupdate;
        this.start.set(System.nanoTime() / 1000000L);
        if (autoupdate) {
            this.timer = new Timer();
            this.timer.schedule(new TimerTask(){

                @Override
                public void run() {
                    TPS.this.calcTPS(period);
                }
            }, period, period);
        }
    }

    public void tick() {
        this.count.incrementAndGet();
    }

    public float floatValue() {
        return this.autoupdate ? this.tps : this.calcTPS();
    }

    public int intValue() {
        return Math.round(this.floatValue());
    }

    public float getAvg() {
        return this.avg;
    }

    public int getPeak() {
        return this.peak;
    }

    public long getPeakWhen() {
        return this.peakWhen;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        this.lock.lock();
        try {
            this.avg = 0.0f;
            this.peak = 0;
            this.peakWhen = 0L;
        }
        finally {
            this.lock.unlock();
        }
    }

    public long getPeriod() {
        return this.period;
    }

    public long getElapsed() {
        return System.nanoTime() - this.start.get();
    }

    public String toString() {
        return String.format("tps=%d, peak=%d, avg=%.2f", this.intValue(), this.getPeak(), Float.valueOf(this.getAvg()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        this.lock.lock();
        try {
            if (this.timer != null) {
                this.timer.cancel();
                this.timer = null;
                this.autoupdate = false;
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void dump(PrintStream p, String indent) {
        p.println(indent + "<tps" + (this.autoupdate ? " auto='true'>" : ">") + this.toString() + "</tps>");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private float calcTPS(long interval) {
        this.lock.lock();
        try {
            this.tps = (float)this.period * (float)this.count.get() / (float)interval;
            if (this.period != 1000L) {
                this.tps = this.tps * 1000.0f / (float)this.period;
            }
            float f = this.avg = this.avg == 0.0f ? this.tps : (this.avg + this.tps) / 2.0f;
            if (this.tps > (float)this.peak) {
                this.peak = Math.round(this.tps);
                this.peakWhen = System.currentTimeMillis();
            }
            this.count.set(0);
            float f2 = this.tps;
            return f2;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private float calcTPS() {
        this.lock.lock();
        try {
            long now = System.nanoTime() / 1000000L;
            long interval = now - this.start.get();
            if (interval >= this.period) {
                this.calcTPS(interval);
                this.start.set(now);
            }
            float f = this.tps;
            return f;
        }
        finally {
            this.lock.unlock();
        }
    }
}

