/*
 * Decompiled with CFR 0.152.
 */
package org.jpos.util;

import java.io.PrintStream;
import org.jpos.util.LogEvent;
import org.jpos.util.LogSource;
import org.jpos.util.Loggeable;
import org.jpos.util.Logger;
import org.jpos.util.NameRegistrar;

public class SystemMonitor
implements Runnable,
LogSource,
Loggeable {
    private Logger logger = null;
    private String realm = null;
    private int sleepTime = 0;
    private int delay = 0;
    private Thread thread = null;

    public SystemMonitor() {
    }

    public SystemMonitor(int sleepTime, Logger logger, String realm) {
        this.setLogger(logger, realm);
        this.sleepTime = sleepTime;
        this.startThread();
    }

    private void startThread() {
        if (this.thread != null) {
            this.thread.interrupt();
        } else if (this.sleepTime > 0) {
            this.thread = new Thread((Runnable)this, "SystemMonitor");
            this.thread.setPriority(1);
            this.thread.start();
        }
    }

    public void setSleepTime(int sleepTime) {
        this.sleepTime = sleepTime;
        this.startThread();
    }

    void dumpThreads(ThreadGroup g, PrintStream p, String indent) {
        Thread[] list = new Thread[g.activeCount() + 5];
        int nthreads = g.enumerate(list);
        for (int i = 0; i < nthreads; ++i) {
            p.println(indent + list[i]);
        }
    }

    public void showThreadGroup(ThreadGroup g, PrintStream p, String indent) {
        if (g.getParent() != null) {
            this.showThreadGroup(g.getParent(), p, indent + "  ");
        } else {
            this.dumpThreads(g, p, indent + "    ");
        }
    }

    @Override
    public void run() {
        while (true) {
            Logger.log(new LogEvent(this, "SystemMonitor", this));
            try {
                long expected = System.currentTimeMillis() + (long)this.sleepTime;
                Thread.sleep(this.sleepTime);
                this.delay = (int)(System.currentTimeMillis() - expected);
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    @Override
    public void dump(PrintStream p, String indent) {
        String newIndent = indent + "  ";
        Runtime r = Runtime.getRuntime();
        p.println(indent + "--- memory ---");
        p.println(newIndent + " freeMemory=" + r.freeMemory());
        p.println(newIndent + "totalMemory=" + r.totalMemory());
        p.println(newIndent + "inUseMemory=" + (r.totalMemory() - r.freeMemory()));
        p.println("");
        p.println(indent + "--- threads ---");
        p.println(newIndent + "      delay=" + this.delay + " ms");
        p.println(newIndent + "    threads=" + Thread.activeCount());
        this.showThreadGroup(Thread.currentThread().getThreadGroup(), p, newIndent);
        p.println("");
        NameRegistrar.getInstance().dump(p, indent);
    }

    @Override
    public void setLogger(Logger logger, String realm) {
        this.logger = logger;
        this.realm = realm;
    }

    @Override
    public String getRealm() {
        return this.realm;
    }

    @Override
    public Logger getLogger() {
        return this.logger;
    }
}

