/*
 * Decompiled with CFR 0.152.
 */
package org.jpos.util;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.util.Iterator;
import java.util.List;
import org.jpos.core.Configurable;
import org.jpos.core.Configuration;
import org.jpos.core.ConfigurationException;
import org.jpos.util.LogEvent;
import org.jpos.util.LogListener;

public class SysLogListener
implements LogListener,
Configurable {
    private DatagramSocket socket;
    private InetAddress host;
    private String prefix;
    private String tags;
    private int port;
    private int defaultFacility;
    private int defaultSeverity;
    private Configuration cfg;
    public static final int SYSLOG_PORT = 514;
    public static final int LOG_USER = 16;
    public static final int PRI_INFO = 6;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized LogEvent log(LogEvent ev) {
        if (this.socket != null && ev.getTag() != null && this.tags.contains(ev.getTag())) {
            int facility = this.cfg.getInt(ev.getTag() + ".facility", this.defaultFacility);
            int severity = this.cfg.getInt(ev.getTag() + ".severity", this.defaultSeverity);
            int priority = facility << 3 | severity;
            StringBuilder sb = new StringBuilder();
            sb.append('<');
            sb.append(Integer.toString(priority));
            sb.append('>');
            if (this.prefix != null) {
                sb.append(this.prefix);
                sb.append(' ');
            }
            sb.append(ev.getRealm());
            sb.append(' ');
            sb.append(ev.getTag());
            sb.append(" - ");
            List<Object> list = ev.getPayLoad();
            synchronized (list) {
                Iterator<Object> iter = ev.getPayLoad().iterator();
                int i = 0;
                while (iter.hasNext()) {
                    if (i > 0) {
                        sb.append(' ');
                    }
                    sb.append(iter.next().toString());
                    ++i;
                }
            }
            byte[] b = sb.toString().getBytes();
            DatagramPacket packet = new DatagramPacket(b, Math.min(b.length, 1024), this.host, this.port);
            try {
                this.socket.send(packet);
            }
            catch (IOException e) {
                ev.addMessage("--- SysLogListener error ---");
                ev.addMessage(e);
            }
        }
        return ev;
    }

    @Override
    public void setConfiguration(Configuration cfg) throws ConfigurationException {
        this.cfg = cfg;
        try {
            this.socket = new DatagramSocket();
            this.port = cfg.getInt("port", 514);
            this.host = InetAddress.getByName(cfg.get("host", "localhost"));
            this.defaultFacility = cfg.getInt("facility", 16);
            this.defaultSeverity = cfg.getInt("severity", 6);
            this.tags = cfg.get("tags", "audit, syslog");
            this.prefix = cfg.get("prefix", null);
        }
        catch (Exception e) {
            throw new ConfigurationException(e);
        }
    }
}

