/*
 * Decompiled with CFR 0.152.
 */
package org.jpos.util;

import java.io.PrintStream;
import org.jpos.iso.ISOUtil;
import org.jpos.util.Loggeable;

public class SimpleMsg
implements Loggeable {
    String tagName;
    String msgName;
    Object msgContent;

    public SimpleMsg(String tagName, String msgName, Object msgContent) {
        this.tagName = tagName;
        this.msgName = msgName;
        this.msgContent = msgContent;
    }

    public SimpleMsg(String tagName, String msgName, byte[] msgContent) {
        this(tagName, msgName, ISOUtil.hexString(msgContent));
    }

    public SimpleMsg(String tagName, String msgName, boolean msgContent) {
        this(tagName, msgName, (Object)msgContent);
    }

    public SimpleMsg(String tagName, String msgName, short msgContent) {
        this(tagName, msgName, (Object)msgContent);
    }

    public SimpleMsg(String tagName, String msgName, int msgContent) {
        this(tagName, msgName, (Object)msgContent);
    }

    public SimpleMsg(String tagName, String msgName, long msgContent) {
        this(tagName, msgName, (Object)msgContent);
    }

    @Override
    public void dump(PrintStream p, String indent) {
        String inner = indent + "  ";
        p.print(indent + "<" + this.tagName);
        p.print(" name=\"" + this.msgName + "\"");
        p.println(">");
        if (this.msgContent instanceof SimpleMsg[]) {
            for (int i = 0; i < ((SimpleMsg[])this.msgContent).length; ++i) {
                ((SimpleMsg[])this.msgContent)[i].dump(p, inner);
            }
        } else if (this.msgContent instanceof Loggeable) {
            ((Loggeable)this.msgContent).dump(p, inner);
        } else {
            p.println(inner + this.msgContent.toString());
        }
        p.println(indent + "</" + this.tagName + ">");
    }
}

