/*
 * Decompiled with CFR 0.152.
 */
package org.jpos.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import org.jpos.core.Configurable;
import org.jpos.core.Configuration;
import org.jpos.core.ConfigurationException;
import org.jpos.util.DefaultTimer;
import org.jpos.util.Destroyable;
import org.jpos.util.LogEvent;
import org.jpos.util.SimpleLogListener;

public class RotateLogListener
extends SimpleLogListener
implements Configurable,
Destroyable {
    FileOutputStream f;
    String logName;
    int maxCopies;
    long sleepTime;
    long maxSize;
    int msgCount;
    Rotate rotate;
    public static final int CHECK_INTERVAL = 100;
    public static final long DEFAULT_MAXSIZE = 10000000L;

    public RotateLogListener(String logName, int sleepTime, int maxCopies, long maxSize) throws IOException {
        this.logName = logName;
        this.maxCopies = maxCopies;
        this.sleepTime = sleepTime * 1000;
        this.maxSize = maxSize;
        this.f = null;
        this.openLogFile();
        Timer timer = DefaultTimer.getTimer();
        if (sleepTime != 0) {
            this.rotate = new Rotate();
            timer.schedule((TimerTask)this.rotate, this.sleepTime, this.sleepTime);
        }
    }

    public RotateLogListener(String logName, int sleepTime, int maxCopies) throws IOException {
        this(logName, sleepTime, maxCopies, 10000000L);
    }

    public RotateLogListener() {
    }

    @Override
    public void setConfiguration(Configuration cfg) throws ConfigurationException {
        this.maxCopies = cfg.getInt("copies");
        this.sleepTime = cfg.getInt("window") * 1000;
        this.logName = cfg.get("file");
        this.maxSize = cfg.getLong("maxsize");
        this.maxSize = this.maxSize <= 0L ? 10000000L : this.maxSize;
        try {
            this.openLogFile();
        }
        catch (IOException e) {
            throw new ConfigurationException(e);
        }
        Timer timer = DefaultTimer.getTimer();
        if (this.sleepTime != 0L) {
            this.rotate = new Rotate();
            timer.schedule((TimerTask)this.rotate, this.sleepTime, this.sleepTime);
        }
    }

    @Override
    public synchronized LogEvent log(LogEvent ev) {
        if (this.msgCount++ > 100) {
            this.checkSize();
            this.msgCount = 0;
        }
        return super.log(ev);
    }

    protected synchronized void openLogFile() throws IOException {
        if (this.f != null) {
            this.f.close();
        }
        this.f = new FileOutputStream(this.logName, true);
        this.setPrintStream(new PrintStream(this.f));
        this.p.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        this.p.println("<logger class=\"" + this.getClass().getName() + "\">");
    }

    protected synchronized void closeLogFile() throws IOException {
        this.p.println("</logger>");
        if (this.f != null) {
            this.f.close();
        }
        this.f = null;
    }

    public synchronized void logRotate() throws IOException {
        this.closeLogFile();
        super.close();
        this.setPrintStream(null);
        int i = this.maxCopies;
        while (i > 0) {
            File dest = new File(this.logName + "." + i);
            File source = new File(this.logName + (--i > 0 ? "." + i : ""));
            dest.delete();
            source.renameTo(dest);
        }
        this.openLogFile();
    }

    protected synchronized void logDebug(String msg) {
        if (this.p != null) {
            this.p.println("<log realm=\"rotate-log-listener\" at=\"" + new Date().toString() + "\">");
            this.p.println("   " + msg);
            this.p.println("</log>");
        }
    }

    protected void checkSize() {
        File logFile = new File(this.logName);
        if (logFile.length() > this.maxSize) {
            try {
                this.logDebug("maxSize (" + this.maxSize + ") threshold reached");
                this.logRotate();
            }
            catch (IOException e) {
                e.printStackTrace(System.err);
            }
        }
    }

    @Override
    public void destroy() {
        if (this.rotate != null) {
            this.rotate.cancel();
        }
        try {
            this.closeLogFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public class Rotate
    extends TimerTask {
        @Override
        public void run() {
            try {
                RotateLogListener.this.logDebug("time exceeded - log rotated");
                RotateLogListener.this.logRotate();
            }
            catch (IOException e) {
                e.printStackTrace(System.err);
            }
        }
    }
}

