/*
 * Decompiled with CFR 0.152.
 */
package org.jpos.util;

import java.util.List;
import org.jpos.core.Configurable;
import org.jpos.core.Configuration;
import org.jpos.core.ConfigurationException;
import org.jpos.iso.ISOException;
import org.jpos.iso.ISOMsg;
import org.jpos.iso.ISOUtil;
import org.jpos.util.LogEvent;
import org.jpos.util.LogListener;
import org.jpos.util.SimpleMsg;

public class ProtectedLogListener
implements LogListener,
Configurable {
    String[] protectFields = null;
    String[] wipeFields = null;
    Configuration cfg = null;
    public static final String WIPED = "[WIPED]";
    public static final byte[] BINARY_WIPED = ISOUtil.hex2byte("AA55AA55");

    @Override
    public void setConfiguration(Configuration cfg) throws ConfigurationException {
        this.cfg = cfg;
        this.protectFields = ISOUtil.toStringArray(cfg.get("protect", ""));
        this.wipeFields = ISOUtil.toStringArray(cfg.get("wipe", ""));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LogEvent log(LogEvent ev) {
        List<Object> list = ev.getPayLoad();
        synchronized (list) {
            List<Object> payLoad = ev.getPayLoad();
            int size = payLoad.size();
            for (int i = 0; i < size; ++i) {
                Object obj = payLoad.get(i);
                if (obj instanceof ISOMsg) {
                    ISOMsg m = (ISOMsg)((ISOMsg)obj).clone();
                    try {
                        this.checkProtected(m);
                        this.checkHidden(m);
                    }
                    catch (ISOException e) {
                        ev.addMessage(e);
                    }
                    payLoad.set(i, m);
                    continue;
                }
                if (!(obj instanceof SimpleMsg)) continue;
                try {
                    this.checkProtected((SimpleMsg)obj);
                    continue;
                }
                catch (ISOException e) {
                    ev.addMessage(e);
                }
            }
        }
        return ev;
    }

    private void checkProtected(ISOMsg m) throws ISOException {
        for (String f : this.protectFields) {
            Object v = null;
            try {
                v = m.getValue(f);
            }
            catch (ISOException e) {
                // empty catch block
            }
            if (v == null) continue;
            if (v instanceof String) {
                m.set(f, ISOUtil.protect((String)v));
                continue;
            }
            m.set(f, BINARY_WIPED);
        }
    }

    private void checkProtected(SimpleMsg sm) throws ISOException {
        if (sm.msgContent instanceof SimpleMsg[]) {
            for (SimpleMsg sMsg : (SimpleMsg[])sm.msgContent) {
                this.checkProtected(sMsg);
            }
        } else if (sm.msgContent instanceof SimpleMsg) {
            this.checkProtected((SimpleMsg)sm.msgContent);
        } else if (sm.msgContent instanceof ISOMsg) {
            ISOMsg m = (ISOMsg)((ISOMsg)sm.msgContent).clone();
            this.checkProtected(m);
            this.checkHidden(m);
            sm.msgContent = m;
        }
    }

    private void checkHidden(ISOMsg m) throws ISOException {
        for (String f : this.wipeFields) {
            Object v = null;
            try {
                v = m.getValue(f);
            }
            catch (ISOException e) {
                // empty catch block
            }
            if (v == null) continue;
            if (v instanceof String) {
                m.set(f, WIPED);
                continue;
            }
            m.set(f, BINARY_WIPED);
        }
    }
}

