/*
 * Decompiled with CFR 0.152.
 */
package org.jpos.util;

import java.io.PrintStream;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import org.jpos.util.Loggeable;

public class Profiler
implements Loggeable {
    long start;
    long partial;
    LinkedHashMap events;
    public static final int TO_MILLIS = 1000000;

    public Profiler() {
        this.reset();
    }

    public void reset() {
        this.start = this.partial = System.nanoTime();
        this.events = new LinkedHashMap();
    }

    public synchronized void checkPoint(String detail) {
        long now = System.nanoTime();
        Entry e = new Entry();
        e.setDurationInNanos(now - this.partial);
        e.setTotalDurationInNanos(now - this.start);
        if (this.events.containsKey(detail)) {
            int i = 1;
            while (true) {
                String d;
                if (!this.events.containsKey(d = detail + "-" + i)) {
                    detail = d;
                    break;
                }
                ++i;
            }
        }
        e.setEventName(detail);
        this.events.put(detail, e);
        this.partial = now;
    }

    public long getElapsed() {
        return System.nanoTime() - this.start;
    }

    public long getPartial() {
        return System.nanoTime() - this.partial;
    }

    @Override
    public void dump(PrintStream p, String indent) {
        String inner = indent + "  ";
        if (!this.events.containsKey("end")) {
            this.checkPoint("end");
        }
        Collection c = this.events.values();
        Iterator iter = c.iterator();
        p.println(indent + "<profiler>");
        while (iter.hasNext()) {
            p.println(inner + iter.next().toString());
        }
        p.println(indent + "</profiler>");
    }

    public Entry getEntry(String eventName) {
        return (Entry)this.events.get(eventName);
    }

    public static class Entry {
        String eventName = "";
        long duration = 0L;
        long totalDuration = 0L;

        public void setEventName(String myEvent) {
            this.eventName = myEvent;
        }

        public String getEventName() {
            return this.eventName;
        }

        public void setDurationInNanos(long duration) {
            this.duration = duration;
        }

        public long getDuration() {
            return this.duration / 1000000L;
        }

        public long getDurationInNanos() {
            return this.duration;
        }

        public void setTotalDurationInNanos(long totalDuration) {
            this.totalDuration = totalDuration;
        }

        public long getTotalDuration() {
            return this.totalDuration / 1000000L;
        }

        public long getTotalDurationInNanos() {
            return this.totalDuration;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(this.eventName);
            sb.append(" [");
            sb.append(this.getDuration());
            sb.append('.');
            sb.append(this.duration % 1000000L / 100000L);
            sb.append('/');
            sb.append(this.getTotalDuration());
            sb.append('.');
            sb.append(this.totalDuration % 1000000L / 100000L);
            sb.append(']');
            return sb.toString();
        }
    }
}

