/*
 * Decompiled with CFR 0.152.
 */
package org.jpos.util;

import java.io.PrintStream;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jpos.util.Loggeable;

public class NameRegistrar
implements Loggeable {
    private static final NameRegistrar instance = new NameRegistrar();
    private static final ConcurrentMap<String, Object> registrar = new ConcurrentHashMap<String, Object>();

    private NameRegistrar() {
    }

    public static ConcurrentMap<String, Object> getMap() {
        NameRegistrar.getInstance();
        return registrar;
    }

    public static NameRegistrar getInstance() {
        return instance;
    }

    public static void register(String key, Object value) {
        NameRegistrar.getMap().put(key, value);
    }

    public static void unregister(String key) {
        NameRegistrar.getMap().remove(key);
    }

    public static Object get(String key) throws NotFoundException {
        Object obj = NameRegistrar.getMap().get(key);
        if (obj == null) {
            throw new NotFoundException(key);
        }
        return obj;
    }

    public static Object getIfExists(String key) {
        return NameRegistrar.getMap().get(key);
    }

    @Override
    public void dump(PrintStream p, String indent) {
        this.dump(p, indent, false);
    }

    public void dump(PrintStream p, String indent, boolean detail) {
        String inner = indent + "  ";
        p.println(indent + "name-registrar:");
        for (Map.Entry entry : registrar.entrySet()) {
            Object obj = entry.getValue();
            String key = (String)entry.getKey();
            if (key == null) {
                key = "null";
            }
            String objectClassName = obj == null ? "<NULL>" : obj.getClass().getName();
            p.println(inner + key + ": " + objectClassName);
            if (!detail || !(obj instanceof Loggeable)) continue;
            ((Loggeable)obj).dump(p, inner + "  ");
        }
    }

    public static class NotFoundException
    extends Exception {
        private static final long serialVersionUID = 8744022794646381475L;

        public NotFoundException() {
        }

        public NotFoundException(String detail) {
            super(detail);
        }
    }
}

