/*
 * Decompiled with CFR 0.152.
 */
package org.jpos.util;

import java.util.Iterator;
import java.util.Vector;
import org.jpos.q2.Q2;
import org.jpos.util.Destroyable;
import org.jpos.util.LogEvent;
import org.jpos.util.LogListener;
import org.jpos.util.LogProducer;
import org.jpos.util.LogSource;
import org.jpos.util.NameRegistrar;

public class Logger
implements LogProducer {
    String name = "";
    Vector listeners = new Vector();
    static boolean versionShown = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(LogListener l) {
        Vector vector = this.listeners;
        synchronized (vector) {
            this.listeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeListener(LogListener l) {
        Vector vector = this.listeners;
        synchronized (vector) {
            this.listeners.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAllListeners() {
        Vector vector = this.listeners;
        synchronized (vector) {
            for (LogListener l : this.listeners) {
                if (!(l instanceof Destroyable)) continue;
                ((Destroyable)((Object)l)).destroy();
            }
            this.listeners.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void log(LogEvent evt) {
        Logger l = null;
        LogSource source = evt.getSource();
        if (!versionShown) {
            evt.addMessage("");
            evt.addMessage(Q2.getVersionString());
            boolean bl = versionShown = !versionShown;
        }
        if (source != null) {
            l = source.getLogger();
        }
        if (l != null && l.hasListeners()) {
            Vector vector = l.listeners;
            synchronized (vector) {
                Iterator i = l.listeners.iterator();
                while (i.hasNext() && evt != null) {
                    evt = ((LogListener)i.next()).log(evt);
                }
            }
        }
    }

    public void setName(String name) {
        this.name = name;
        NameRegistrar.register("logger." + name, this);
    }

    public void destroy() {
        NameRegistrar.unregister("logger." + this.name);
        this.removeAllListeners();
    }

    public static synchronized Logger getLogger(String name) {
        Logger l;
        try {
            l = (Logger)NameRegistrar.get("logger." + name);
        }
        catch (NameRegistrar.NotFoundException e) {
            l = new Logger();
            l.setName(name);
        }
        return l;
    }

    public String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasListeners() {
        Vector vector = this.listeners;
        synchronized (vector) {
            return this.listeners.size() > 0;
        }
    }
}

