/*
 * Decompiled with CFR 0.152.
 */
package org.jpos.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.jdom.Element;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.jpos.util.LogSource;
import org.jpos.util.Loggeable;

public class LogEvent {
    private LogSource source;
    private String tag;
    private final List<Object> payLoad;
    private long createdAt;
    private long dumpedAt;

    public LogEvent(String tag) {
        this.tag = tag;
        this.createdAt = System.currentTimeMillis();
        this.payLoad = Collections.synchronizedList(new ArrayList());
    }

    public LogEvent() {
        this("info");
    }

    public LogEvent(String tag, Object msg) {
        this(tag);
        this.addMessage(msg);
    }

    public LogEvent(LogSource source, String tag) {
        this(tag);
        this.source = source;
    }

    public LogEvent(LogSource source, String tag, Object msg) {
        this(tag);
        this.source = source;
        this.addMessage(msg);
    }

    public String getTag() {
        return this.tag;
    }

    public void addMessage(Object msg) {
        this.payLoad.add(msg);
    }

    public void addMessage(String tagname, String message) {
        this.payLoad.add("<" + tagname + ">" + message + "</" + tagname + ">");
    }

    public LogSource getSource() {
        return this.source;
    }

    public void setSource(LogSource source) {
        this.source = source;
    }

    protected String dumpHeader(PrintStream p, String indent) {
        if (this.dumpedAt == 0L) {
            this.dumpedAt = System.currentTimeMillis();
        }
        Date date = new Date(this.dumpedAt);
        StringBuilder sb = new StringBuilder(indent);
        sb.append("<log realm=\"");
        sb.append(this.getRealm());
        sb.append("\" at=\"");
        sb.append(date.toString());
        sb.append('.');
        sb.append(Long.toString(this.dumpedAt % 1000L));
        sb.append('\"');
        if (this.dumpedAt != this.createdAt) {
            sb.append(" lifespan=\"");
            sb.append(Long.toString(this.dumpedAt - this.createdAt));
            sb.append("ms\"");
        }
        sb.append('>');
        p.println(sb.toString());
        return indent + "  ";
    }

    protected void dumpTrailer(PrintStream p, String indent) {
        p.println(indent + "</log>");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dump(PrintStream p, String outer) {
        String indent = this.dumpHeader(p, outer);
        if (this.payLoad.isEmpty()) {
            if (this.tag != null) {
                p.println(indent + "<" + this.tag + "/>");
            }
        } else {
            String newIndent;
            if (this.tag != null) {
                p.println(indent + "<" + this.tag + ">");
                newIndent = indent + "  ";
            } else {
                newIndent = "";
            }
            List<Object> list = this.payLoad;
            synchronized (list) {
                for (Object o : this.payLoad) {
                    if (o instanceof Loggeable) {
                        ((Loggeable)o).dump(p, newIndent);
                        continue;
                    }
                    if (o instanceof SQLException) {
                        SQLException e = (SQLException)o;
                        p.println(newIndent + "<SQLException>" + e.getMessage() + "</SQLException>");
                        p.println(newIndent + "<SQLState>" + e.getSQLState() + "</SQLState>");
                        p.println(newIndent + "<VendorError>" + e.getErrorCode() + "</VendorError>");
                        ((Throwable)o).printStackTrace(p);
                        continue;
                    }
                    if (o instanceof Throwable) {
                        p.println(newIndent + "<exception name=\"" + ((Throwable)o).getMessage() + "\">");
                        p.print(newIndent);
                        ((Throwable)o).printStackTrace(p);
                        p.println(newIndent + "</exception>");
                        continue;
                    }
                    if (o instanceof Object[]) {
                        Object[] oa = (Object[])o;
                        p.print(newIndent + "[");
                        for (int j = 0; j < oa.length; ++j) {
                            if (j > 0) {
                                p.print(",");
                            }
                            p.print(oa[j].toString());
                        }
                        p.println("]");
                        continue;
                    }
                    if (o instanceof Element) {
                        p.println("");
                        p.println(newIndent + "<![CDATA[");
                        XMLOutputter out = new XMLOutputter(Format.getPrettyFormat());
                        out.getFormat().setLineSeparator("\n");
                        try {
                            out.output((Element)o, (OutputStream)p);
                        }
                        catch (IOException ex) {
                            ex.printStackTrace(p);
                        }
                        p.println("");
                        p.println(newIndent + "]]>");
                        continue;
                    }
                    if (o != null) {
                        p.println(newIndent + o.toString());
                        continue;
                    }
                    p.println(newIndent + "null");
                }
            }
            if (this.tag != null) {
                p.println(indent + "</" + this.tag + ">");
            }
        }
        this.dumpTrailer(p, outer);
    }

    public String getRealm() {
        return this.source != null ? this.source.getRealm() : "";
    }

    public List<Object> getPayLoad() {
        return this.payLoad;
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream p = new PrintStream(baos);
        this.dump(p, "");
        return baos.toString();
    }
}

