/*
 * Decompiled with CFR 0.152.
 */
package org.jpos.util;

import org.jpos.util.LogEvent;
import org.jpos.util.LogSource;
import org.jpos.util.Logger;

public class Log
implements LogSource {
    protected Logger logger;
    protected String realm;
    public static final String TRACE = "trace";
    public static final String DEBUG = "debug";
    public static final String INFO = "info";
    public static final String WARN = "warn";
    public static final String ERROR = "error";
    public static final String FATAL = "fatal";

    public Log() {
    }

    public static Log getLog(String logName, String realm) {
        return new Log(Logger.getLogger(logName), realm);
    }

    public Log(Logger logger, String realm) {
        this.setLogger(logger, realm);
    }

    @Override
    public void setLogger(Logger logger, String realm) {
        this.logger = logger;
        this.realm = realm;
    }

    @Override
    public String getRealm() {
        return this.realm;
    }

    @Override
    public Logger getLogger() {
        return this.logger;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public void setRealm(String realm) {
        this.realm = realm;
    }

    public void trace(Object detail) {
        Logger.log(this.createTrace(detail));
    }

    public void trace(Object detail, Object obj) {
        LogEvent evt = this.createTrace(detail);
        evt.addMessage(obj);
        Logger.log(evt);
    }

    public void debug(Object detail) {
        Logger.log(this.createDebug(detail));
    }

    public void debug(Object detail, Object obj) {
        LogEvent evt = this.createDebug(detail);
        evt.addMessage(obj);
        Logger.log(evt);
    }

    public void info(Object detail) {
        Logger.log(this.createInfo(detail));
    }

    public void info(Object detail, Object obj) {
        LogEvent evt = this.createInfo(detail);
        evt.addMessage(obj);
        Logger.log(evt);
    }

    public void warn(Object detail) {
        Logger.log(this.createWarn(detail));
    }

    public void warn(Object detail, Object obj) {
        LogEvent evt = this.createWarn(detail);
        evt.addMessage(obj);
        Logger.log(evt);
    }

    public void error(Object detail) {
        Logger.log(this.createError(detail));
    }

    public void error(Object detail, Object obj) {
        LogEvent evt = this.createError(detail);
        evt.addMessage(obj);
        Logger.log(evt);
    }

    public void fatal(Object detail) {
        Logger.log(this.createFatal(detail));
    }

    public void fatal(Object detail, Object obj) {
        LogEvent evt = this.createFatal(detail);
        evt.addMessage(obj);
        Logger.log(evt);
    }

    public LogEvent createLogEvent(String level) {
        return new LogEvent(this, level);
    }

    public LogEvent createLogEvent(String level, Object detail) {
        return new LogEvent(this, level, detail);
    }

    public LogEvent createTrace() {
        return this.createLogEvent(TRACE);
    }

    public LogEvent createTrace(Object detail) {
        return this.createLogEvent(TRACE, detail);
    }

    public LogEvent createDebug() {
        return this.createLogEvent(DEBUG);
    }

    public LogEvent createDebug(Object detail) {
        return this.createLogEvent(DEBUG, detail);
    }

    public LogEvent createInfo() {
        return this.createLogEvent(INFO);
    }

    public LogEvent createInfo(Object detail) {
        return this.createLogEvent(INFO, detail);
    }

    public LogEvent createWarn() {
        return this.createLogEvent(WARN);
    }

    public LogEvent createWarn(Object detail) {
        return this.createLogEvent(WARN, detail);
    }

    public LogEvent createError() {
        return this.createLogEvent(ERROR);
    }

    public LogEvent createError(Object detail) {
        return this.createLogEvent(ERROR, detail);
    }

    public LogEvent createFatal() {
        return this.createLogEvent(FATAL);
    }

    public LogEvent createFatal(Object detail) {
        return this.createLogEvent(FATAL, detail);
    }
}

