/*
 * Decompiled with CFR 0.152.
 */
package org.jpos.util;

import java.io.PrintStream;
import java.util.Date;
import java.util.Hashtable;
import org.jpos.core.Configurable;
import org.jpos.core.Configuration;
import org.jpos.core.ConfigurationException;
import org.jpos.util.LogEvent;
import org.jpos.util.LogListener;

public class FilterLogListener
implements LogListener,
Configurable {
    private static Hashtable levels = new Hashtable(6);
    private String priority = "info";
    PrintStream p;

    public FilterLogListener() {
        this.p = System.out;
    }

    public FilterLogListener(PrintStream p) {
        this.setPrintStream(p);
    }

    @Override
    public void setConfiguration(Configuration cfg) throws ConfigurationException {
        try {
            String log_priority = cfg.get("priority");
            if (log_priority != null && !log_priority.trim().equals("") && levels.containsKey(log_priority)) {
                this.priority = log_priority;
            }
        }
        catch (Exception e) {
            throw new ConfigurationException(e);
        }
    }

    public synchronized void setPrintStream(PrintStream p) {
        this.p = p;
    }

    public synchronized void close() {
        if (this.p != null) {
            this.p.close();
            this.p = null;
        }
    }

    public String getPriority() {
        return this.priority;
    }

    public void setPriority(String priority) {
        this.priority = priority;
    }

    public boolean permitLogging(String tagLevel) {
        Integer I = (Integer)levels.get(tagLevel);
        if (I == null) {
            I = (Integer)levels.get("info");
        }
        Integer J = (Integer)levels.get(this.priority);
        return I >= J;
    }

    @Override
    public synchronized LogEvent log(LogEvent ev) {
        if (this.p != null && this.permitLogging(ev.getTag())) {
            Date d = new Date();
            this.p.println("<log realm=\"" + ev.getRealm() + "\" at=\"" + d.toString() + "." + d.getTime() % 1000L + "\">");
            ev.dump(this.p, "  ");
            this.p.println("</log>");
            this.p.flush();
        }
        return ev;
    }

    static {
        levels.put("trace", 1);
        levels.put("debug", 2);
        levels.put("info", 3);
        levels.put("warn", 4);
        levels.put("error", 5);
        levels.put("fatal", 6);
    }
}

