/*
 * Decompiled with CFR 0.152.
 */
package org.jpos.util;

import java.util.List;
import org.jpos.core.Configurable;
import org.jpos.core.Configuration;
import org.jpos.core.ConfigurationException;
import org.jpos.iso.FSDISOMsg;
import org.jpos.iso.ISOException;
import org.jpos.iso.ISOUtil;
import org.jpos.util.LogEvent;
import org.jpos.util.LogListener;

public class FSDProtectedLogListener
implements LogListener,
Configurable {
    String[] protectFields = null;
    String[] wipeFields = null;
    String[] truncateFields = null;
    Configuration cfg = null;
    public static final String WIPED = "[WIPED]";
    public static final byte[] BINARY_WIPED = ISOUtil.hex2byte("AA55AA55");

    @Override
    public void setConfiguration(Configuration cfg) throws ConfigurationException {
        this.cfg = cfg;
        this.truncateFields = ISOUtil.toStringArray(cfg.get("truncate", ""));
        this.protectFields = ISOUtil.toStringArray(cfg.get("protect", ""));
        this.wipeFields = ISOUtil.toStringArray(cfg.get("wipe", ""));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized LogEvent log(LogEvent ev) {
        List<Object> list = ev.getPayLoad();
        synchronized (list) {
            List<Object> payLoad = ev.getPayLoad();
            int size = payLoad.size();
            for (int i = 0; i < size; ++i) {
                Object obj = payLoad.get(i);
                if (!(obj instanceof FSDISOMsg)) continue;
                FSDISOMsg m = (FSDISOMsg)((FSDISOMsg)obj).clone();
                try {
                    this.checkTruncated(m);
                    this.checkProtected(m);
                    this.checkHidden(m);
                }
                catch (ISOException e) {
                    ev.addMessage(e);
                }
                payLoad.set(i, m);
            }
        }
        return ev;
    }

    private void checkTruncated(FSDISOMsg m) throws ISOException {
        for (String truncateField : this.truncateFields) {
            String x;
            String[] truncate = truncateField.split(":");
            if (truncate.length != 2) continue;
            String f = truncate[0];
            int len = Integer.parseInt(truncate[1]);
            String v = null;
            try {
                v = m.getFSDMsg().get(f);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (v == null || !(v instanceof String) || (x = v).length() <= len) continue;
            m.getFSDMsg().set(f, x.substring(0, len));
        }
    }

    private void checkProtected(FSDISOMsg m) throws ISOException {
        for (String f : this.protectFields) {
            String v = null;
            try {
                v = m.getFSDMsg().get(f);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (v == null) continue;
            if (v instanceof String) {
                m.getFSDMsg().set(f, ISOUtil.protect(v));
                continue;
            }
            m.getFSDMsg().set(f, new String(BINARY_WIPED));
        }
    }

    private void checkHidden(FSDISOMsg m) throws ISOException {
        for (String f : this.wipeFields) {
            String v = null;
            try {
                v = m.getFSDMsg().get(f);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (v == null) continue;
            if (v instanceof String) {
                m.getFSDMsg().set(f, WIPED);
                continue;
            }
            m.getFSDMsg().set(f, new String(BINARY_WIPED));
        }
    }
}

