/*
 * Decompiled with CFR 0.152.
 */
package org.jpos.util;

import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jpos.iso.ISOException;
import org.jpos.iso.ISOUtil;
import org.jpos.space.Space;
import org.jpos.space.SpaceFactory;
import org.jpos.util.Loggeable;

public class FSDMsg
implements Loggeable,
Cloneable {
    public static char FS = (char)28;
    public static char US = (char)31;
    public static char GS = (char)29;
    public static char RS = (char)30;
    public static char EOF = '\u0000';
    public static char PIPE = (char)124;
    public static char EOM = '\u0000';
    private static final Set<String> DUMMY_SEPARATORS = new HashSet<String>(Arrays.asList("DS", "EOM"));
    private static final String EOM_SEPARATOR = "EOM";
    Map fields = new LinkedHashMap();
    Map separators = new LinkedHashMap();
    String baseSchema;
    String basePath;
    byte[] header;
    Charset charset;

    public FSDMsg(String basePath) {
        this(basePath, "base");
    }

    public FSDMsg(String basePath, String baseSchema) {
        this.basePath = basePath;
        this.baseSchema = baseSchema;
        this.charset = Charset.forName("ISO8859_1");
        this.setSeparator("FS", FS);
        this.setSeparator("US", US);
        this.setSeparator("GS", GS);
        this.setSeparator("RS", RS);
        this.setSeparator("EOF", EOF);
        this.setSeparator("PIPE", PIPE);
    }

    public String getBasePath() {
        return this.basePath;
    }

    public String getBaseSchema() {
        return this.baseSchema;
    }

    public void setCharset(Charset charset) {
        this.charset = charset;
    }

    public void setSeparator(String separatorName, char separator) {
        this.separators.put(separatorName, Character.valueOf(separator));
    }

    public void unsetSeparator(String separatorName) {
        if (!this.separators.containsKey(separatorName)) {
            throw new RuntimeException("unsetSeparator was attempted for " + separatorName + " which was not previously defined.");
        }
        this.separators.remove(separatorName);
    }

    public void unpack(InputStream is) throws IOException, JDOMException, MalformedURLException {
        try {
            this.unpack(new InputStreamReader(is, this.charset), this.getSchema(this.baseSchema));
        }
        catch (EOFException e) {
            this.fields.put("EOF", "true");
        }
    }

    public void unpack(byte[] b) throws IOException, JDOMException, MalformedURLException {
        this.unpack(new ByteArrayInputStream(b));
    }

    public String pack() throws JDOMException, MalformedURLException, IOException, ISOException {
        StringBuffer sb = new StringBuffer();
        this.pack(this.getSchema(this.baseSchema), sb);
        return sb.toString();
    }

    public byte[] packToBytes() throws JDOMException, IOException, ISOException {
        return this.pack().getBytes(this.charset);
    }

    protected String get(String id, String type, int length, String defValue, String separator) throws ISOException {
        String value = (String)this.fields.get(id);
        if (value == null) {
            value = defValue == null ? "" : defValue;
        }
        type = type.toUpperCase();
        switch (type.charAt(0)) {
            case 'N': {
                if (this.isSeparated(separator)) break;
                value = ISOUtil.zeropad(value, length);
                break;
            }
            case 'A': {
                if (!this.isSeparated(separator)) {
                    value = ISOUtil.strpad(value, length);
                }
                if (value.length() <= length) break;
                value = value.substring(0, length);
                break;
            }
            case 'K': {
                if (defValue == null) break;
                value = defValue;
                break;
            }
            case 'B': {
                if (length << 1 >= value.length()) {
                    if (this.isSeparated(separator)) {
                        value = new String(ISOUtil.hex2byte(value), this.charset);
                        break;
                    }
                    value = new String(ISOUtil.hex2byte(ISOUtil.zeropad(value, length << 1).substring(0, length << 1)), this.charset);
                    break;
                }
                throw new RuntimeException("field content=" + value + " is too long to fit in field " + id + " whose length is " + length);
            }
        }
        return this.isSeparated(separator) && !EOM_SEPARATOR.equals(separator) ? ISOUtil.blankUnPad(value) : value;
    }

    private boolean isSeparated(String separator) {
        if (separator != null) {
            if (this.separators.containsKey(separator)) {
                return true;
            }
            if (this.isDummySeparator(separator)) {
                return true;
            }
            throw new RuntimeException("FSDMsg.isSeparated(String) found that " + separator + " has not been defined as a separator!");
        }
        return false;
    }

    private boolean isDummySeparator(String separator) {
        return DUMMY_SEPARATORS.contains(separator);
    }

    private boolean isBinary(String type) {
        return type.startsWith("B");
    }

    public boolean isSeparator(byte b) {
        return this.separators.containsValue(Character.valueOf((char)b));
    }

    private String getSeparatorType(String type) {
        if (type.length() > 2) {
            return type.substring(1);
        }
        return null;
    }

    private char getSeparator(String separator) {
        if (this.separators.containsKey(separator)) {
            return ((Character)this.separators.get(separator)).charValue();
        }
        if (this.isDummySeparator(separator)) {
            return '\u0000';
        }
        throw new RuntimeException("getSeparator called on separator=" + separator + " which does not resolve to a known separator.");
    }

    protected void pack(Element schema, StringBuffer sb) throws JDOMException, MalformedURLException, IOException, ISOException {
        String keyOff = "";
        String defaultKey = "";
        for (Element elem : schema.getChildren("field")) {
            char c;
            boolean key;
            String id = elem.getAttributeValue("id");
            int length = Integer.parseInt(elem.getAttributeValue("length"));
            String type = elem.getAttributeValue("type");
            String separator = elem.getAttributeValue("separator");
            if (type != null && separator == null) {
                separator = this.getSeparatorType(type);
            }
            Map properties = (key = "true".equals(elem.getAttributeValue("key"))) ? this.loadProperties(elem) : Collections.EMPTY_MAP;
            String defValue = elem.getText();
            if (!properties.isEmpty()) {
                defValue = defValue.replace("\n", "").replace("\t", "").replace("\r", "");
            }
            String value = this.get(id, type, length, defValue, separator);
            sb.append(value);
            if (this.isSeparated(separator) && (c = this.getSeparator(separator)) > '\u0000') {
                sb.append(c);
            }
            if (!key) continue;
            String v = this.isBinary(type) ? ISOUtil.hexString(value.getBytes(this.charset)) : value;
            keyOff = keyOff + this.normalizeKeyValue(v, properties);
            defaultKey = defaultKey + elem.getAttributeValue("default-key");
        }
        if (keyOff.length() > 0) {
            this.pack(this.getSchema(this.getId(schema), keyOff, defaultKey), sb);
        }
    }

    private Map loadProperties(Element elem) {
        HashMap<String, String> props = new HashMap<String, String>();
        for (Element prop : elem.getChildren("property")) {
            String name = prop.getAttributeValue("name");
            String value = prop.getAttributeValue("value");
            props.put(name, value);
        }
        return props;
    }

    private String normalizeKeyValue(String value, Map properties) {
        if (properties.containsKey(value)) {
            return (String)properties.get(value);
        }
        return ISOUtil.normalize(value);
    }

    protected void unpack(InputStreamReader r, Element schema) throws IOException, JDOMException, MalformedURLException {
        Iterator iter = schema.getChildren("field").iterator();
        String keyOff = "";
        String defaultKey = "";
        while (iter.hasNext()) {
            boolean key;
            Element elem = (Element)iter.next();
            String id = elem.getAttributeValue("id");
            int length = Integer.parseInt(elem.getAttributeValue("length"));
            String type = elem.getAttributeValue("type").toUpperCase();
            String separator = elem.getAttributeValue("separator");
            if (type != null && separator == null) {
                separator = this.getSeparatorType(type);
            }
            Map properties = (key = "true".equals(elem.getAttributeValue("key"))) ? this.loadProperties(elem) : Collections.EMPTY_MAP;
            String value = this.readField(r, id, length, type, separator);
            if (key) {
                keyOff = keyOff + this.normalizeKeyValue(value, properties);
                defaultKey = defaultKey + elem.getAttributeValue("default-key");
            }
            if (!"K".equals(type) || value.equals(elem.getText())) continue;
            throw new IllegalArgumentException("Field " + id + " value='" + value + "' expected='" + elem.getText() + "'");
        }
        if (keyOff.length() > 0) {
            this.unpack(r, this.getSchema(this.getId(schema), keyOff, defaultKey));
        }
    }

    private String getId(Element e) {
        String s = e.getAttributeValue("id");
        return s == null ? "" : s;
    }

    protected String read(InputStreamReader r, int len, String type, String separator) throws IOException {
        boolean expectSeparator;
        StringBuilder sb = new StringBuilder();
        char[] c = new char[1];
        boolean separated = expectSeparator = this.isSeparated(separator);
        if (EOM_SEPARATOR.equals(separator)) {
            char[] rest = new char[32];
            int con = 0;
            while ((con = r.read(rest, 0, rest.length)) >= 0) {
                if (rest.length == con) {
                    sb.append(rest);
                    continue;
                }
                sb.append(Arrays.copyOf(rest, con));
            }
        } else if (this.isDummySeparator(separator)) {
            for (int i = 0; i < len && r.read(c) >= 0; ++i) {
                sb.append(c[0]);
            }
        } else {
            for (int i = 0; i < len; ++i) {
                if (r.read(c) < 0) {
                    if (!"EOF".equals(separator)) {
                        throw new EOFException();
                    }
                    separated = false;
                    break;
                }
                if (expectSeparator && c[0] == this.getSeparator(separator)) {
                    separated = false;
                    break;
                }
                sb.append(c[0]);
            }
            if (separated && !"EOF".equals(separator) && r.read(c) < 0) {
                throw new EOFException();
            }
        }
        return sb.toString();
    }

    protected String readField(InputStreamReader r, String fieldName, int len, String type, String separator) throws IOException {
        String fieldValue = this.read(r, len, type, separator);
        if (this.isBinary(type)) {
            fieldValue = ISOUtil.hexString(fieldValue.getBytes(this.charset));
        }
        this.fields.put(fieldName, fieldValue);
        return fieldValue;
    }

    public void set(String name, String value) {
        if (value != null) {
            this.fields.put(name, value);
        } else {
            this.fields.remove(name);
        }
    }

    public void setHeader(byte[] h) {
        this.header = h;
    }

    public byte[] getHeader() {
        return this.header;
    }

    public String getHexHeader() {
        return this.header != null ? ISOUtil.hexString(this.header).substring(2) : "";
    }

    public String get(String fieldName) {
        return (String)this.fields.get(fieldName);
    }

    public String get(String fieldName, String def) {
        String s = (String)this.fields.get(fieldName);
        return s != null ? s : def;
    }

    public void copy(String fieldName, FSDMsg msg) {
        this.fields.put(fieldName, msg.get(fieldName));
    }

    public byte[] getHexBytes(String name) {
        String s = this.get(name);
        return s == null ? null : ISOUtil.hex2byte(s);
    }

    public int getInt(String name) {
        int i = 0;
        try {
            i = Integer.parseInt(this.get(name));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return i;
    }

    public int getInt(String name, int def) {
        int i = def;
        try {
            i = Integer.parseInt(this.get(name));
        }
        catch (Exception e) {
            // empty catch block
        }
        return i;
    }

    public Element toXML() {
        Element e = new Element("message");
        if (this.header != null) {
            e.addContent((Content)new Element("header").setText(this.getHexHeader()));
        }
        for (String fieldName : this.fields.keySet()) {
            Element inner = new Element(fieldName);
            inner.addContent(ISOUtil.normalize((String)this.fields.get(fieldName)));
            e.addContent((Content)inner);
        }
        return e;
    }

    protected Element getSchema() throws JDOMException, IOException {
        return this.getSchema(this.baseSchema);
    }

    protected Element getSchema(String message) throws JDOMException, IOException {
        return this.getSchema(message, "", null);
    }

    protected Element getSchema(String prefix, String suffix, String defSuffix) throws JDOMException, IOException {
        StringBuilder sb = new StringBuilder(this.basePath);
        sb.append(prefix);
        prefix = sb.toString();
        sb.append(suffix);
        sb.append(".xml");
        String uri = sb.toString();
        Space sp = SpaceFactory.getSpace();
        Element schema = (Element)sp.rdp(uri);
        if (schema == null) {
            SAXBuilder builder = new SAXBuilder();
            URL url = new URL(uri);
            File f = new File(url.getFile());
            if (f.exists()) {
                schema = builder.build(url).getRootElement();
            } else if (defSuffix != null) {
                sb = new StringBuilder(prefix);
                sb.append(defSuffix);
                sb.append(".xml");
                url = new URL(sb.toString());
                f = new File(url.getFile());
                if (f.exists()) {
                    schema = builder.build(url).getRootElement();
                }
            }
            if (schema == null) {
                throw new RuntimeException(f.getCanonicalPath() + " not found");
            }
            sp.out(uri, schema);
        }
        return schema;
    }

    public Map getMap() {
        return this.fields;
    }

    public void setMap(Map fields) {
        this.fields = fields;
    }

    @Override
    public void dump(PrintStream p, String indent) {
        String inner = indent + "  ";
        p.println(indent + "<fsdmsg schema='" + this.basePath + this.baseSchema + "'>");
        if (this.header != null) {
            this.append(p, "header", this.getHexHeader(), inner);
        }
        for (String f : this.fields.keySet()) {
            String v = (String)this.fields.get(f);
            this.append(p, f, v, inner);
        }
        p.println(indent + "</fsdmsg>");
    }

    private void append(PrintStream p, String f, String v, String indent) {
        p.println(indent + f + ": '" + v + "'");
    }

    public boolean hasField(String fieldName) {
        return this.fields.containsKey(fieldName);
    }

    public Object clone() {
        try {
            FSDMsg m = (FSDMsg)super.clone();
            m.fields = (Map)((LinkedHashMap)this.fields).clone();
            return m;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public void merge(FSDMsg m) {
        for (Map.Entry entry : m.fields.entrySet()) {
            this.set((String)entry.getKey(), (String)entry.getValue());
        }
    }
}

