/*
 * Decompiled with CFR 0.152.
 */
package org.jpos.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.StringTokenizer;
import java.util.Vector;
import org.jpos.core.Configurable;
import org.jpos.core.Configuration;
import org.jpos.core.ConfigurationException;
import org.jpos.iso.ISOException;
import org.jpos.iso.ISOUtil;
import org.jpos.util.Destroyable;
import org.jpos.util.LogEvent;
import org.jpos.util.Logger;
import org.jpos.util.SimpleLogSource;
import org.jpos.util.ThreadPool;

public class DirPoll
extends SimpleLogSource
implements Runnable,
FilenameFilter,
Configurable,
Destroyable {
    private long pollInterval;
    private File requestDir;
    private File responseDir;
    private File tmpDir;
    private File badDir;
    private File runDir;
    private File archiveDir;
    private Vector prio = new Vector();
    private int currentPriority;
    private String basePath;
    private String responseSuffix;
    private ThreadPool pool;
    private Object processor;
    private boolean shutdown;
    private boolean paused = false;
    private boolean shouldArchive;
    private boolean shouldTimestampArchive;
    private String archiveDateFormat;
    private boolean acceptZeroLength = false;

    public DirPoll() {
        this.setPollInterval(1000L);
        this.setPath(".");
        this.pool = null;
    }

    public synchronized void setPath(String base) {
        this.basePath = base;
        this.requestDir = new File(base, "request");
        this.responseDir = new File(base, "response");
        this.tmpDir = new File(base, "tmp");
        this.badDir = new File(base, "bad");
        this.runDir = new File(base, "run");
        this.archiveDir = new File(base, "archive");
    }

    public void setShouldTimestampArchive(boolean shouldTimestampArchive) {
        this.shouldTimestampArchive = shouldTimestampArchive;
    }

    public void setArchiveDateFormat(String dateFormat) {
        this.archiveDateFormat = dateFormat;
    }

    public void setShouldArchive(boolean shouldArchive) {
        this.shouldArchive = shouldArchive;
    }

    public void setAcceptZeroLength(boolean acceptZeroLength) {
        this.acceptZeroLength = acceptZeroLength;
    }

    public String getPath() {
        return this.basePath;
    }

    public void setRequestDir(String dir) {
        this.requestDir = new File(this.basePath, dir);
    }

    public void setResponseDir(String dir) {
        this.responseDir = new File(this.basePath, dir);
    }

    public void setTmpDir(String dir) {
        this.tmpDir = new File(this.basePath, dir);
    }

    public void setBadDir(String dir) {
        this.badDir = new File(this.basePath, dir);
    }

    public void setRunDir(String dir) {
        this.runDir = new File(this.basePath, dir);
    }

    public void setArchiveDir(String dir) {
        this.archiveDir = new File(this.basePath, dir);
    }

    public void setPollInterval(long pollInterval) {
        this.pollInterval = pollInterval;
    }

    public void setResponseSuffix(String suffix) {
        this.responseSuffix = suffix;
    }

    public long getPollInterval() {
        return this.pollInterval;
    }

    public void setProcessor(Object processor) {
        this.processor = processor;
    }

    public Object getProcessor() {
        return this.processor;
    }

    @Override
    public void setConfiguration(Configuration cfg) throws ConfigurationException {
        if (cfg != null) {
            if (this.processor instanceof Configurable) {
                ((Configurable)this.processor).setConfiguration(cfg);
            }
            this.setRequestDir(cfg.get("request.dir", "request"));
            this.setResponseDir(cfg.get("response.dir", "response"));
            this.setTmpDir(cfg.get("tmp.dir", "tmp"));
            this.setRunDir(cfg.get("run.dir", "run"));
            this.setBadDir(cfg.get("bad.dir", "bad"));
            this.setArchiveDir(cfg.get("archive.dir", "archive"));
            this.setResponseSuffix(cfg.get("response.suffix", null));
            this.setShouldArchive(cfg.getBoolean("archive", false));
            this.setAcceptZeroLength(cfg.getBoolean("zero-length", false));
            this.setArchiveDateFormat(cfg.get("archive.dateformat", "yyyyMMddHHmmss"));
            this.setShouldTimestampArchive(cfg.getBoolean("archive.timestamp", false));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPriorities(String priorities) {
        StringTokenizer st = new StringTokenizer(priorities);
        Vector<String> v = new Vector<String>();
        while (st.hasMoreTokens()) {
            String ext = st.nextToken();
            v.addElement(ext.equals("*") ? "" : ext);
        }
        if (v.isEmpty()) {
            v.addElement("");
        }
        DirPoll dirPoll = this;
        synchronized (dirPoll) {
            this.prio = v;
        }
    }

    public synchronized void setThreadPool(ThreadPool pool) {
        this.pool = pool;
    }

    @Override
    public boolean accept(File dir, String name) {
        String ext;
        String string = ext = this.currentPriority >= 0 ? (String)this.prio.elementAt(this.currentPriority) : null;
        if (ext != null && !name.endsWith(ext)) {
            return false;
        }
        File f = new File(dir, name);
        boolean result = this.acceptZeroLength ? f.isFile() : f.isFile() && f.length() > 0L;
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Thread.currentThread().setName("DirPoll-" + this.basePath);
        if (this.prio.isEmpty()) {
            this.addPriority("");
        }
        while (!this.shutdown) {
            DirPoll dirPoll = this;
            synchronized (dirPoll) {
                if (this.paused) {
                    try {
                        this.wait();
                        this.paused = false;
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                }
            }
            try {
                File f;
                DirPoll e = this;
                synchronized (e) {
                    f = this.scan();
                }
                if (f != null) {
                    this.getPool().execute(new ProcessorRunner(f));
                    Thread.yield();
                    continue;
                }
                Thread.sleep(this.pollInterval);
            }
            catch (InterruptedException e) {
            }
            catch (Throwable e) {
                Logger.log(new LogEvent(this, "dirpoll", e));
                try {
                    Thread.sleep(this.pollInterval * 10L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    @Override
    public void destroy() {
        this.shutdown = true;
    }

    public void createDirs() {
        this.requestDir.mkdirs();
        this.responseDir.mkdirs();
        this.tmpDir.mkdirs();
        this.badDir.mkdirs();
        this.runDir.mkdirs();
        this.archiveDir.mkdirs();
    }

    public void addPriority(String fileExtension) {
        this.prio.addElement(fileExtension);
    }

    private byte[] readRequest(File f) throws IOException {
        byte[] b = new byte[(int)f.length()];
        FileInputStream in = new FileInputStream(f);
        in.read(b);
        in.close();
        return b;
    }

    private void writeResponse(String requestName, byte[] b) throws IOException {
        int pos;
        if (this.responseSuffix != null && (pos = requestName.lastIndexOf(46)) > 0) {
            requestName = requestName.substring(0, pos) + this.responseSuffix;
        }
        File tmp = new File(this.tmpDir, requestName);
        FileOutputStream out = new FileOutputStream(tmp);
        out.write(b);
        out.close();
        this.moveTo(tmp, this.responseDir);
    }

    private File moveTo(File f, File dir) throws IOException {
        File destination = new File(dir, f.getName());
        if (!f.renameTo(destination)) {
            throw new IOException("Unable to move" + f.getName());
        }
        return destination;
    }

    private void store(File f, File destinationDirectory) throws IOException {
        File destination;
        String storedFilename = f.getName();
        if (this.shouldTimestampArchive) {
            storedFilename = f.getName() + "." + new SimpleDateFormat(this.archiveDateFormat).format(new Date());
        }
        if (!f.renameTo(destination = new File(destinationDirectory, storedFilename))) {
            throw new IOException("Unable to archive '" + f.getName() + "' in directory " + destinationDirectory);
        }
    }

    private File scan() {
        this.currentPriority = 0;
        while (this.currentPriority < this.prio.size()) {
            String[] files = this.requestDir.list(this);
            if (files != null && files.length > 0) {
                return new File(this.requestDir, files[0]);
            }
            ++this.currentPriority;
        }
        return null;
    }

    private synchronized ThreadPool getPool() {
        if (this.pool == null) {
            this.pool = new ThreadPool(1, 10);
        }
        return this.pool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pause() {
        DirPoll dirPoll = this;
        synchronized (dirPoll) {
            if (!this.paused) {
                this.paused = true;
                this.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unpause() {
        DirPoll dirPoll = this;
        synchronized (dirPoll) {
            if (this.paused) {
                this.paused = false;
                this.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isPaused() {
        DirPoll dirPoll = this;
        synchronized (dirPoll) {
            return this.paused;
        }
    }

    public static class DirPollException
    extends ISOException {
        boolean retry;

        public DirPollException() {
        }

        public DirPollException(String detail) {
            super(detail);
        }

        public DirPollException(Exception nested) {
            super(nested);
        }

        public DirPollException(String detail, Exception nested) {
            super(detail, nested);
        }

        public boolean isRetry() {
            return this.retry;
        }

        public void setRetry(boolean retry) {
            this.retry = retry;
        }
    }

    public class ProcessorRunner
    implements Runnable {
        File request;
        LogEvent logEvent;

        public ProcessorRunner(File request) throws IOException {
            this.request = DirPoll.this.moveTo(request, DirPoll.this.runDir);
            this.logEvent = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block17: {
                LogEvent evt = new LogEvent(DirPoll.this, "dirpoll", this.request.getName());
                try {
                    if (DirPoll.this.processor == null) {
                        throw new DirPollException("null processor - nothing to do");
                    }
                    if (DirPoll.this.processor instanceof Processor) {
                        byte[] resp = ((Processor)DirPoll.this.processor).process(this.request.getName(), DirPoll.this.readRequest(this.request));
                        if (resp != null) {
                            DirPoll.this.writeResponse(this.request.getName(), resp);
                        }
                    } else if (DirPoll.this.processor instanceof FileProcessor) {
                        ((FileProcessor)DirPoll.this.processor).process(this.request);
                    }
                    if (DirPoll.this.shouldArchive) {
                        DirPoll.this.store(this.request, DirPoll.this.archiveDir);
                    } else if (!this.request.delete()) {
                        throw new DirPollException("error: can't unlink request " + this.request.getName());
                    }
                }
                catch (Throwable e) {
                    this.logEvent = evt;
                    evt.addMessage(e);
                    try {
                        if (e instanceof DirPollException && ((DirPollException)e).isRetry()) {
                            ISOUtil.sleep(DirPoll.this.pollInterval * 10L);
                            evt.addMessage("retrying");
                            DirPoll.this.store(this.request, DirPoll.this.requestDir);
                            break block17;
                        }
                        DirPoll.this.store(this.request, DirPoll.this.badDir);
                    }
                    catch (IOException _e) {
                        evt.addMessage("Can't move to " + DirPoll.this.badDir.getPath());
                        evt.addMessage(_e);
                    }
                }
                finally {
                    if (this.logEvent != null) {
                        Logger.log(this.logEvent);
                    }
                }
            }
        }
    }

    public static interface FileProcessor {
        public void process(File var1) throws DirPollException;
    }

    public static interface Processor {
        public byte[] process(String var1, byte[] var2) throws DirPollException;
    }
}

