/*
 * Decompiled with CFR 0.152.
 */
package org.jpos.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TimerTask;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.jpos.core.Configuration;
import org.jpos.core.ConfigurationException;
import org.jpos.util.DefaultTimer;
import org.jpos.util.RotateLogListener;

public class DailyLogListener
extends RotateLogListener {
    private static final String DEF_SUFFIX = ".log";
    private static final int DEF_WIN = 86400;
    private static final long DEF_MAXSIZE = -1L;
    private static final String DEF_DATE_FMT = "-yyyy-MM-dd";
    private static final int NONE = 0;
    private static final int GZIP = 1;
    private static final int ZIP = 2;
    private static final int DEF_COMPRESSION = 0;
    private static final int DEF_BUFFER_SIZE = 131072;
    private static final String[] DEF_COMPRESSED_SUFFIX = new String[]{"", ".gz", ".zip"};
    private static final Map<String, Integer> COMPRESSION_FORMATS = new HashMap<String, Integer>(3);
    private String suffix = ".log";
    private String prefix;
    private int rotateCount;
    private DateFormat dateFmt = new SimpleDateFormat("-yyyy-MM-dd");
    private String lastDate;
    private String compressedSuffix = DEF_COMPRESSED_SUFFIX[0];
    private int compressionFormat = 0;
    private int compressionBufferSize = 131072;

    public DailyLogListener() {
        this.setLastDate(this.getDateFmt().format(new Date()));
    }

    @Override
    public void setConfiguration(Configuration cfg) throws ConfigurationException {
        Date time;
        String suffix = cfg.get("suffix", DEF_SUFFIX);
        String prefix = cfg.get("prefix");
        this.setSuffix(suffix);
        this.setPrefix(prefix);
        Integer formatObj = COMPRESSION_FORMATS.get(cfg.get("compression-format", "none").toLowerCase());
        int compressionFormat = formatObj == null ? 0 : formatObj;
        this.setCompressionFormat(compressionFormat);
        this.setCompressedSuffix(cfg.get("compressed-suffix", DEF_COMPRESSED_SUFFIX[compressionFormat]));
        this.setCompressionBufferSize(cfg.getInt("compression-buffer-size", 131072));
        this.logName = prefix + suffix;
        this.maxSize = cfg.getLong("maxsize", -1L);
        try {
            this.openLogFile();
        }
        catch (IOException e) {
            throw new ConfigurationException("error opening file: " + this.logName, e);
        }
        this.sleepTime = cfg.getInt("window", 86400);
        if (this.sleepTime <= 0L) {
            this.sleepTime = 86400L;
        }
        this.sleepTime *= 1000L;
        SimpleDateFormat fmt = new SimpleDateFormat(cfg.get("date-format", DEF_DATE_FMT));
        this.setDateFmt(fmt);
        this.setLastDate(fmt.format(new Date()));
        try {
            time = new SimpleDateFormat("HH:mm:ss").parse(cfg.get("first-rotate-time", "00:00:00"));
        }
        catch (ParseException ex) {
            throw new ConfigurationException("Bad 'first-rotate-time' format expected HH(0-23):mm:ss ", ex);
        }
        String strDate = cfg.get("first-rotate-date", null);
        Calendar cal = Calendar.getInstance();
        cal.set(14, 0);
        Calendar calTemp = Calendar.getInstance();
        calTemp.setTime(time);
        cal.set(13, calTemp.get(13));
        cal.set(12, calTemp.get(12));
        cal.set(11, calTemp.get(11));
        if (strDate != null) {
            Date date;
            try {
                date = new SimpleDateFormat("yyyy-MM-dd").parse(strDate);
            }
            catch (ParseException ex) {
                throw new ConfigurationException("Bad 'first-rotate-date' format, expected (yyyy-MM-dd)", ex);
            }
            calTemp.setTime(date);
            cal.set(calTemp.get(1), calTemp.get(2), calTemp.get(5));
        }
        calTemp.setTime(new Date());
        if (cal.before(calTemp)) {
            long n = (calTemp.getTimeInMillis() - cal.getTimeInMillis()) / this.sleepTime;
            cal.setTimeInMillis(cal.getTimeInMillis() + this.sleepTime * (n + 1L));
        }
        this.rotate = new DailyRotate();
        DefaultTimer.getTimer().scheduleAtFixedRate((TimerTask)this.rotate, cal.getTime(), this.sleepTime);
    }

    @Override
    public synchronized void logRotate() throws IOException {
        this.closeLogFile();
        super.close();
        this.setPrintStream(null);
        String suffix = this.getSuffix() + this.getCompressedSuffix();
        String newName = this.getPrefix() + this.getLastDate();
        int i = 0;
        File dest = new File(newName + suffix);
        File source = new File(this.logName);
        while (dest.exists()) {
            dest = new File(newName + "." + ++i + suffix);
        }
        source.renameTo(dest);
        this.setLastDate(this.getDateFmt().format(new Date()));
        this.openLogFile();
        this.compress(dest);
    }

    public String getSuffix() {
        return this.suffix;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public int getRotateCount() {
        return this.rotateCount;
    }

    public void setRotateCount(int rotateCount) {
        this.rotateCount = rotateCount;
    }

    public DateFormat getDateFmt() {
        return this.dateFmt;
    }

    public void setDateFmt(DateFormat dateFmt) {
        this.dateFmt = dateFmt;
    }

    public String getLastDate() {
        return this.lastDate;
    }

    public void setLastDate(String lastDate) {
        this.lastDate = lastDate;
    }

    public String getCompressedSuffix() {
        return this.compressedSuffix;
    }

    public void setCompressedSuffix(String compressedSuffix) {
        this.compressedSuffix = compressedSuffix;
    }

    protected Thread getCompressorThread(File f) {
        return new Thread((Runnable)new Compressor(f), "DailyLogListener-Compressor");
    }

    protected OutputStream getCompressedOutputStream(File f) throws IOException {
        BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(f));
        if (this.getCompressionFormat() == 2) {
            ZipOutputStream ret = new ZipOutputStream(os);
            ret.putNextEntry(new ZipEntry(this.logName));
            return ret;
        }
        return new GZIPOutputStream(os);
    }

    protected void closeCompressedOutputStream(OutputStream os) throws IOException {
        if (os instanceof DeflaterOutputStream) {
            ((DeflaterOutputStream)os).finish();
        }
        os.close();
    }

    protected void logDebugEx(String msg, Throwable e) {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(os);
        ps.println(msg);
        e.printStackTrace(ps);
        ps.close();
        this.logDebug(os.toString());
    }

    public int getCompressionFormat() {
        return this.compressionFormat;
    }

    public void setCompressionFormat(int compressionFormat) {
        this.compressionFormat = compressionFormat;
    }

    public int getCompressionBufferSize() {
        return this.compressionBufferSize;
    }

    public void setCompressionBufferSize(int compressionBufferSize) {
        this.compressionBufferSize = compressionBufferSize >= 0 ? compressionBufferSize : 131072;
    }

    @Override
    protected void checkSize() {
        if (this.maxSize > 0L) {
            super.checkSize();
        }
    }

    protected void compress(File logFile) {
        Thread t;
        if (this.getCompressionFormat() != 0 && (t = this.getCompressorThread(logFile)) != null) {
            t.start();
        }
    }

    static {
        COMPRESSION_FORMATS.put("none", 0);
        COMPRESSION_FORMATS.put("gzip", 1);
        COMPRESSION_FORMATS.put("zip", 2);
    }

    final class DailyRotate
    extends RotateLogListener.Rotate {
        DailyRotate() {
            super(DailyLogListener.this);
        }

        @Override
        public void run() {
            super.run();
            DailyLogListener.this.setLastDate(DailyLogListener.this.getDateFmt().format(new Date(this.scheduledExecutionTime())));
        }
    }

    protected class Compressor
    implements Runnable {
        File f;

        public Compressor(File f) {
            this.f = f;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        @Override
        public void run() {
            block23: {
                int read;
                OutputStream os = null;
                InputStream is = null;
                File tmp = null;
                tmp = File.createTempFile(this.f.getName(), ".tmp", this.f.getParentFile());
                os = DailyLogListener.this.getCompressedOutputStream(tmp);
                is = new BufferedInputStream(new FileInputStream(this.f));
                byte[] buff = new byte[DailyLogListener.this.getCompressionBufferSize()];
                do {
                    if ((read = is.read(buff)) <= 0) continue;
                    os.write(buff, 0, read);
                } while (read > 0);
                try {
                    if (is != null) {
                        is.close();
                    }
                    if (os != null) {
                        DailyLogListener.this.closeCompressedOutputStream(os);
                    }
                    if (this.f != null) {
                        this.f.delete();
                        if (tmp != null) {
                            tmp.renameTo(this.f);
                        }
                    }
                    break block23;
                }
                catch (Throwable ex) {
                    DailyLogListener.this.logDebugEx("error closing files", ex);
                }
                break block23;
                catch (Throwable ex) {
                    try {
                        DailyLogListener.this.logDebugEx("error compressing file " + this.f, ex);
                    }
                    catch (Throwable throwable) {
                        try {
                            if (is != null) {
                                is.close();
                            }
                            if (os != null) {
                                DailyLogListener.this.closeCompressedOutputStream(os);
                            }
                            if (this.f != null) {
                                this.f.delete();
                                if (tmp != null) {
                                    tmp.renameTo(this.f);
                                }
                            }
                        }
                        catch (Throwable ex2) {
                            DailyLogListener.this.logDebugEx("error closing files", ex2);
                        }
                        throw throwable;
                    }
                    try {
                        if (is != null) {
                            is.close();
                        }
                        if (os != null) {
                            DailyLogListener.this.closeCompressedOutputStream(os);
                        }
                        if (this.f != null) {
                            this.f.delete();
                            if (tmp != null) {
                                tmp.renameTo(this.f);
                            }
                        }
                    }
                    catch (Throwable ex3) {
                        DailyLogListener.this.logDebugEx("error closing files", ex3);
                    }
                }
            }
        }
    }
}

