/*
 * Decompiled with CFR 0.152.
 */
package org.jpos.util;

import java.util.ArrayList;
import java.util.List;
import org.jpos.core.Configurable;
import org.jpos.core.Configuration;
import org.jpos.core.ConfigurationException;
import org.jpos.util.FrozenLogEvent;
import org.jpos.util.LogEvent;
import org.jpos.util.LogListener;
import org.jpos.util.LogProducer;
import org.jpos.util.NameRegistrar;

public class BufferedLogListener
implements LogListener,
Configurable,
LogProducer {
    int maxSize;
    String name;
    public static final int DEFAULT_SIZE = 100;
    List<LogListener> listeners = new ArrayList<LogListener>();
    final List<LogEvent> events = new ArrayList<LogEvent>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LogEvent log(LogEvent ev) {
        List<LogEvent> list = this.events;
        synchronized (list) {
            this.events.add(new FrozenLogEvent(ev));
            while (this.events.size() > this.maxSize) {
                this.events.remove(0);
            }
        }
        this.notifyListeners(ev);
        return ev;
    }

    @Override
    public void setConfiguration(Configuration cfg) throws ConfigurationException {
        this.maxSize = cfg.getInt("size", 100);
        if (this.name != null) {
            NameRegistrar.unregister(this.name);
        }
        this.name = cfg.get("name", null);
        if (this.name != null) {
            NameRegistrar.register(this.name, this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(LogListener listener) {
        List<LogEvent> list = this.events;
        synchronized (list) {
            for (LogEvent ev : this.events) {
                listener.log(ev);
            }
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeListener(LogListener listener) {
        List<LogEvent> list = this.events;
        synchronized (list) {
            this.listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAllListeners() {
        List<LogEvent> list = this.events;
        synchronized (list) {
            this.listeners.clear();
        }
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListeners(LogEvent evt) {
        List<LogEvent> list = this.events;
        synchronized (list) {
            for (LogListener listener : this.listeners) {
                listener.log(evt);
            }
        }
    }
}

