/*
 * Decompiled with CFR 0.152.
 */
package org.jpos.util;

import java.util.LinkedList;

public class BlockingQueue {
    private LinkedList queue = new LinkedList();
    private boolean closed = false;
    private int consumers = 0;

    public synchronized void enqueue(Object o) throws Closed {
        if (this.closed) {
            throw new Closed();
        }
        this.queue.addLast(o);
        this.notify();
    }

    public synchronized void requeue(Object o) throws Closed {
        if (this.closed) {
            throw new Closed();
        }
        this.queue.addFirst(o);
        this.notify();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Object dequeue() throws InterruptedException, Closed {
        ++this.consumers;
        try {
            while (this.queue.size() == 0) {
                this.wait();
                if (!this.closed) continue;
                throw new Closed();
            }
        }
        finally {
            --this.consumers;
        }
        return this.queue.removeFirst();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Object dequeue(long timeout) throws InterruptedException, Closed {
        if (timeout == 0L) {
            return this.dequeue();
        }
        ++this.consumers;
        long maxTime = System.currentTimeMillis() + timeout;
        try {
            while (this.queue.size() == 0 && System.currentTimeMillis() < maxTime) {
                this.wait(timeout);
                if (!this.closed) continue;
                throw new Closed();
            }
        }
        finally {
            --this.consumers;
        }
        return this.queue.size() > 0 ? this.queue.removeFirst() : null;
    }

    public synchronized void close() {
        this.closed = true;
        this.notifyAll();
    }

    public synchronized int consumerCount() {
        return this.consumers;
    }

    public synchronized boolean ready() {
        return !this.closed;
    }

    public synchronized int pending() {
        return this.queue.size();
    }

    public LinkedList getQueue() {
        return this.queue;
    }

    public void setQueue(LinkedList queue) {
        this.queue = queue;
    }

    public static class Closed
    extends RuntimeException {
        private static final long serialVersionUID = 3404885702116373450L;

        public Closed() {
            super("queue closed");
        }
    }
}

