/*
 * Decompiled with CFR 0.152.
 */
package org.jpos.ui.factory;

import java.awt.Color;
import java.awt.Font;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import javax.swing.JComponent;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import org.jdom.Element;
import org.jpos.ui.UI;
import org.jpos.ui.UIFactory;
import org.jpos.util.LogEvent;
import org.jpos.util.LogListener;
import org.jpos.util.LogProducer;
import org.jpos.util.NameRegistrar;

public class LogListenerFactory
implements UIFactory {
    @Override
    public JComponent create(UI ui, Element e) {
        JTextArea textArea = new JTextArea(25, 80);
        String font = e.getAttributeValue("font");
        if (font != null) {
            textArea.setFont(Font.decode(font));
        }
        textArea.setBackground(Color.black);
        textArea.setForeground(Color.white);
        String logId = e.getAttributeValue("logger", "Q2");
        try {
            int maxEvents = Integer.parseInt(e.getAttributeValue("max-events", "100"));
            int maxLines = Integer.parseInt(e.getAttributeValue("max-lines", "1000"));
            LogProducer logger = (LogProducer)NameRegistrar.get("logger." + logId);
            logger.addListener(new Listener(logger, ui, textArea, maxEvents, maxLines));
        }
        catch (NameRegistrar.NotFoundException ex) {
            textArea.setText(ex.toString());
        }
        return textArea;
    }

    public static class Listener
    implements LogListener,
    Runnable {
        final LogProducer logger;
        JTextArea text;
        UI ui;
        int cnt;
        int maxEvents;
        int maxLines;

        public Listener(LogProducer logger, UI ui, JTextArea text, int maxEvents, int maxLines) {
            this.ui = ui;
            this.text = text;
            this.logger = logger;
            this.cnt = 0;
            this.maxEvents = maxEvents;
            this.maxLines = maxLines;
            text.setEditable(false);
        }

        @Override
        public void run() {
            if (this.ui.isDestroyed()) {
                this.logger.removeListener(this);
                this.text.setText("");
                return;
            }
            int lc = this.text.getLineCount();
            if (lc > this.maxLines) {
                try {
                    int startOffset = this.text.getLineStartOffset(this.maxLines);
                    int endOffset = this.text.getLineEndOffset(lc - 1);
                    this.text.getDocument().remove(startOffset, endOffset - startOffset);
                }
                catch (BadLocationException ex) {
                    this.text.setText(ex.toString());
                }
            }
        }

        @Override
        public LogEvent log(LogEvent evt) {
            if (this.ui.isDestroyed()) {
                SwingUtilities.invokeLater(this);
                return evt;
            }
            ByteArrayOutputStream str = new ByteArrayOutputStream();
            PrintStream ps = new PrintStream(str);
            evt.dump(ps, "");
            this.text.insert(str.toString(), 0);
            if (++this.cnt % this.maxEvents == 0) {
                SwingUtilities.invokeLater(this);
            }
            return evt;
        }
    }
}

