/*
 * Decompiled with CFR 0.152.
 */
package org.jpos.ui.factory;

import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import org.jdom.Element;
import org.jpos.ui.UI;
import org.jpos.ui.UIFactory;

public class JTreeFactory
implements UIFactory {
    @Override
    public JComponent create(UI ui, Element e) {
        final UI parentUI = ui;
        final HashMap map = new HashMap();
        final JTree tree = new JTree(this.getNode(e, map));
        String font = e.getAttributeValue("font");
        if (font != null) {
            tree.setFont(Font.decode(font));
        }
        tree.setRootVisible(e.getTextTrim().length() > 0);
        tree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent evt) {
                String s;
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)tree.getLastSelectedPathComponent();
                if (node != null && (s = (String)map.get(node)) != null) {
                    ActionListener al;
                    StringTokenizer st = new StringTokenizer(s);
                    String action = st.nextToken();
                    String command = null;
                    if (st.hasMoreTokens()) {
                        command = st.nextToken();
                    }
                    if ((al = (ActionListener)parentUI.get(action)) != null) {
                        al.actionPerformed(new ActionEvent(node, 0, command));
                    }
                }
            }
        });
        return tree;
    }

    private DefaultMutableTreeNode getNode(Element e, Map map) {
        DefaultMutableTreeNode node = new DefaultMutableTreeNode(e.getTextTrim());
        String action = e.getAttributeValue("action");
        if (action != null) {
            String command = e.getAttributeValue("command");
            if (command != null) {
                action = action + " " + command;
            }
            map.put(node, action);
        }
        Iterator iter = e.getChildren().iterator();
        while (iter.hasNext()) {
            node.add(this.getNode((Element)iter.next(), map));
        }
        return node;
    }
}

