/*
 * Decompiled with CFR 0.152.
 */
package org.jpos.ui.factory;

import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLFrameHyperlinkEvent;
import org.jdom.Element;
import org.jpos.ui.UI;
import org.jpos.ui.UIFactory;

public class HtmlFactory
implements UIFactory {
    @Override
    public JComponent create(UI ui, Element e) {
        try {
            JEditorPane editorPane = new JEditorPane(e.getText());
            editorPane.setEditable("true".equals(e.getAttributeValue("editable")));
            if ("true".equals(e.getAttributeValue("follow-links"))) {
                editorPane.addHyperlinkListener(new Listener());
            }
            return editorPane;
        }
        catch (Exception ex) {
            return new JLabel(ex.getMessage());
        }
    }

    static class Listener
    implements HyperlinkListener {
        Listener() {
        }

        @Override
        public void hyperlinkUpdate(HyperlinkEvent e) {
            if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                JEditorPane pane = (JEditorPane)e.getSource();
                if (e instanceof HTMLFrameHyperlinkEvent) {
                    HTMLFrameHyperlinkEvent evt = (HTMLFrameHyperlinkEvent)e;
                    HTMLDocument doc = (HTMLDocument)pane.getDocument();
                    doc.processHTMLFrameHyperlinkEvent(evt);
                } else {
                    try {
                        pane.setPage(e.getURL());
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                }
            }
        }
    }
}

