/*
 * Decompiled with CFR 0.152.
 */
package org.jpos.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.awt.event.ActionListener;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jpos.ui.UIAware;
import org.jpos.ui.UIFactory;
import org.jpos.ui.UIObjectFactory;
import org.jpos.util.Log;

public class UI
implements UIFactory,
UIObjectFactory {
    JFrame mainFrame;
    Map registrar = new HashMap();
    Map mapping = new HashMap();
    Element config;
    UIObjectFactory objFactory;
    Log log;
    boolean destroyed = false;
    static final ResourceBundle classMapping = ResourceBundle.getBundle(UI.class.getName());

    public UI() {
        this.setObjectFactory(this);
    }

    public UI(Element config) {
        this();
        this.setConfig(config);
    }

    public void setObjectFactory(UIObjectFactory objFactory) {
        this.objFactory = objFactory;
    }

    public void setConfig(Element config) {
        this.config = config;
    }

    public void setLog(Log log) {
        this.log = log;
    }

    public Log getLog() {
        return this.log;
    }

    public Map getRegistrar() {
        return this.registrar;
    }

    public Object get(String id) {
        return this.registrar.get(id);
    }

    @Override
    public JComponent create(UI ui, Element e) {
        return this.create(e);
    }

    @Override
    public Object newInstance(String clazz) throws Exception {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        Class<?> type = cl.loadClass(clazz);
        return type.newInstance();
    }

    public void configure() throws JDOMException {
        this.configure(this.config);
    }

    public void reconfigure(String elementName, String panelName) {
        Container c;
        Container container = c = panelName == null ? this.mainFrame.getContentPane() : (JComponent)this.get(panelName);
        if (c != null) {
            c.removeAll();
            c.add(this.createComponent(this.config.getChild(elementName)));
            if (c instanceof JComponent) {
                ((JComponent)c).revalidate();
            }
            c.repaint();
        }
    }

    public void dispose() {
        this.destroyed = true;
        for (JFrame jFrame : Arrays.asList(Frame.getFrames())) {
            this.removeComponent(jFrame);
        }
    }

    public boolean isDestroyed() {
        return this.destroyed;
    }

    protected void configure(Element ui) throws JDOMException {
        this.setLookAndFeel(ui);
        this.createMappings(ui);
        this.createObjects(ui, "object");
        this.createObjects(ui, "action");
        if (!"ui".equals(ui.getName())) {
            ui = ui.getChild("ui");
        }
        if (ui != null) {
            JFrame frame = this.initFrame(ui);
            Element mb = ui.getChild("menubar");
            if (mb != null) {
                frame.setJMenuBar(this.buildMenuBar(mb));
            }
            frame.setContentPane(this.createComponent(ui.getChild("components")));
            if ("true".equals(ui.getAttributeValue("full-screen"))) {
                GraphicsDevice device = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
                frame.setUndecorated("true".equals(ui.getAttributeValue("undecorated")));
                device.setFullScreenWindow(frame);
            } else {
                frame.show();
            }
        }
    }

    private void removeComponent(Component c) {
        if (c instanceof Container) {
            Component[] cc;
            Container cont = (Container)c;
            for (Component aCc : cc = cont.getComponents()) {
                this.removeComponent(aCc);
            }
            cont.removeAll();
        }
    }

    private void dumpComponent(Component c) {
        System.out.println(c.getClass().getName() + ":" + c.getBounds().getSize().toString());
        if (c instanceof Container) {
            Component[] cc;
            for (Component aCc : cc = ((Container)c).getComponents()) {
                this.dumpComponent(aCc);
            }
        }
    }

    private JFrame initFrame(Element ui) {
        Element caption = ui.getChild("caption");
        this.mainFrame = caption == null ? new JFrame() : new JFrame(caption.getText());
        JOptionPane.setRootFrame(this.mainFrame);
        this.mainFrame.getContentPane().setLayout(new BorderLayout());
        String close = ui.getAttributeValue("close");
        if ("false".equals(close)) {
            this.mainFrame.setDefaultCloseOperation(0);
        } else if ("exit".equals(close)) {
            this.mainFrame.setDefaultCloseOperation(3);
        }
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.mainFrame.setSize(this.getDimension(ui, screenSize));
        this.locateOnScreen(this.mainFrame);
        return this.mainFrame;
    }

    private void locateOnScreen(Frame frame) {
        Dimension paneSize = frame.getSize();
        Dimension screenSize = frame.getToolkit().getScreenSize();
        frame.setLocation((screenSize.width - paneSize.width) / 2, (screenSize.height - paneSize.height) / 2);
    }

    private JMenuBar buildMenuBar(Element ui) {
        JMenuBar mb = new JMenuBar();
        Iterator iter = ui.getChildren("menu").iterator();
        while (iter.hasNext()) {
            mb.add(this.menu((Element)iter.next()));
        }
        return mb;
    }

    private JMenu menu(Element m) {
        JMenu menu = new JMenu(m.getAttributeValue("id"));
        this.setItemAttributes(menu, m);
        Iterator iter = m.getChildren().iterator();
        while (iter.hasNext()) {
            this.addMenuItem(menu, (Element)iter.next());
        }
        return menu;
    }

    private void addMenuItem(JMenu menu, Element m) {
        String tag = m.getName();
        if ("menuitem".equals(tag)) {
            JMenuItem item = new JMenuItem(m.getAttributeValue("id"));
            this.setItemAttributes(item, m);
            menu.add(item);
        } else if ("menuseparator".equals(tag)) {
            menu.addSeparator();
        } else if ("button-group".equals(tag)) {
            this.addButtonGroup(menu, m);
        } else if ("check-box".equals(tag)) {
            JCheckBoxMenuItem item = new JCheckBoxMenuItem(m.getAttributeValue("id"));
            this.setItemAttributes(item, m);
            item.setState("true".equals(m.getAttributeValue("state")));
            menu.add(item);
        } else if ("menu".equals(tag)) {
            menu.add(this.menu(m));
        }
    }

    private void addButtonGroup(JMenu menu, Element m) {
        ButtonGroup group = new ButtonGroup();
        Iterator iter = m.getChildren("radio-button").iterator();
        while (iter.hasNext()) {
            this.addRadioButton(menu, group, (Element)iter.next());
        }
    }

    private void addRadioButton(JMenu menu, ButtonGroup group, Element m) {
        JRadioButtonMenuItem item = new JRadioButtonMenuItem(m.getAttributeValue("id"));
        this.setItemAttributes(item, m);
        item.setSelected("true".equals(m.getAttributeValue("selected")));
        group.add(item);
        menu.add(item);
    }

    private Dimension getDimension(Element e, Dimension def) {
        String w = e.getAttributeValue("width");
        String h = e.getAttributeValue("height");
        return new Dimension(w != null ? Integer.parseInt(w) : def.width, h != null ? Integer.parseInt(h) : def.height);
    }

    private void setItemAttributes(AbstractButton b, Element e) {
        String icon;
        String s = e.getAttributeValue("accesskey");
        if (s != null && s.length() == 1) {
            b.setMnemonic(s.charAt(0));
        }
        if ((icon = e.getAttributeValue("icon")) != null) {
            try {
                b.setIcon(new ImageIcon(new URL(icon)));
            }
            catch (MalformedURLException ex) {
                ex.printStackTrace();
            }
        }
        b.setActionCommand(e.getAttributeValue("command"));
        String actionId = e.getAttributeValue("action");
        if (actionId != null) {
            b.addActionListener((ActionListener)this.get(actionId));
        }
    }

    protected void setLookAndFeel(Element ui) {
        String laf = ui.getAttributeValue("look-and-feel");
        if (laf != null) {
            try {
                UIManager.setLookAndFeel(laf);
            }
            catch (Exception e) {
                this.warn(e);
            }
        }
    }

    private JComponent createComponent(Element e) {
        JComponent component;
        if (e == null) {
            return new JPanel();
        }
        UIFactory factory = null;
        String clazz = e.getAttributeValue("class");
        if (clazz == null) {
            clazz = (String)this.mapping.get(e.getName());
        }
        if (clazz == null) {
            try {
                clazz = classMapping.getString(e.getName());
            }
            catch (MissingResourceException ex) {
                // empty catch block
            }
        }
        try {
            factory = clazz == null ? this : (UIFactory)this.objFactory.newInstance(clazz.trim());
            component = factory.create(this, e);
            this.setSize(component, e);
            if (component instanceof AbstractButton) {
                AbstractButton b = (AbstractButton)component;
                b.setActionCommand(e.getAttributeValue("command"));
                String actionId = e.getAttributeValue("action");
                if (actionId != null) {
                    b.addActionListener((ActionListener)this.get(actionId));
                }
            }
            this.put(component, e);
            Element script = e.getChild("script");
            if (script != null) {
                component = this.doScript(component, script);
            }
            if ("true".equals(e.getAttributeValue("scrollable"))) {
                component = new JScrollPane(component);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.warn("Error instantiating class " + clazz);
            this.warn(ex);
            component = new JLabel("Error instantiating class " + clazz);
        }
        return component;
    }

    protected JComponent doScript(JComponent component, Element e) {
        return component;
    }

    private void setSize(JComponent c, Element e) {
        String w = e.getAttributeValue("width");
        String h = e.getAttributeValue("height");
        Dimension d = c.getPreferredSize();
        double dw = d.getWidth();
        double dh = d.getHeight();
        if (w != null) {
            dw = Double.parseDouble(w);
        }
        if (h != null) {
            dh = Double.parseDouble(h);
        }
        if (w != null || h != null) {
            d.setSize(dw, dh);
            c.setPreferredSize(d);
        }
    }

    public JComponent create(Element e) {
        JComponent component = null;
        Iterator iter = e.getChildren().iterator();
        int i = 0;
        while (iter.hasNext()) {
            JComponent c = this.createComponent((Element)iter.next());
            if (i == 0) {
                component = c;
            } else if (i == 1) {
                JPanel p = new JPanel();
                p.add(component);
                p.add(c);
                component = p;
                this.put(component, e);
            } else {
                component.add(c);
            }
            ++i;
        }
        return component;
    }

    public JFrame getMainFrame() {
        return this.mainFrame;
    }

    private void createObjects(Element e, String name) {
        Iterator iter = e.getChildren(name).iterator();
        while (iter.hasNext()) {
            try {
                Element ee = (Element)iter.next();
                String clazz = ee.getAttributeValue("class");
                Object obj = this.objFactory.newInstance(clazz.trim());
                if (obj instanceof UIAware) {
                    ((UIAware)obj).setUI(this, ee);
                }
                this.put(obj, ee);
            }
            catch (Exception ex) {
                this.warn(ex);
            }
        }
    }

    private void createMappings(Element e) {
        Iterator iter = e.getChildren("mapping").iterator();
        while (iter.hasNext()) {
            try {
                Element ee = (Element)iter.next();
                String name = ee.getAttributeValue("name");
                String clazz = ee.getAttributeValue("factory");
                this.mapping.put(name, clazz);
            }
            catch (Exception ex) {
                this.warn(ex);
            }
        }
    }

    protected void warn(Object obj) {
        if (this.log != null) {
            this.log.warn(obj);
        }
    }

    private void put(Object obj, Element e) {
        String id = e.getAttributeValue("id");
        if (id != null) {
            this.registrar.put(id, obj);
        }
    }
}

