/*
 * Decompiled with CFR 0.152.
 */
package org.jpos.transaction.participant;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jdom.Element;
import org.jpos.core.ConfigurationException;
import org.jpos.core.XmlConfigurable;
import org.jpos.transaction.AbortParticipant;
import org.jpos.transaction.TransactionConstants;
import org.jpos.transaction.TransactionManager;
import org.jpos.transaction.TransactionParticipant;

public class Join
implements TransactionConstants,
AbortParticipant,
XmlConfigurable {
    private TransactionManager mgr;
    private List participants = new ArrayList();

    @Override
    public int prepare(long id, Serializable o) {
        return this.mergeActions(this.joinRunners(this.prepare(this.createRunners(id, o))));
    }

    @Override
    public int prepareForAbort(long id, Serializable o) {
        return this.mergeActions(this.joinRunners(this.prepareForAbort(this.createRunners(id, o))));
    }

    @Override
    public void commit(long id, Serializable o) {
        this.joinRunners(this.commit(this.createRunners(id, o)));
    }

    @Override
    public void abort(long id, Serializable o) {
        this.joinRunners(this.abort(this.createRunners(id, o)));
    }

    @Override
    public void setConfiguration(Element e) throws ConfigurationException {
        Iterator iter = e.getChildren("participant").iterator();
        while (iter.hasNext()) {
            this.participants.add(this.mgr.createParticipant((Element)iter.next()));
        }
    }

    public void setTransactionManager(TransactionManager mgr) {
        this.mgr = mgr;
    }

    private Runner[] prepare(Runner[] runners) {
        for (Runner runner : runners) {
            runner.prepare();
        }
        return runners;
    }

    private Runner[] prepareForAbort(Runner[] runners) {
        for (Runner runner : runners) {
            runner.prepareForAbort();
        }
        return runners;
    }

    private Runner[] commit(Runner[] runners) {
        for (Runner runner : runners) {
            runner.commit();
        }
        return runners;
    }

    private Runner[] abort(Runner[] runners) {
        for (Runner runner : runners) {
            runner.abort();
        }
        return runners;
    }

    private Runner[] createRunners(long id, Serializable o) {
        Runner[] runners = new Runner[this.participants.size()];
        Iterator iter = this.participants.iterator();
        int i = 0;
        while (iter.hasNext()) {
            runners[i] = new Runner((TransactionParticipant)iter.next(), id, o);
            ++i;
        }
        return runners;
    }

    private Runner[] joinRunners(Runner[] runners) {
        for (Runner runner : runners) {
            runner.join();
        }
        return runners;
    }

    private int mergeActions(Runner[] runners) {
        boolean prepared = true;
        boolean readonly = true;
        boolean no_join = true;
        boolean retry = false;
        for (Runner runner : runners) {
            int action = runner.rc;
            boolean bl = retry = (action & 2) == 2;
            if (retry) {
                return 2;
            }
            if ((action & 1) == 0) {
                prepared = false;
            }
            if ((action & 0x80) != 128) {
                readonly = false;
            }
            if ((action & 0x40) == 64) continue;
            no_join = false;
        }
        return (prepared ? 1 : 0) | (no_join ? 64 : 0) | (readonly ? 128 : 0);
    }

    public static class Runner
    implements Runnable {
        TransactionParticipant p;
        public int rc;
        long id;
        int mode;
        Serializable ctx;
        Thread t;
        public static final int PREPARE = 0;
        public static final int PREPARE_FOR_ABORT = 1;
        public static final int COMMIT = 2;
        public static final int ABORT = 3;
        public static final String[] MODES = new String[]{"prepare", "prepareForAbort", "commit", "abort"};

        public Runner(TransactionParticipant p, long id, Serializable ctx) {
            this.p = p;
            this.id = id;
            this.ctx = ctx;
        }

        public void prepare() {
            this.createThread(0);
        }

        public void prepareForAbort() {
            this.createThread(1);
        }

        public void commit() {
            this.createThread(2);
        }

        public void abort() {
            this.createThread(3);
        }

        @Override
        public void run() {
            switch (this.mode) {
                case 0: {
                    this.rc = this.p.prepare(this.id, this.ctx);
                    break;
                }
                case 1: {
                    if (!(this.p instanceof AbortParticipant)) break;
                    this.rc = ((AbortParticipant)this.p).prepareForAbort(this.id, this.ctx);
                    break;
                }
                case 2: {
                    if ((this.rc & 0x40) != 0) break;
                    this.p.commit(this.id, this.ctx);
                    break;
                }
                case 3: {
                    if ((this.rc & 0x40) != 0) break;
                    this.p.abort(this.id, this.ctx);
                }
            }
        }

        public void join() {
            try {
                this.t.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        private void createThread(int m) {
            this.t = new Thread(this);
            this.t.setName(MODES[m] + this.getClass().getName() + ":" + this.p.getClass().getName());
            this.mode = m;
            this.t.start();
        }
    }
}

