/*
 * Decompiled with CFR 0.152.
 */
package org.jpos.transaction.participant;

import java.io.Serializable;
import java.util.Random;
import org.jpos.core.Configurable;
import org.jpos.core.Configuration;
import org.jpos.core.ConfigurationException;
import org.jpos.transaction.TransactionParticipant;

public class Delay
implements TransactionParticipant,
Configurable {
    long prepareDelay = 0L;
    long commitDelay = 0L;
    long abortDelay = 0L;
    Random random;

    @Override
    public int prepare(long id, Serializable context) {
        this.sleep(this.prepareDelay);
        return 1;
    }

    @Override
    public void commit(long id, Serializable context) {
        this.sleep(this.commitDelay);
    }

    @Override
    public void abort(long id, Serializable context) {
        this.sleep(this.abortDelay);
    }

    @Override
    public void setConfiguration(Configuration cfg) throws ConfigurationException {
        this.prepareDelay = cfg.getLong("prepare-delay");
        this.commitDelay = cfg.getLong("commit-delay");
        this.abortDelay = cfg.getLong("abort-delay");
        this.random = cfg.getBoolean("random") ? new Random() : null;
    }

    void sleep(long delay) {
        if (delay > 0L) {
            try {
                Thread.sleep(this.random != null ? (long)this.random.nextDouble() * delay : delay);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

