/*
 * Decompiled with CFR 0.152.
 */
package org.jpos.transaction.participant;

import bsh.EvalError;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import org.jdom.Element;
import org.jpos.core.ConfigurationException;
import org.jpos.core.XmlConfigurable;
import org.jpos.transaction.AbortParticipant;
import org.jpos.transaction.TransactionParticipant;
import org.jpos.transaction.participant.BSHMethod;
import org.jpos.util.LogEvent;
import org.jpos.util.Logger;
import org.jpos.util.SimpleLogSource;

public class BSHTransactionParticipant
extends SimpleLogSource
implements TransactionParticipant,
AbortParticipant,
XmlConfigurable {
    protected BSHMethod prepareMethod;
    protected BSHMethod prepareForAbortMethod;
    protected BSHMethod commitMethod;
    protected BSHMethod abortMethod;
    boolean trace;

    @Override
    public void abort(long id, Serializable context) {
        LogEvent ev = new LogEvent(this, "abort");
        if (this.abortMethod != null) {
            try {
                this.executeMethod(this.abortMethod, id, context, ev, "");
            }
            catch (Exception ex) {
                ev.addMessage(ex);
            }
        } else {
            this.defaultAbort(id, context, ev);
        }
        if (this.trace) {
            Logger.log(ev);
        }
    }

    protected void defaultAbort(long id, Serializable context, LogEvent ev) {
    }

    @Override
    public void commit(long id, Serializable context) {
        LogEvent ev = new LogEvent(this, "commit");
        if (this.commitMethod != null) {
            try {
                this.executeMethod(this.commitMethod, id, context, ev, "");
            }
            catch (Exception ex) {
                ev.addMessage(ex);
            }
        } else {
            this.defaultCommit(id, context, ev);
        }
        if (this.trace) {
            Logger.log(ev);
        }
    }

    protected void defaultCommit(long id, Serializable context, LogEvent ev) {
    }

    @Override
    public int prepare(long id, Serializable context) {
        LogEvent ev = new LogEvent(this, "prepare");
        int result = 128;
        if (this.prepareMethod != null) {
            try {
                result = (Integer)this.executeMethod(this.prepareMethod, id, context, ev, "result");
            }
            catch (Exception ex) {
                ev.addMessage(ex);
            }
        } else {
            result = this.defaultPrepare(id, context, ev);
        }
        ev.addMessage("result", Integer.toBinaryString(result));
        if (this.trace) {
            Logger.log(ev);
        }
        return result;
    }

    @Override
    public int prepareForAbort(long id, Serializable context) {
        LogEvent ev = new LogEvent(this, "prepare-for-abort");
        int result = 128;
        if (this.prepareForAbortMethod != null) {
            try {
                result = (Integer)this.executeMethod(this.prepareForAbortMethod, id, context, ev, "result");
            }
            catch (Exception ex) {
                ev.addMessage(ex);
            }
        }
        ev.addMessage("result", Integer.toBinaryString(result));
        if (this.trace) {
            Logger.log(ev);
        }
        return result;
    }

    protected int defaultPrepare(long id, Serializable context, LogEvent ev) {
        return 129;
    }

    @Override
    public void setConfiguration(Element e) throws ConfigurationException {
        try {
            this.prepareMethod = BSHMethod.createBshMethod(e.getChild("prepare"));
            this.prepareForAbortMethod = BSHMethod.createBshMethod(e.getChild("prepare-for-abort"));
            this.commitMethod = BSHMethod.createBshMethod(e.getChild("commit"));
            this.abortMethod = BSHMethod.createBshMethod(e.getChild("abort"));
            this.trace = "yes".equals(e.getAttributeValue("trace"));
        }
        catch (Exception ex) {
            throw new ConfigurationException(ex.getMessage(), ex);
        }
    }

    protected Object executeMethod(BSHMethod m, long id, Serializable context, LogEvent evt, String resultName) throws EvalError, FileNotFoundException, IOException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("context", context);
        params.put("id", id);
        params.put("evt", evt);
        params.put("self", this);
        return m.execute(params, resultName);
    }
}

