/*
 * Decompiled with CFR 0.152.
 */
package org.jpos.transaction.participant;

import bsh.EvalError;
import bsh.Interpreter;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.jdom.Element;

public class BSHMethod {
    private String bshData;
    private boolean source;

    public static BSHMethod createBshMethod(Element e) throws FileNotFoundException, IOException {
        if (e == null) {
            return null;
        }
        String file = e.getAttributeValue("file");
        if (file != null) {
            int c;
            boolean cache = false;
            String cacheAtt = e.getAttributeValue("cache");
            if (cacheAtt != null) {
                cache = cacheAtt.equalsIgnoreCase("true");
            }
            if (!cache) {
                return new BSHMethod(file, true);
            }
            String bsh = "";
            FileReader f = new FileReader(file);
            while ((c = f.read()) != -1) {
                bsh = bsh + (char)c;
            }
            f.close();
            return new BSHMethod(bsh, false);
        }
        String bsh = e.getTextTrim();
        if (bsh == null || bsh.equals("")) {
            return null;
        }
        return new BSHMethod(bsh, false);
    }

    public BSHMethod(String bshData, boolean source) {
        this.bshData = bshData;
        this.source = source;
    }

    public Object execute(Map arguments, String resultName) throws EvalError, FileNotFoundException, IOException {
        Interpreter i = this.initInterpreter(arguments);
        return i.get(resultName);
    }

    public Map execute(Map arguments, Collection returnNames) throws EvalError, FileNotFoundException, IOException {
        Interpreter i = this.initInterpreter(arguments);
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (Object returnName : returnNames) {
            String rName = (String)returnName;
            result.put(rName, i.get(rName));
        }
        return result;
    }

    protected Interpreter initInterpreter(Map arguments) throws EvalError, FileNotFoundException, IOException {
        Interpreter i = new Interpreter();
        Iterator i$ = arguments.entrySet().iterator();
        while (i$.hasNext()) {
            Map.Entry o;
            Map.Entry entry = o = i$.next();
            i.set((String)entry.getKey(), entry.getValue());
        }
        if (this.source) {
            i.source(this.bshData);
        } else {
            i.eval(this.bshData);
        }
        return i;
    }

    public String toString() {
        return this.bshData;
    }
}

