/*
 * Decompiled with CFR 0.152.
 */
package org.jpos.transaction.participant;

import java.io.Serializable;
import org.jdom.Element;
import org.jpos.core.ConfigurationException;
import org.jpos.transaction.GroupSelector;
import org.jpos.transaction.participant.BSHMethod;
import org.jpos.transaction.participant.BSHTransactionParticipant;
import org.jpos.util.LogEvent;
import org.jpos.util.Logger;

public class BSHGroupSelector
extends BSHTransactionParticipant
implements GroupSelector {
    protected BSHMethod selectMethod;

    @Override
    public void setConfiguration(Element e) throws ConfigurationException {
        super.setConfiguration(e);
        try {
            this.selectMethod = BSHMethod.createBshMethod(e.getChild("select"));
        }
        catch (Exception ex) {
            throw new ConfigurationException(ex.getMessage(), ex);
        }
    }

    @Override
    public String select(long id, Serializable context) {
        LogEvent ev = new LogEvent(this, "select");
        String result = null;
        if (this.selectMethod != null) {
            try {
                result = (String)this.executeMethod(this.selectMethod, id, context, ev, "result");
            }
            catch (Exception ex) {
                ev.addMessage(ex);
            }
        }
        if (result == null) {
            result = this.defaultSelect(id, context);
        }
        ev.addMessage("result", result);
        Logger.log(ev);
        return result;
    }

    public String defaultSelect(long id, Serializable context) {
        return "";
    }
}

