/*
 * Decompiled with CFR 0.152.
 */
package org.jpos.transaction.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingConstants;
import javax.swing.Timer;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.jpos.transaction.TransactionManager;
import org.jpos.transaction.TransactionStatusEvent;
import org.jpos.transaction.TransactionStatusListener;
import org.jpos.ui.UI;
import org.jpos.util.TPS;

public class TMMonitor
extends JPanel
implements TransactionStatusListener,
SwingConstants,
ActionListener,
AncestorListener {
    UI ui;
    TransactionManager txnmgr;
    JTable table;
    AbstractTableModel model;
    TransactionStatusEvent[] events;
    JLabel tps = new JLabel("0");
    JLabel tpsAvg = new JLabel("0.00");
    JLabel tpsPeak = new JLabel("0");
    JLabel inTransit = new JLabel("0");
    JLabel outstanding = new JLabel("0");
    Timer timer;
    static final Font SMALL = Font.decode("terminal-plain-8");
    static final Font LARGE = Font.decode("terminal-plain-18");
    Color[] color = new Color[]{Color.white, new Color(179, 179, 255), new Color(255, 163, 163), new Color(209, 255, 209), new Color(255, 163, 163), Color.white, new Color(255, 127, 80)};

    public TMMonitor(UI ui, TransactionManager tmmgr) {
        this.ui = ui;
        this.txnmgr = tmmgr;
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createRaisedBevelBorder());
        this.model = this.createModel();
        this.table = this.createTable(this.model);
        JScrollPane scrollPane = new JScrollPane(this.table);
        this.add((Component)this.createTPSPanel(), "East");
        this.add((Component)scrollPane, "Center");
        tmmgr.addListener(this);
        this.addAncestorListener(this);
    }

    @Override
    public void update(TransactionStatusEvent e) {
        if (this.ui.isDestroyed()) {
            return;
        }
        int row = e.getSession();
        this.events[row] = e;
        this.model.fireTableRowsUpdated(row, row);
        this.setBackgroundColor(row, this.color[e.getState().intValue()]);
        this.inTransit.setText(Long.toString(this.txnmgr.getInTransit()));
        this.outstanding.setText(Long.toString(this.txnmgr.getOutstandingTransactions()));
    }

    private void setBackgroundColor(int row, Color color) {
        for (int i = 0; i < this.model.getColumnCount(); ++i) {
            ((DefaultTableCellRenderer)this.table.getCellRenderer(row, i)).setBackground(color);
        }
    }

    private JTable createTable(TableModel model) {
        JTable table = new JTable(model);
        table.setSurrendersFocusOnKeystroke(true);
        table.setFillsViewportHeight(true);
        table.setShowVerticalLines(true);
        table.setCellSelectionEnabled(false);
        table.setDoubleBuffered(true);
        TableColumnModel tcm = table.getColumnModel();
        tcm.getColumn(0).setPreferredWidth(10);
        tcm.getColumn(1).setPreferredWidth(25);
        tcm.getColumn(2).setPreferredWidth(100);
        tcm.getColumn(3).setPreferredWidth(600);
        return table;
    }

    private JComponent createTPSPanel() {
        JPanel outer = new JPanel(new BorderLayout());
        JPanel p = new JPanel(new GridLayout(5, 2));
        this.add(p, this.tps, "TPS");
        this.add(p, this.tpsPeak, "Peak TPS");
        this.add(p, this.tpsAvg, "Avg TPS");
        this.add(p, this.inTransit, "InTransit");
        this.add(p, this.outstanding, "Queue");
        JPanel blackFiller = new JPanel();
        outer.add((Component)p, "North");
        blackFiller.setBackground(Color.black);
        outer.add((Component)blackFiller, "Center");
        outer.setPreferredSize(new Dimension(170, 0));
        return outer;
    }

    private void add(JPanel p, JLabel l, String description) {
        this.setLabelStyle(l, LARGE, 4);
        p.add(l);
        p.add(this.setLabelStyle(new JLabel(description), SMALL, 2));
    }

    private JLabel setLabelStyle(JLabel l, Font f, int alignment) {
        l.setBorder(BorderFactory.createLoweredBevelBorder());
        l.setFont(f);
        l.setOpaque(true);
        l.setForeground(Color.green);
        l.setBackground(Color.black);
        l.setHorizontalAlignment(alignment);
        l.setVerticalAlignment(3);
        return l;
    }

    private AbstractTableModel createModel() {
        this.events = new TransactionStatusEvent[this.txnmgr.getActiveSessions()];
        return new AbstractTableModel(){
            String[] columnName = new String[]{"#", "id", "State", "Info"};
            Class[] columnClass = new Class[]{Integer.class, Long.class, String.class, String.class};

            @Override
            public int getColumnCount() {
                return 4;
            }

            @Override
            public int getRowCount() {
                return TMMonitor.this.txnmgr.getActiveSessions();
            }

            @Override
            public String getColumnName(int columnIndex) {
                return this.columnName[columnIndex];
            }

            public Class getColumnClass(int columnIndex) {
                return this.columnClass[columnIndex];
            }

            @Override
            public Object getValueAt(int row, int col) {
                if (TMMonitor.this.events[row] != null) {
                    switch (col) {
                        case 0: {
                            return row;
                        }
                        case 1: {
                            return TMMonitor.this.events[row].getId();
                        }
                        case 2: {
                            return TMMonitor.this.events[row].getStateAsString();
                        }
                        case 3: {
                            return TMMonitor.this.events[row].getInfo();
                        }
                    }
                }
                return "";
            }
        };
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        TPS t = this.txnmgr.getTPS();
        this.tps.setText(Integer.toString(t.intValue()));
        this.tpsAvg.setText(String.format("%.2f", Float.valueOf(t.getAvg())));
        this.tpsPeak.setText(Integer.toString(t.getPeak()));
    }

    @Override
    public void ancestorAdded(AncestorEvent event) {
        if (this.timer == null) {
            this.timer = new Timer(1000, this);
            this.timer.start();
        }
    }

    @Override
    public void ancestorRemoved(AncestorEvent event) {
        if (this.timer != null) {
            this.timer.stop();
            this.timer = null;
        }
    }

    @Override
    public void ancestorMoved(AncestorEvent event) {
    }
}

