/*
 * Decompiled with CFR 0.152.
 */
package org.jpos.transaction;

import java.io.Serializable;

public class TransactionStatusEvent {
    int session;
    long id;
    long timestamp;
    String info;
    State state;
    Serializable context;

    public TransactionStatusEvent(int session, State state, long id, String info, Serializable context) {
        this.session = session;
        this.state = state;
        this.id = id;
        this.info = info;
        this.context = context;
        this.timestamp = System.nanoTime();
    }

    public String toString() {
        return String.format("%02d %08d %s %s", this.session, this.id, this.state.toString(), this.info);
    }

    public int getSession() {
        return this.session;
    }

    public long getId() {
        return this.id;
    }

    public String getInfo() {
        return this.info;
    }

    public State getState() {
        return this.state;
    }

    public String getStateAsString() {
        return this.state.toString();
    }

    public Serializable getContext() {
        return this.context;
    }

    public static enum State {
        READY(0),
        PREPARING(1),
        PREPARING_FOR_ABORT(2),
        COMMITING(3),
        ABORTING(4),
        DONE(5),
        PAUSED(6);

        int state;
        String[] stateAsString = new String[]{"Ready", "Preparing", "Preparing for abort", "Commiting", "Aborting", "Done", "Paused"};

        private State(int state) {
            this.state = state;
        }

        public String toString() {
            return this.stateAsString[this.state];
        }

        public int intValue() {
            return this.state;
        }
    }
}

