/*
 * Decompiled with CFR 0.152.
 */
package org.jpos.transaction;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TimerTask;
import org.jdom.Element;
import org.jpos.core.Configuration;
import org.jpos.core.ConfigurationException;
import org.jpos.q2.QBeanSupport;
import org.jpos.q2.QFactory;
import org.jpos.space.JDBMSpace;
import org.jpos.space.LocalSpace;
import org.jpos.space.Space;
import org.jpos.space.SpaceFactory;
import org.jpos.space.SpaceUtil;
import org.jpos.transaction.AbortParticipant;
import org.jpos.transaction.ContextRecovery;
import org.jpos.transaction.GroupSelector;
import org.jpos.transaction.Pausable;
import org.jpos.transaction.PausedTransaction;
import org.jpos.transaction.TransactionConstants;
import org.jpos.transaction.TransactionManagerMBean;
import org.jpos.transaction.TransactionParticipant;
import org.jpos.transaction.TransactionStatusEvent;
import org.jpos.transaction.TransactionStatusListener;
import org.jpos.util.DefaultTimer;
import org.jpos.util.LogEvent;
import org.jpos.util.Logger;
import org.jpos.util.NameRegistrar;
import org.jpos.util.Profiler;
import org.jpos.util.TPS;

public class TransactionManager
extends QBeanSupport
implements Runnable,
TransactionConstants,
TransactionManagerMBean {
    public static final String HEAD = "$HEAD";
    public static final String TAIL = "$TAIL";
    public static final String CONTEXT = "$CONTEXT.";
    public static final String STATE = "$STATE.";
    public static final String GROUPS = "$GROUPS.";
    public static final String TAILLOCK = "$TAILLOCK";
    public static final String RETRY_QUEUE = "$RETRY_QUEUE";
    public static final Integer PREPARING = 0;
    public static final Integer COMMITTING = 1;
    public static final Integer DONE = 2;
    public static final String DEFAULT_GROUP = "";
    public static final long MAX_PARTICIPANTS = 1000L;
    public static final long MAX_WAIT = 15000L;
    protected Map groups;
    Space sp;
    Space psp;
    Space isp;
    String queue;
    String tailLock;
    Thread[] threads;
    final List<TransactionStatusListener> statusListeners = new ArrayList<TransactionStatusListener>();
    boolean hasStatusListeners;
    boolean debug;
    boolean profiler;
    boolean doRecover;
    boolean callSelectorOnAbort;
    int sessions;
    int maxSessions;
    int threshold;
    int maxActiveSessions;
    int activeSessions;
    long head;
    long tail;
    long retryInterval = 5000L;
    long retryTimeout = 60000L;
    long pauseTimeout = 0L;
    RetryTask retryTask = null;
    TPS tps;

    @Override
    public void initService() throws ConfigurationException {
        this.queue = this.cfg.get("queue", null);
        if (this.queue == null) {
            throw new ConfigurationException("queue property not specified");
        }
        this.sp = SpaceFactory.getSpace(this.cfg.get("space"));
        this.isp = SpaceFactory.getSpace(this.cfg.get("input-space", this.cfg.get("space")));
        this.psp = SpaceFactory.getSpace(this.cfg.get("persistent-space", this.toString()));
        this.tail = this.initCounter(TAIL, this.cfg.getLong("initial-tail", 1L));
        this.head = Math.max(this.initCounter(HEAD, this.tail), this.tail);
        this.initTailLock();
        this.groups = new HashMap();
        this.initParticipants(this.getPersist());
        this.initStatusListeners(this.getPersist());
    }

    @Override
    public void startService() throws Exception {
        NameRegistrar.register(this.getName(), this);
        this.recover();
        this.threads = new Thread[this.maxSessions];
        if (this.tps != null) {
            this.tps.stop();
        }
        this.tps = new TPS(this.cfg.getBoolean("auto-update-tps", true));
        for (int i = 0; i < this.sessions; ++i) {
            new Thread(this).start();
        }
        if (this.psp.rdp(RETRY_QUEUE) != null) {
            this.checkRetryTask();
        }
    }

    @Override
    public void stopService() throws Exception {
        NameRegistrar.unregister(this.getName());
        for (Thread thread1 : this.threads) {
            if (thread1 == null) continue;
            this.isp.out(this.queue, Boolean.FALSE, 60000L);
        }
        for (int i = 0; i < this.threads.length; ++i) {
            Thread thread = this.threads[i];
            try {
                if (thread != null) {
                    thread.join(60000L);
                }
                this.threads[i] = null;
                continue;
            }
            catch (InterruptedException e) {
                this.getLog().warn("Session " + thread.getName() + " does not respond - attempting to interrupt");
                thread.interrupt();
            }
        }
        this.tps.stop();
    }

    public void queue(Serializable context) {
        this.isp.out(this.queue, context);
    }

    public void push(Serializable context) {
        this.isp.push(this.queue, context);
    }

    public String getQueueName() {
        return this.queue;
    }

    public Space getSpace() {
        return this.sp;
    }

    public Space getInputSpace() {
        return this.isp;
    }

    public Space getPersistentSpace() {
        return this.psp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void run() {
        id = 0L;
        session = 0;
        members = null;
        iter = null;
        abort = false;
        evt = null;
        prof = null;
        startTime = 0L;
        thread = Thread.currentThread();
        assigned = false;
        var15_11 = this.threads;
        synchronized (this.threads) {
            for (i = 0; i < this.threads.length; ++i) {
                if (this.threads[i] != null) continue;
                this.threads[i] = thread;
                session = i;
                assigned = true;
                break;
            }
            if (assigned) {
                ++this.activeSessions;
            }
            // ** MonitorExit[var15_11] (shouldn't be in output)
            if (!assigned) {
                this.getLog().warn("Max sessions reached, new session not created");
                return;
            }
            this.getLog().info("start " + thread);
            while (this.running()) {
                block56: {
                    block55: {
                        block53: {
                            block54: {
                                block52: {
                                    context = null;
                                    paused = false;
                                    thread.setName(this.getName() + "-" + session + ":idle");
                                    if (this.hasStatusListeners) {
                                        this.notifyStatusListeners(session, TransactionStatusEvent.State.READY, id, "", null);
                                    }
                                    if ((obj = this.isp.in(this.queue, 15000L)) != Boolean.FALSE) break block52;
                                    if (this.hasStatusListeners) {
                                        this.notifyStatusListeners(session, paused != false ? TransactionStatusEvent.State.PAUSED : TransactionStatusEvent.State.DONE, id, "", context);
                                    }
                                    if (evt == null) continue;
                                    evt.addMessage(String.format("head=%d, tail=%d, outstanding=%d, active-sessions=%d/%d, %s, elapsed=%dms", new Object[]{this.head, this.tail, this.getOutstandingTransactions(), this.getActiveSessions(), this.maxSessions, this.tps.toString(), System.currentTimeMillis() - startTime}));
                                    if (prof != null) {
                                        evt.addMessage(prof);
                                    }
                                    Logger.log(evt);
                                    evt = null;
                                    continue;
                                }
                                if (obj != null) break block53;
                                if (session <= this.sessions || this.getActiveSessions() <= this.sessions) break block54;
                                if (this.hasStatusListeners) {
                                    this.notifyStatusListeners(session, paused != false ? TransactionStatusEvent.State.PAUSED : TransactionStatusEvent.State.DONE, id, "", context);
                                }
                                if (evt == null) break;
                                evt.addMessage(String.format("head=%d, tail=%d, outstanding=%d, active-sessions=%d/%d, %s, elapsed=%dms", new Object[]{this.head, this.tail, this.getOutstandingTransactions(), this.getActiveSessions(), this.maxSessions, this.tps.toString(), System.currentTimeMillis() - startTime}));
                                if (prof != null) {
                                    evt.addMessage(prof);
                                }
                                Logger.log(evt);
                                evt = null;
                                break;
                            }
                            if (this.hasStatusListeners) {
                                this.notifyStatusListeners(session, paused != false ? TransactionStatusEvent.State.PAUSED : TransactionStatusEvent.State.DONE, id, "", context);
                            }
                            if (evt == null) continue;
                            evt.addMessage(String.format("head=%d, tail=%d, outstanding=%d, active-sessions=%d/%d, %s, elapsed=%dms", new Object[]{this.head, this.tail, this.getOutstandingTransactions(), this.getActiveSessions(), this.maxSessions, this.tps.toString(), System.currentTimeMillis() - startTime}));
                            if (prof != null) {
                                evt.addMessage(prof);
                            }
                            Logger.log(evt);
                            evt = null;
                            continue;
                        }
                        if (session < this.sessions && this.maxSessions > this.sessions && this.getActiveSessions() < this.maxSessions && id % (long)this.sessions == 0L && this.getOutstandingTransactions() > this.threshold) {
                            new Thread(this).start();
                        }
                        if (obj instanceof Serializable) break block55;
                        this.getLog().error("non serializable '" + obj.getClass().getName() + "' on queue '" + this.queue + "'");
                        if (this.hasStatusListeners) {
                            this.notifyStatusListeners(session, paused != false ? TransactionStatusEvent.State.PAUSED : TransactionStatusEvent.State.DONE, id, "", context);
                        }
                        if (evt == null) continue;
                        evt.addMessage(String.format("head=%d, tail=%d, outstanding=%d, active-sessions=%d/%d, %s, elapsed=%dms", new Object[]{this.head, this.tail, this.getOutstandingTransactions(), this.getActiveSessions(), this.maxSessions, this.tps.toString(), System.currentTimeMillis() - startTime}));
                        if (prof != null) {
                            evt.addMessage(prof);
                        }
                        Logger.log(evt);
                        evt = null;
                        continue;
                    }
                    context = (Serializable)obj;
                    if (obj instanceof Pausable) {
                        pausable = (Pausable)obj;
                        pt = pausable.getPausedTransaction();
                        if (pt != null) {
                            pt.cancelExpirationMonitor();
                            id = pt.id();
                            members = pt.members();
                            iter = pt.iterator();
                            abort = pt.isAborting();
                        }
                    } else {
                        pt = null;
                    }
                    if (pt != null) ** GOTO lbl122
                    running = this.getRunningSessions();
                    if (this.maxActiveSessions <= 0 || running < this.maxActiveSessions) break block56;
                    evt = this.getLog().createLogEvent("warn", Thread.currentThread().getName() + ": emergency retry, running-sessions=" + running + ", max-active-sessions=" + this.maxActiveSessions);
                    evt.addMessage(obj);
                    this.psp.out("$RETRY_QUEUE", obj, this.retryTimeout);
                    this.checkRetryTask();
                    if (this.hasStatusListeners) {
                        this.notifyStatusListeners(session, paused != false ? TransactionStatusEvent.State.PAUSED : TransactionStatusEvent.State.DONE, id, "", context);
                    }
                    if (evt == null) continue;
                    evt.addMessage(String.format("head=%d, tail=%d, outstanding=%d, active-sessions=%d/%d, %s, elapsed=%dms", new Object[]{this.head, this.tail, this.getOutstandingTransactions(), this.getActiveSessions(), this.maxSessions, this.tps.toString(), System.currentTimeMillis() - startTime}));
                    if (prof != null) {
                        evt.addMessage(prof);
                    }
                    Logger.log(evt);
                    evt = null;
                    continue;
                }
                try {
                    abort = false;
                    id = this.nextId();
                    members = new ArrayList<E>();
                    iter = this.getParticipants("").iterator();
lbl122:
                    // 2 sources

                    if (this.debug) {
                        evt = this.getLog().createLogEvent("debug", Thread.currentThread().getName() + ":" + Long.toString(id) + (pt != null ? " [resuming]" : ""));
                        prof = new Profiler();
                        startTime = System.currentTimeMillis();
                    }
                    this.snapshot(id, context, TransactionManager.PREPARING);
                    action = this.prepare(session, id, context, members, iter, abort, evt, prof);
                    switch (action) {
                        case 4: {
                            paused = true;
                            break;
                        }
                        case 1: {
                            this.setState(id, TransactionManager.COMMITTING);
                            this.commit(session, id, context, members, false, evt, prof);
                            break;
                        }
                        case 0: {
                            this.abort(session, id, context, members, false, evt, prof);
                            break;
                        }
                        case 2: {
                            this.psp.out("$RETRY_QUEUE", context);
                            this.checkRetryTask();
                            break;
                        }
                    }
                    if ((action & 4) == 0) {
                        this.snapshot(id, null, TransactionManager.DONE);
                        if (id == this.tail) {
                            this.checkTail();
                        }
                        this.tps.tick();
                    }
                    if (this.hasStatusListeners) {
                        this.notifyStatusListeners(session, paused != false ? TransactionStatusEvent.State.PAUSED : TransactionStatusEvent.State.DONE, id, "", context);
                    }
                    if (evt == null) continue;
                }
                catch (Throwable t) {
                    try {
                        if (evt == null) {
                            this.getLog().fatal(t);
                        } else {
                            evt.addMessage(t);
                        }
                        if (this.hasStatusListeners) {
                            this.notifyStatusListeners(session, paused != false ? TransactionStatusEvent.State.PAUSED : TransactionStatusEvent.State.DONE, id, "", context);
                        }
                        if (evt == null) continue;
                    }
                    catch (Throwable var18_20) {
                        if (this.hasStatusListeners) {
                            this.notifyStatusListeners(session, paused != false ? TransactionStatusEvent.State.PAUSED : TransactionStatusEvent.State.DONE, id, "", context);
                        }
                        if (evt != null) {
                            evt.addMessage(String.format("head=%d, tail=%d, outstanding=%d, active-sessions=%d/%d, %s, elapsed=%dms", new Object[]{this.head, this.tail, this.getOutstandingTransactions(), this.getActiveSessions(), this.maxSessions, this.tps.toString(), System.currentTimeMillis() - startTime}));
                            if (prof != null) {
                                evt.addMessage(prof);
                            }
                            Logger.log(evt);
                            evt = null;
                        }
                        throw var18_20;
                    }
                    evt.addMessage(String.format("head=%d, tail=%d, outstanding=%d, active-sessions=%d/%d, %s, elapsed=%dms", new Object[]{this.head, this.tail, this.getOutstandingTransactions(), this.getActiveSessions(), this.maxSessions, this.tps.toString(), System.currentTimeMillis() - startTime}));
                    if (prof != null) {
                        evt.addMessage(prof);
                    }
                    Logger.log(evt);
                    evt = null;
                    continue;
                }
                evt.addMessage(String.format("head=%d, tail=%d, outstanding=%d, active-sessions=%d/%d, %s, elapsed=%dms", new Object[]{this.head, this.tail, this.getOutstandingTransactions(), this.getActiveSessions(), this.maxSessions, this.tps.toString(), System.currentTimeMillis() - startTime}));
                if (prof != null) {
                    evt.addMessage(prof);
                }
                Logger.log(evt);
                evt = null;
            }
            var15_11 = this.threads;
            synchronized (this.threads) {
                for (i = 0; i < this.threads.length; ++i) {
                    if (this.threads[i] != thread) continue;
                    this.threads[i] = null;
                    break;
                }
                --this.activeSessions;
                this.getLog().info("stop " + Thread.currentThread() + ", active sessions=" + this.activeSessions);
                // ** MonitorExit[var15_11] (shouldn't be in output)
                return;
            }
        }
    }

    @Override
    public long getTail() {
        return this.tail;
    }

    @Override
    public long getHead() {
        return this.head;
    }

    public long getInTransit() {
        return this.head - this.tail;
    }

    @Override
    public void setConfiguration(Configuration cfg) throws ConfigurationException {
        super.setConfiguration(cfg);
        this.debug = cfg.getBoolean("debug");
        this.profiler = cfg.getBoolean("profiler", this.debug);
        if (this.profiler) {
            this.debug = true;
        }
        this.doRecover = cfg.getBoolean("recover", true);
        this.retryInterval = cfg.getLong("retry-interval", this.retryInterval);
        this.retryTimeout = cfg.getLong("retry-timeout", this.retryTimeout);
        this.pauseTimeout = cfg.getLong("pause-timeout", this.pauseTimeout);
        this.maxActiveSessions = cfg.getInt("max-active-sessions", 0);
        this.sessions = cfg.getInt("sessions", 1);
        this.threshold = cfg.getInt("threshold", this.sessions / 2);
        this.maxSessions = cfg.getInt("max-sessions", this.sessions);
        if (this.maxSessions < this.sessions) {
            throw new ConfigurationException("max-sessions < sessions");
        }
        if (this.maxActiveSessions > 0) {
            if (this.maxActiveSessions < this.sessions) {
                throw new ConfigurationException("max-active-sessions < sessions");
            }
            if (this.maxActiveSessions < this.maxSessions) {
                throw new ConfigurationException("max-active-sessions < max-sessions");
            }
        }
        this.callSelectorOnAbort = cfg.getBoolean("call-selector-on-abort", true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(TransactionStatusListener l) {
        List<TransactionStatusListener> list = this.statusListeners;
        synchronized (list) {
            this.statusListeners.add(l);
            this.hasStatusListeners = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(TransactionStatusListener l) {
        List<TransactionStatusListener> list = this.statusListeners;
        synchronized (list) {
            this.statusListeners.remove(l);
            this.hasStatusListeners = this.statusListeners.size() > 0;
        }
    }

    public TPS getTPS() {
        return this.tps;
    }

    @Override
    public String getTPSAsString() {
        return this.tps.toString();
    }

    @Override
    public float getTPSAvg() {
        return this.tps.getAvg();
    }

    @Override
    public int getTPSPeak() {
        return this.tps.getPeak();
    }

    @Override
    public Date getTPSPeakWhen() {
        return new Date(this.tps.getPeakWhen());
    }

    @Override
    public long getTPSElapsed() {
        return this.tps.getElapsed();
    }

    @Override
    public void resetTPS() {
        this.tps.reset();
    }

    protected void commit(int session, long id, Serializable context, List members, boolean recover, LogEvent evt, Profiler prof) {
        for (TransactionParticipant p : members) {
            if (recover && p instanceof ContextRecovery) {
                context = ((ContextRecovery)((Object)p)).recover(id, context, true);
                if (evt != null) {
                    evt.addMessage(" commit-recover: " + p.getClass().getName());
                }
            }
            if (this.hasStatusListeners) {
                this.notifyStatusListeners(session, TransactionStatusEvent.State.COMMITING, id, p.getClass().getName(), context);
            }
            this.commit(p, id, context);
            if (evt == null) continue;
            evt.addMessage("         commit: " + p.getClass().getName());
            if (prof == null) continue;
            prof.checkPoint(" commit: " + p.getClass().getName());
        }
    }

    protected void abort(int session, long id, Serializable context, List members, boolean recover, LogEvent evt, Profiler prof) {
        for (TransactionParticipant p : members) {
            if (recover && p instanceof ContextRecovery) {
                context = ((ContextRecovery)((Object)p)).recover(id, context, false);
                if (evt != null) {
                    evt.addMessage("  abort-recover: " + p.getClass().getName());
                }
            }
            if (this.hasStatusListeners) {
                this.notifyStatusListeners(session, TransactionStatusEvent.State.ABORTING, id, p.getClass().getName(), context);
            }
            this.abort(p, id, context);
            if (evt == null) continue;
            evt.addMessage("          abort: " + p.getClass().getName());
            if (prof == null) continue;
            prof.checkPoint("  abort: " + p.getClass().getName());
        }
    }

    protected int prepareForAbort(TransactionParticipant p, long id, Serializable context) {
        try {
            if (p instanceof AbortParticipant) {
                this.setThreadName(id, "prepareForAbort", p);
                return ((AbortParticipant)p).prepareForAbort(id, context);
            }
        }
        catch (Throwable t) {
            this.getLog().warn("PREPARE-FOR-ABORT: " + Long.toString(id), t);
        }
        return 64;
    }

    protected int prepare(TransactionParticipant p, long id, Serializable context) {
        try {
            this.setThreadName(id, "prepare", p);
            return p.prepare(id, context);
        }
        catch (Throwable t) {
            this.getLog().warn("PREPARE: " + Long.toString(id), t);
            return 0;
        }
    }

    protected void commit(TransactionParticipant p, long id, Serializable context) {
        try {
            this.setThreadName(id, "commit", p);
            p.commit(id, context);
        }
        catch (Throwable t) {
            this.getLog().warn("COMMIT: " + Long.toString(id), t);
        }
    }

    protected void abort(TransactionParticipant p, long id, Serializable context) {
        try {
            this.setThreadName(id, "abort", p);
            p.abort(id, context);
        }
        catch (Throwable t) {
            this.getLog().warn("ABORT: " + Long.toString(id), t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    protected int prepare(int session, long id, Serializable context, List members, Iterator iter, boolean abort, LogEvent evt, Profiler prof) {
        retry = false;
        pause = false;
        i = 0;
        while (iter.hasNext()) {
            if ((long)i > 1000L) {
                this.getLog().warn("loop detected - transaction " + id + " aborted.");
                return 0;
            }
            p = (TransactionParticipant)iter.next();
            if (abort) {
                if (this.hasStatusListeners) {
                    this.notifyStatusListeners(session, TransactionStatusEvent.State.PREPARING_FOR_ABORT, id, p.getClass().getName(), context);
                }
                action = this.prepareForAbort(p, id, context);
                if (evt != null && p instanceof AbortParticipant) {
                    evt.addMessage("prepareForAbort: " + p.getClass().getName());
                }
            } else {
                if (this.hasStatusListeners) {
                    this.notifyStatusListeners(session, TransactionStatusEvent.State.PREPARING, id, p.getClass().getName(), context);
                }
                abort = ((action = this.prepare(p, id, context)) & 1) == 0;
                retry = (action & 2) == 2;
                v0 = pause = (action & 4) == 4;
                if (evt != null) {
                    evt.addMessage("        prepare: " + p.getClass().getName() + (abort != false ? " ABORTED" : "") + (retry != false ? " RETRY" : "") + (pause != false ? " PAUSE" : "") + ((action & 128) == 128 ? " READONLY" : "") + ((action & 64) == 64 ? " NO_JOIN" : ""));
                    if (prof != null) {
                        prof.checkPoint("prepare: " + p.getClass().getName());
                    }
                }
            }
            if ((action & 128) == 0) {
                this.snapshot(id, context);
            }
            if ((action & 64) == 0) {
                members.add(p);
            }
            if (!(p instanceof GroupSelector) || (action & 1) != 1 && !this.callSelectorOnAbort) ** GOTO lbl-1000
            groupName = null;
            try {
                groupName = ((GroupSelector)p).select(id, context);
            }
            catch (Exception e) {
                if (evt != null) {
                    evt.addMessage("       selector: " + p.getClass().getName() + " " + e.getMessage());
                }
                this.getLog().error("       selector: " + p.getClass().getName() + " " + e.getMessage());
            }
            if (evt != null) {
                evt.addMessage("       selector: " + groupName);
            }
            if (groupName != null) {
                st = new StringTokenizer(groupName, " ,");
                participants = new ArrayList<E>();
                while (st.hasMoreTokens()) {
                    grp = st.nextToken();
                    this.addGroup(id, grp);
                    participants.addAll(this.getParticipants(grp));
                }
                while (iter.hasNext()) {
                    participants.add(iter.next());
                }
                iter = participants.iterator();
            } else if (pause) {
                if (context instanceof Pausable) {
                    pausable = (Pausable)context;
                    t = pausable.getTimeout();
                    if (t == 0L) {
                        t = this.pauseTimeout;
                    }
                    expirationMonitor = null;
                    if (t > 0L) {
                        expirationMonitor = new PausedMonitor(pausable);
                    }
                    pt = new PausedTransaction(this, id, members, iter, abort, expirationMonitor);
                    pausable.setPausedTransaction(pt);
                    if (expirationMonitor != null) {
                        var20_21 = context;
                        synchronized (var20_21) {
                            if (!pt.isResumed()) {
                                DefaultTimer.getTimer().schedule((TimerTask)expirationMonitor, t);
                            }
                        }
                    }
                } else {
                    throw new RuntimeException("Unable to PAUSE transaction - Context is not Pausable");
                }
                return 4;
            }
            ++i;
        }
        return members.isEmpty() ? 64 : (abort ? (retry ? 2 : 0) : 1);
    }

    protected List getParticipants(String groupName) {
        ArrayList participants = (ArrayList)this.groups.get(groupName);
        if (participants == null) {
            participants = new ArrayList();
        }
        return participants;
    }

    protected List getParticipants(long id) {
        String grp;
        ArrayList participantsChain = new ArrayList();
        List participants = this.getParticipants(DEFAULT_GROUP);
        participantsChain.addAll(participants);
        String key = this.getKey(GROUPS, id);
        while ((grp = (String)this.psp.inp(key)) != null) {
            participantsChain.addAll(this.getParticipants(grp));
        }
        return participantsChain;
    }

    protected void initStatusListeners(Element config) throws ConfigurationException {
        for (Element e : config.getChildren("status-listener")) {
            QFactory factory = this.getFactory();
            TransactionStatusListener listener = (TransactionStatusListener)factory.newInstance(e.getAttributeValue("class"));
            factory.setConfiguration(listener, config);
            this.addListener(listener);
        }
    }

    protected void initParticipants(Element config) throws ConfigurationException {
        this.groups.put(DEFAULT_GROUP, this.initGroup(config));
        for (Element e : config.getChildren("group")) {
            String name = e.getAttributeValue("name");
            if (name == null) {
                throw new ConfigurationException("missing group name");
            }
            if (this.groups.get(name) != null) {
                throw new ConfigurationException("Group '" + name + "' already defined");
            }
            this.groups.put(name, this.initGroup(e));
        }
    }

    protected ArrayList initGroup(Element e) throws ConfigurationException {
        ArrayList<TransactionParticipant> group = new ArrayList<TransactionParticipant>();
        Iterator iter = e.getChildren("participant").iterator();
        while (iter.hasNext()) {
            group.add(this.createParticipant((Element)iter.next()));
        }
        return group;
    }

    public TransactionParticipant createParticipant(Element e) throws ConfigurationException {
        QFactory factory = this.getFactory();
        TransactionParticipant participant = (TransactionParticipant)factory.newInstance(e.getAttributeValue("class"));
        factory.setLogger(participant, e);
        QFactory.invoke(participant, "setTransactionManager", this, TransactionManager.class);
        factory.setConfiguration(participant, e);
        return participant;
    }

    @Override
    public int getOutstandingTransactions() {
        if (this.isp instanceof LocalSpace) {
            return ((LocalSpace)this.sp).size(this.queue);
        }
        return -1;
    }

    protected String getKey(String prefix, long id) {
        StringBuilder sb = new StringBuilder(this.getName());
        sb.append('.');
        sb.append(prefix);
        sb.append(Long.toString(id));
        return sb.toString();
    }

    protected long initCounter(String name, long defValue) {
        Long L = (Long)this.psp.rdp(name);
        if (L == null) {
            L = defValue;
            this.psp.out(name, L);
        }
        return L;
    }

    protected void commitOff(Space sp) {
        if (sp instanceof JDBMSpace) {
            ((JDBMSpace)sp).setAutoCommit(false);
        }
    }

    protected void commitOn(Space sp) {
        if (sp instanceof JDBMSpace) {
            JDBMSpace jsp = (JDBMSpace)sp;
            jsp.commit();
            jsp.setAutoCommit(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void syncTail() {
        Space space = this.psp;
        synchronized (space) {
            this.commitOff(this.psp);
            this.psp.inp(TAIL);
            this.psp.out(TAIL, this.tail);
            this.commitOn(this.psp);
        }
    }

    protected void initTailLock() {
        this.tailLock = "$TAILLOCK." + Integer.toString(this.hashCode());
        SpaceUtil.wipe(this.sp, this.tailLock);
        this.sp.out(this.tailLock, TAILLOCK);
    }

    protected void checkTail() {
        Object lock = this.sp.in(this.tailLock);
        while (this.tailDone()) {
            ++this.tail;
        }
        this.syncTail();
        this.sp.out(this.tailLock, lock);
    }

    protected boolean tailDone() {
        String stateKey = this.getKey(STATE, this.tail);
        if (DONE.equals(this.psp.rdp(stateKey))) {
            this.purge(this.tail);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long nextId() {
        long h;
        Space space = this.psp;
        synchronized (space) {
            this.commitOff(this.psp);
            this.psp.in(HEAD);
            h = this.head++;
            this.psp.out(HEAD, this.head);
            this.commitOn(this.psp);
        }
        return h;
    }

    protected void snapshot(long id, Serializable context) {
        this.snapshot(id, context, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void snapshot(long id, Serializable context, Integer status) {
        String contextKey = this.getKey(CONTEXT, id);
        Space space = this.psp;
        synchronized (space) {
            this.commitOff(this.psp);
            while (this.psp.inp(contextKey) != null) {
            }
            if (context != null) {
                this.psp.out(contextKey, context);
            }
            if (status != null) {
                String stateKey = this.getKey(STATE, id);
                while (this.psp.inp(stateKey) != null) {
                }
                this.psp.out(stateKey, status);
            }
            this.commitOn(this.psp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setState(long id, Integer state) {
        String stateKey = this.getKey(STATE, id);
        Space space = this.psp;
        synchronized (space) {
            this.commitOff(this.psp);
            while (this.psp.inp(stateKey) != null) {
            }
            if (state != null) {
                this.psp.out(stateKey, state);
            }
            this.commitOn(this.psp);
        }
    }

    protected void addGroup(long id, String groupName) {
        if (groupName != null) {
            this.psp.out(this.getKey(GROUPS, id), groupName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void purge(long id) {
        String stateKey = this.getKey(STATE, id);
        String contextKey = this.getKey(CONTEXT, id);
        String groupsKey = this.getKey(GROUPS, id);
        Space space = this.psp;
        synchronized (space) {
            this.commitOff(this.psp);
            while (this.psp.inp(stateKey) != null) {
            }
            while (this.psp.inp(contextKey) != null) {
            }
            while (this.psp.inp(groupsKey) != null) {
            }
            this.commitOn(this.psp);
        }
    }

    protected void recover() {
        if (this.doRecover) {
            if (this.tail < this.head) {
                this.getLog().info("recover - tail=" + this.tail + ", head=" + this.head);
            }
            while (this.tail < this.head) {
                this.recover(0, this.tail++);
            }
        } else {
            this.tail = this.head;
        }
        this.syncTail();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void recover(int session, long id) {
        LogEvent evt = this.getLog().createLogEvent("recover");
        Profiler prof = new Profiler();
        evt.addMessage("<id>" + id + "</id>");
        try {
            String stateKey = this.getKey(STATE, id);
            String contextKey = this.getKey(CONTEXT, id);
            Integer state = (Integer)this.psp.rdp(stateKey);
            if (state == null) {
                evt.addMessage("unknown stateKey " + stateKey);
                SpaceUtil.wipe(this.psp, contextKey);
                return;
            }
            Serializable context = (Serializable)this.psp.rdp(contextKey);
            if (context != null) {
                evt.addMessage(context);
            }
            if (DONE.equals(state)) {
                evt.addMessage("<done/>");
            } else if (COMMITTING.equals(state)) {
                this.commit(session, id, context, this.getParticipants(id), true, evt, prof);
            } else if (PREPARING.equals(state)) {
                this.abort(session, id, context, this.getParticipants(id), true, evt, prof);
            }
            this.purge(id);
        }
        finally {
            evt.addMessage(prof);
            Logger.log(evt);
        }
    }

    protected synchronized void checkRetryTask() {
        if (this.retryTask == null) {
            this.retryTask = new RetryTask();
            new Thread(this.retryTask).start();
        }
    }

    @Override
    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    @Override
    public boolean getDebug() {
        return this.debug;
    }

    @Override
    public int getActiveSessions() {
        return this.activeSessions;
    }

    public int getRunningSessions() {
        return (int)(this.head - this.tail);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyStatusListeners(int session, TransactionStatusEvent.State state, long id, String info, Serializable context) {
        TransactionStatusEvent e = new TransactionStatusEvent(session, state, id, info, context);
        List<TransactionStatusListener> list = this.statusListeners;
        synchronized (list) {
            for (TransactionStatusListener l : this.statusListeners) {
                l.update(e);
            }
        }
    }

    private void setThreadName(long id, String method, TransactionParticipant p) {
        Thread.currentThread().setName(String.format("%s:%d %s %s", this.getName(), id, method, p.getClass().getName()));
    }

    public class RetryTask
    implements Runnable {
        @Override
        public void run() {
            Thread.currentThread().setName(TransactionManager.this.getName() + "-retry-task");
            while (TransactionManager.this.running()) {
                Object context;
                while ((context = TransactionManager.this.psp.rdp(TransactionManager.RETRY_QUEUE)) != null) {
                    TransactionManager.this.isp.out(TransactionManager.this.queue, context, TransactionManager.this.retryTimeout);
                    TransactionManager.this.psp.inp(TransactionManager.RETRY_QUEUE);
                }
                try {
                    Thread.sleep(TransactionManager.this.retryInterval);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    public static class PausedMonitor
    extends TimerTask {
        Pausable context;

        public PausedMonitor(Pausable context) {
            this.context = context;
        }

        @Override
        public void run() {
            this.cancel();
            this.context.getPausedTransaction().forceAbort();
            this.context.resume();
        }
    }
}

