/*
 * Decompiled with CFR 0.152.
 */
package org.jpos.transaction;

import java.io.PrintStream;
import java.util.Iterator;
import java.util.List;
import java.util.TimerTask;
import org.jpos.transaction.TransactionManager;
import org.jpos.util.Loggeable;

public class PausedTransaction
implements Loggeable {
    private long id;
    private List members;
    private Iterator iter;
    private boolean aborting;
    private TransactionManager txnmgr;
    private boolean resumed;
    private TimerTask expirationMonitor;

    public PausedTransaction(TransactionManager txnmgr, long id, List members, Iterator iter, boolean aborting, TimerTask expirationMonitor) {
        this.txnmgr = txnmgr;
        this.id = id;
        this.members = members;
        this.iter = iter;
        this.aborting = aborting;
        this.expirationMonitor = expirationMonitor;
    }

    public long id() {
        return this.id;
    }

    public List members() {
        return this.members;
    }

    public Iterator iterator() {
        return this.iter;
    }

    @Override
    public void dump(PrintStream p, String indent) {
        p.println(indent + "id: " + this.id + (this.isAborting() ? " (aborting)" : ""));
    }

    public boolean isAborting() {
        return this.aborting;
    }

    public void forceAbort() {
        this.aborting = true;
    }

    public TransactionManager getTransactionManager() {
        return this.txnmgr;
    }

    public void setResumed(boolean resumed) {
        this.resumed = resumed;
    }

    public boolean isResumed() {
        return this.resumed;
    }

    public synchronized void cancelExpirationMonitor() {
        if (this.expirationMonitor != null) {
            this.expirationMonitor.cancel();
        }
    }
}

