/*
 * Decompiled with CFR 0.152.
 */
package org.jpos.transaction;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.jdom.Element;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.jpos.iso.ISOUtil;
import org.jpos.transaction.Pausable;
import org.jpos.transaction.PausedTransaction;
import org.jpos.util.LogEvent;
import org.jpos.util.Loggeable;
import org.jpos.util.Profiler;

public class Context
implements Externalizable,
Loggeable,
Pausable {
    private transient Map map;
    private Map pmap;
    private long timeout;
    private boolean resumeOnPause = false;
    public static String LOGEVT = "LOGEVT";
    public static String PROFILER = "PROFILER";
    public static String PAUSED_TRANSACTION = ":paused_transaction";
    static final long serialVersionUID = 6056487212221438338L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(Object key, Object value) {
        this.getMap().put(key, value);
        Context context = this;
        synchronized (context) {
            this.notifyAll();
        }
    }

    public void put(Object key, Object value, boolean persist) {
        this.getMap().put(key, value);
        if (persist && value instanceof Serializable) {
            this.getPMap().put(key, value);
        }
    }

    public Object get(Object key) {
        return this.getMap().get(key);
    }

    public Object get(Object key, Object defValue) {
        Object obj = this.getMap().get(key);
        return obj != null ? obj : defValue;
    }

    public synchronized Object remove(Object key) {
        this.getPMap().remove(key);
        return this.getMap().remove(key);
    }

    public String getString(Object key) {
        return (String)this.getMap().get(key);
    }

    public String getString(Object key, Object defValue) {
        return (String)this.get(key, defValue);
    }

    @Override
    public void dump(PrintStream p, String indent) {
        String inner = indent + "  ";
        p.println(indent + "<context>");
        this.dumpMap(p, inner);
        p.println(indent + "</context>");
    }

    public synchronized Object get(Object key, long timeout) {
        Object obj;
        long now = System.currentTimeMillis();
        long end = now + timeout;
        while ((obj = this.map.get(key)) == null && (now = System.currentTimeMillis()) < end) {
            try {
                this.wait(end - now);
            }
            catch (InterruptedException e) {}
        }
        return obj;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeByte(0);
        Set s = this.getPMap().entrySet();
        out.writeInt(s.size());
        for (Map.Entry entry : s) {
            out.writeObject(entry.getKey());
            out.writeObject(entry.getValue());
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        in.readByte();
        this.getMap();
        this.getPMap();
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            Object k = in.readObject();
            Object v = in.readObject();
            this.map.put(k, v);
            this.pmap.put(k, v);
        }
    }

    private synchronized Map getPMap() {
        if (this.pmap == null) {
            this.pmap = Collections.synchronizedMap(new LinkedHashMap());
        }
        return this.pmap;
    }

    public synchronized Map getMap() {
        if (this.map == null) {
            this.map = Collections.synchronizedMap(new HashMap());
        }
        return this.map;
    }

    protected void dumpMap(PrintStream p, String indent) {
        if (this.map == null) {
            return;
        }
        for (Map.Entry entry : this.map.entrySet()) {
            String key = entry.getKey().toString();
            if (key.startsWith("*")) continue;
            if (this.pmap != null && this.pmap.containsKey(entry.getKey())) {
                p.print(indent + "<entry key='" + key + "' p='true'>");
            } else {
                p.print(indent + "<entry key='" + key + "'>");
            }
            Object value = entry.getValue();
            if (value instanceof Loggeable) {
                p.println("");
                ((Loggeable)value).dump(p, indent + " ");
                p.print(indent);
            } else if (value instanceof Element) {
                p.println("");
                p.println(indent + "<![CDATA[");
                XMLOutputter out = new XMLOutputter(Format.getPrettyFormat());
                out.getFormat().setLineSeparator("\n");
                try {
                    out.output((Element)value, (OutputStream)p);
                }
                catch (IOException ex) {
                    ex.printStackTrace(p);
                }
                p.println("");
                p.println(indent + "]]>");
            } else if (value instanceof byte[]) {
                byte[] b = (byte[])value;
                p.println("");
                p.println(ISOUtil.hexdump(b));
            } else if (value != null) {
                try {
                    p.print(value.toString());
                }
                catch (Exception e) {
                    p.println(e.getMessage());
                }
            } else {
                p.print("nil");
            }
            p.println("</entry>");
        }
    }

    public synchronized LogEvent getLogEvent() {
        LogEvent evt = (LogEvent)this.get(LOGEVT);
        if (evt == null) {
            evt = new LogEvent("log");
            this.put(LOGEVT, evt);
        }
        return evt;
    }

    public synchronized Profiler getProfiler() {
        Profiler prof = (Profiler)this.get(PROFILER);
        if (prof == null) {
            prof = new Profiler();
            this.put(PROFILER, prof);
        }
        return prof;
    }

    public void log(Object msg) {
        this.getLogEvent().addMessage(msg);
    }

    public void checkPoint(String detail) {
        this.getProfiler().checkPoint(detail);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPausedTransaction(PausedTransaction p) {
        this.put(PAUSED_TRANSACTION, p);
        Context context = this;
        synchronized (context) {
            if (this.resumeOnPause) {
                this.resume();
            }
        }
    }

    @Override
    public PausedTransaction getPausedTransaction() {
        return (PausedTransaction)this.get(PAUSED_TRANSACTION);
    }

    @Override
    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    @Override
    public long getTimeout() {
        return this.timeout;
    }

    @Override
    public synchronized void resume() {
        PausedTransaction pt = this.getPausedTransaction();
        if (pt != null && !pt.isResumed()) {
            pt.setResumed(true);
            pt.getTransactionManager().push(this);
        } else {
            this.resumeOnPause = true;
        }
    }
}

