/*
 * Decompiled with CFR 0.152.
 */
package org.jpos.tlv;

import org.jpos.iso.ISOUtil;

public class TLVMsg {
    private int tag;
    protected byte[] value;

    public TLVMsg() {
    }

    public TLVMsg(int tag, byte[] value) {
        this.tag = tag;
        this.value = value;
    }

    public int getTag() {
        return this.tag;
    }

    public byte[] getValue() {
        return this.value;
    }

    public void setTag(int tag) {
        this.tag = tag;
    }

    public void setValue(byte[] newValue) {
        this.value = newValue;
    }

    public byte[] getTLV() {
        String hexVal = Integer.toHexString(this.tag);
        byte[] bTag = ISOUtil.hex2byte(hexVal);
        byte[] bLen = this.getL();
        if (this.value != null) {
            int tLength = bTag.length + bLen.length + this.value.length;
            byte[] out = new byte[tLength];
            System.arraycopy(bTag, 0, out, 0, bTag.length);
            System.arraycopy(bLen, 0, out, bTag.length, bLen.length);
            System.arraycopy(this.value, 0, out, bTag.length + bLen.length, this.value.length);
            return out;
        }
        int tLength = bTag.length + bLen.length;
        byte[] out = new byte[tLength];
        System.arraycopy(bTag, 0, out, 0, bTag.length);
        System.arraycopy(bLen, 0, out, bTag.length, bLen.length);
        return out;
    }

    public byte[] getL() {
        if (this.value == null) {
            return new byte[1];
        }
        int ix = 0;
        int tmp = this.value.length;
        int bytes = 0;
        while (tmp != 0) {
            tmp >>= 8;
            ++bytes;
        }
        if (bytes <= 1 && this.value.length <= 127) {
            byte[] rBytes = new byte[bytes];
            rBytes[0] = (byte)this.value.length;
            return rBytes;
        }
        byte[] rBytes = new byte[1 + bytes];
        rBytes[0] = (byte)(0x80 | bytes);
        int mask = 255;
        tmp = this.value.length;
        while (ix < bytes) {
            rBytes[bytes - ix] = (byte)(tmp & mask);
            --bytes;
            tmp >>= 8;
        }
        return rBytes;
    }

    public String getStringValue() {
        return ISOUtil.hexString(this.value);
    }
}

