/*
 * Decompiled with CFR 0.152.
 */
package org.jpos.tlv;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Enumeration;
import java.util.Vector;
import org.jpos.iso.ISOException;
import org.jpos.iso.ISOUtil;
import org.jpos.tlv.TLVMsg;

public class TLVList
implements Serializable {
    private Vector tags = new Vector();
    private int tagToFind = 0;
    private int indexLastOccurrence = -1;

    public void unpack(byte[] buf) throws ISOException {
        ByteBuffer buffer = ByteBuffer.wrap(buf);
        while (this.hasNext(buffer)) {
            TLVMsg currentNode = this.getTLVMsg(buffer);
            if (currentNode == null) continue;
            this.append(currentNode);
        }
    }

    public Enumeration elements() {
        return this.tags.elements();
    }

    public void unpack(byte[] buf, int offset) throws ISOException {
        ByteBuffer buffer = ByteBuffer.wrap(buf, offset, buf.length - offset);
        while (this.hasNext(buffer)) {
            TLVMsg currentNode = this.getTLVMsg(buffer);
            this.append(currentNode);
        }
    }

    public void append(TLVMsg tlvToAppend) {
        this.tags.add(tlvToAppend);
    }

    public void append(int tag, byte[] value) {
        this.append(new TLVMsg(tag, value));
    }

    public void append(int tag, String value) {
        this.append(new TLVMsg(tag, ISOUtil.hex2byte(value)));
    }

    public void deleteByIndex(int index) {
        this.tags.remove(index);
    }

    public void deleteByTag(int tag) {
        int i = 0;
        while (i < this.tags.size()) {
            TLVMsg tlv2 = (TLVMsg)this.tags.elementAt(i);
            if (tlv2.getTag() == tag) {
                this.tags.removeElement(tlv2);
                continue;
            }
            ++i;
        }
    }

    public TLVMsg find(int tag) {
        this.tagToFind = tag;
        for (int i = 0; i < this.tags.size(); ++i) {
            TLVMsg tlv = (TLVMsg)this.tags.elementAt(i);
            if (tlv.getTag() != tag) continue;
            this.indexLastOccurrence = i;
            return tlv;
        }
        this.indexLastOccurrence = -1;
        return null;
    }

    public int findIndex(int tag) {
        this.tagToFind = tag;
        for (int i = 0; i < this.tags.size(); ++i) {
            TLVMsg tlv = (TLVMsg)this.tags.elementAt(i);
            if (tlv.getTag() != tag) continue;
            this.indexLastOccurrence = i;
            return i;
        }
        this.indexLastOccurrence = -1;
        return -1;
    }

    public TLVMsg findNextTLV() {
        for (int i = this.indexLastOccurrence + 1; i < this.tags.size(); ++i) {
            TLVMsg tlv = (TLVMsg)this.tags.elementAt(i);
            if (tlv.getTag() != this.tagToFind) continue;
            this.indexLastOccurrence = i;
            return tlv;
        }
        return null;
    }

    public TLVMsg index(int index) {
        return (TLVMsg)this.tags.get(index);
    }

    public byte[] pack() {
        ByteBuffer buffer = ByteBuffer.allocate(400);
        for (int i = 0; i < this.tags.size(); ++i) {
            TLVMsg tlv = (TLVMsg)this.tags.elementAt(i);
            buffer.put(tlv.getTLV());
        }
        byte[] b = new byte[buffer.position()];
        buffer.flip();
        buffer.get(b);
        return b;
    }

    private TLVMsg getTLVMsg(ByteBuffer buffer) throws ISOException {
        int tag = this.getTAG(buffer);
        if (tag != 0) {
            byte[] arrValue = null;
            if (!buffer.hasRemaining()) {
                throw new ISOException("BAD TLV FORMAT - tag (" + Integer.toHexString(tag) + ") without length or value");
            }
            int length = this.getValueLength(buffer);
            if (length > buffer.remaining()) {
                throw new ISOException("BAD TLV FORMAT - tag (" + Integer.toHexString(tag) + ") length (" + length + ") exceeds available data.");
            }
            if (length > 0) {
                arrValue = new byte[length];
                buffer.get(arrValue);
            }
            TLVMsg tlv = this.getTLVMsg(tag, arrValue);
            return tlv;
        }
        return null;
    }

    protected TLVMsg getTLVMsg(int tag, byte[] arrValue) {
        return new TLVMsg(tag, arrValue);
    }

    private boolean hasNext(ByteBuffer buffer) {
        return buffer.hasRemaining();
    }

    private int getTAG(ByteBuffer buffer) {
        int tag = 0;
        int b = buffer.get() & 0xFF;
        if (b == 255 || b == 0) {
            while (((b = buffer.get() & 0xFF) == 255 || b == 0) && this.hasNext(buffer)) {
            }
        }
        tag = b;
        if ((b & 0x1F) == 31) {
            do {
                tag <<= 8;
                b = buffer.get();
                tag |= b & 0xFF;
            } while ((b & 0x80) == 128);
        }
        return tag;
    }

    protected int getValueLength(ByteBuffer buffer) {
        int length = 0;
        int count = 0;
        byte b = buffer.get();
        count = b & 0xFF;
        if ((count & 0x80) == 128) {
            count -= 128;
            length = 0;
            while (count > 0) {
                length <<= 8;
                b = buffer.get();
                length |= b & 0xFF;
                --count;
            }
        } else {
            length = count;
        }
        return length;
    }

    public String getString(int tag) {
        TLVMsg msg = this.find(tag);
        if (msg != null) {
            return msg.getStringValue();
        }
        return null;
    }

    public byte[] getValue(int tag) {
        TLVMsg msg = this.find(tag);
        if (msg != null) {
            return msg.getValue();
        }
        return null;
    }

    public boolean hasTag(int tag) {
        return this.findIndex(tag) > -1;
    }
}

