/*
 * Decompiled with CFR 0.152.
 */
package org.jpos.space;

import java.io.PrintStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.jpos.space.LocalSpace;
import org.jpos.space.ObjectTemplate;
import org.jpos.space.SpaceFactory;
import org.jpos.space.SpaceListener;
import org.jpos.space.Template;
import org.jpos.util.Loggeable;

public class TSpace<K, V>
implements LocalSpace<K, V>,
Loggeable,
Runnable {
    protected Map entries;
    protected TSpace sl;
    public static final long GCDELAY = 5000L;
    private static final long GCLONG = 60000L;
    private Set[] expirables;
    private long lastLongGC = System.currentTimeMillis();

    public TSpace() {
        this.entries = new HashMap();
        this.expirables = new Set[]{new HashSet(), new HashSet()};
        SpaceFactory.getGCExecutor().scheduleAtFixedRate(this, 5000L, 5000L, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void out(K key, V value) {
        if (key == null || value == null) {
            throw new NullPointerException("key=" + key + ", value=" + value);
        }
        TSpace tSpace = this;
        synchronized (tSpace) {
            this.getList(key).add(value);
            this.notifyAll();
        }
        if (this.sl != null) {
            this.notifyListeners(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void out(K key, V value, long timeout) {
        if (key == null || value == null) {
            throw new NullPointerException("key=" + key + ", value=" + value);
        }
        Object v = value;
        if (timeout > 0L) {
            v = new Expirable(value, System.currentTimeMillis() + timeout);
        }
        TSpace tSpace = this;
        synchronized (tSpace) {
            this.getList(key).add(v);
            this.notifyAll();
            if (timeout > 0L) {
                this.registerExpirable(key, timeout);
            }
        }
        if (this.sl != null) {
            this.notifyListeners(key, value);
        }
    }

    @Override
    public synchronized V rdp(Object key) {
        if (key instanceof Template) {
            return (V)this.getObject((Template)key, false);
        }
        return (V)this.getHead(key, false);
    }

    @Override
    public synchronized V inp(Object key) {
        if (key instanceof Template) {
            return (V)this.getObject((Template)key, true);
        }
        return (V)this.getHead(key, true);
    }

    @Override
    public synchronized V in(Object key) {
        V obj;
        while ((obj = this.inp(key)) == null) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        return obj;
    }

    @Override
    public synchronized V in(Object key, long timeout) {
        V obj;
        long now = System.currentTimeMillis();
        long end = now + timeout;
        while ((obj = this.inp(key)) == null && (now = System.currentTimeMillis()) < end) {
            try {
                this.wait(end - now);
            }
            catch (InterruptedException e) {}
        }
        return obj;
    }

    @Override
    public synchronized V rd(Object key) {
        V obj;
        while ((obj = this.rdp(key)) == null) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        return obj;
    }

    @Override
    public synchronized V rd(Object key, long timeout) {
        V obj;
        long now = System.currentTimeMillis();
        long end = now + timeout;
        while ((obj = this.rdp(key)) == null && (now = System.currentTimeMillis()) < end) {
            try {
                this.wait(end - now);
            }
            catch (InterruptedException e) {}
        }
        return obj;
    }

    @Override
    public void run() {
        try {
            this.gc();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void gc() {
        this.gc(0);
        if (System.currentTimeMillis() - this.lastLongGC > 60000L) {
            this.gc(1);
            this.lastLongGC = System.currentTimeMillis();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void gc(int generation) {
        Set exps = this.expirables[generation];
        TSpace tSpace = this;
        synchronized (tSpace) {
            this.expirables[generation] = new HashSet();
        }
        for (Object k : exps) {
            if (this.rdp(k) != null) {
                TSpace tSpace2 = this;
                synchronized (tSpace2) {
                    this.expirables[generation].add(k);
                }
            }
            Thread.yield();
        }
        if (this.sl != null) {
            tSpace = this;
            synchronized (tSpace) {
                if (this.sl != null && this.sl.isEmpty()) {
                    this.sl = null;
                }
            }
        }
    }

    @Override
    public synchronized int size(Object key) {
        int size = 0;
        List l = (List)this.entries.get(key);
        if (l != null) {
            size = l.size();
        }
        return size;
    }

    @Override
    public synchronized void addListener(Object key, SpaceListener listener) {
        this.getSL().out(key, listener);
    }

    @Override
    public synchronized void addListener(Object key, SpaceListener listener, long timeout) {
        this.getSL().out(key, listener, timeout);
    }

    @Override
    public synchronized void removeListener(Object key, SpaceListener listener) {
        if (this.sl != null) {
            this.sl.inp(new ObjectTemplate(key, listener));
        }
    }

    public boolean isEmpty() {
        return this.entries.isEmpty();
    }

    @Override
    public Set getKeySet() {
        return this.entries.keySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getKeysAsString() {
        Object[] keys;
        StringBuilder sb = new StringBuilder();
        TSpace tSpace = this;
        synchronized (tSpace) {
            keys = this.entries.keySet().toArray();
        }
        for (int i = 0; i < keys.length; ++i) {
            if (i > 0) {
                sb.append(' ');
            }
            sb.append(keys[i]);
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dump(PrintStream p, String indent) {
        int exp1;
        int exp0;
        Object[] keys;
        TSpace tSpace = this;
        synchronized (tSpace) {
            keys = this.entries.keySet().toArray();
        }
        for (Object key : keys) {
            p.printf("%s<key count='%d'>%s</key>\n", indent, this.size(key), key);
        }
        p.println(indent + "<keycount>" + (keys.length - 1) + "</keycount>");
        TSpace tSpace2 = this;
        synchronized (tSpace2) {
            exp0 = this.expirables[0].size();
            exp1 = this.expirables[1].size();
        }
        p.println(String.format("%s<gcinfo>%d,%d</gcinfo>\n", indent, exp0, exp1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyListeners(Object key, Object value) {
        Object[] listeners = null;
        TSpace tSpace = this;
        synchronized (tSpace) {
            if (this.sl == null) {
                return;
            }
            List l = (List)this.sl.entries.get(key);
            if (l != null) {
                listeners = l.toArray();
            }
        }
        if (listeners != null) {
            for (Object listener : listeners) {
                Object o = listener;
                if (o instanceof Expirable) {
                    o = ((Expirable)o).getValue();
                }
                if (!(o instanceof SpaceListener)) continue;
                ((SpaceListener)o).notify(key, value);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void push(K key, V value) {
        if (key == null || value == null) {
            throw new NullPointerException("key=" + key + ", value=" + value);
        }
        TSpace tSpace = this;
        synchronized (tSpace) {
            this.getList(key).add(0, value);
            this.notifyAll();
        }
        if (this.sl != null) {
            this.notifyListeners(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void push(K key, V value, long timeout) {
        if (key == null || value == null) {
            throw new NullPointerException("key=" + key + ", value=" + value);
        }
        Object v = value;
        if (timeout > 0L) {
            v = new Expirable(value, System.currentTimeMillis() + timeout);
        }
        TSpace tSpace = this;
        synchronized (tSpace) {
            this.getList(key).add(0, v);
            this.notifyAll();
            if (timeout > 0L) {
                this.registerExpirable(key, timeout);
            }
        }
        if (this.sl != null) {
            this.notifyListeners(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(K key, V value) {
        if (key == null || value == null) {
            throw new NullPointerException("key=" + key + ", value=" + value);
        }
        TSpace tSpace = this;
        synchronized (tSpace) {
            LinkedList<V> l = new LinkedList<V>();
            l.add(value);
            this.entries.put(key, l);
            this.notifyAll();
        }
        if (this.sl != null) {
            this.notifyListeners(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(K key, V value, long timeout) {
        if (key == null || value == null) {
            throw new NullPointerException("key=" + key + ", value=" + value);
        }
        Object v = value;
        if (timeout > 0L) {
            v = new Expirable(value, System.currentTimeMillis() + timeout);
        }
        TSpace tSpace = this;
        synchronized (tSpace) {
            LinkedList<V> l = new LinkedList<V>();
            l.add(v);
            this.entries.put(key, l);
            this.notifyAll();
            if (timeout > 0L) {
                this.registerExpirable(key, timeout);
            }
        }
        if (this.sl != null) {
            this.notifyListeners(key, value);
        }
    }

    @Override
    public boolean existAny(K[] keys) {
        for (K key : keys) {
            if (this.rdp(key) == null) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean existAny(K[] keys, long timeout) {
        long now = System.currentTimeMillis();
        long end = now + timeout;
        while ((now = System.currentTimeMillis()) < end) {
            if (this.existAny(keys)) {
                return true;
            }
            TSpace tSpace = this;
            synchronized (tSpace) {
                try {
                    this.wait(end - now);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
        }
        return false;
    }

    public Map getEntries() {
        return this.entries;
    }

    public void setEntries(Map entries) {
        this.entries = entries;
    }

    private List getList(Object key) {
        LinkedList l = (LinkedList)this.entries.get(key);
        if (l == null) {
            l = new LinkedList();
            this.entries.put(key, l);
        }
        return l;
    }

    private Object getHead(Object key, boolean remove) {
        Object obj = null;
        List l = (List)this.entries.get(key);
        boolean wasExpirable = false;
        while (obj == null && l != null && l.size() > 0) {
            obj = l.get(0);
            if (obj instanceof Expirable) {
                obj = ((Expirable)obj).getValue();
                wasExpirable = true;
            }
            if (obj != null) continue;
            l.remove(0);
            if (!l.isEmpty()) continue;
            this.entries.remove(key);
        }
        if (obj != null && remove) {
            l.remove(0);
            if (l.isEmpty()) {
                this.entries.remove(key);
                if (wasExpirable) {
                    this.unregisterExpirable(key);
                }
            }
        }
        return obj;
    }

    private Object getObject(Template tmpl, boolean remove) {
        Object obj = null;
        List l = (List)this.entries.get(tmpl.getKey());
        if (l == null) {
            return obj;
        }
        Iterator iter = l.iterator();
        while (iter.hasNext()) {
            obj = iter.next();
            if (obj instanceof Expirable && (obj = ((Expirable)obj).getValue()) == null) {
                iter.remove();
                continue;
            }
            if (tmpl.equals(obj)) {
                if (!remove) break;
                iter.remove();
                break;
            }
            obj = null;
        }
        return obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TSpace getSL() {
        TSpace tSpace = this;
        synchronized (tSpace) {
            if (this.sl == null) {
                this.sl = new TSpace<K, V>();
            }
        }
        return this.sl;
    }

    private void registerExpirable(K k, long t) {
        this.expirables[t > 60000L ? 1 : 0].add(k);
    }

    private void unregisterExpirable(Object k) {
        for (Set s : this.expirables) {
            s.remove(k);
        }
    }

    static class Expirable
    implements Comparable {
        Object value;
        long expires;

        public Expirable(Object value, long expires) {
            this.value = value;
            this.expires = expires;
        }

        public boolean isExpired() {
            return this.expires < System.currentTimeMillis();
        }

        public String toString() {
            return this.getClass().getName() + "@" + Integer.toHexString(this.hashCode()) + ",value=" + this.value.toString() + ",expired=" + this.isExpired();
        }

        public Object getValue() {
            return this.isExpired() ? null : this.value;
        }

        public int compareTo(Object obj) {
            Expirable other = (Expirable)obj;
            long otherExpires = other.expires;
            if (otherExpires == this.expires) {
                return 0;
            }
            if (this.expires < otherExpires) {
                return -1;
            }
            return 1;
        }
    }
}

