/*
 * Decompiled with CFR 0.152.
 */
package org.jpos.space;

import org.jpos.space.LocalSpace;
import org.jpos.space.SpaceListener;

public class SpaceTap
implements SpaceListener {
    LocalSpace ssp;
    LocalSpace dsp;
    Object key;
    Object tapKey;
    long tapTimeout;

    public SpaceTap(LocalSpace sp, Object key, Object tapKey, long tapTimeout) {
        this(sp, sp, key, tapKey, tapTimeout);
    }

    public SpaceTap(LocalSpace ssp, LocalSpace dsp, Object key, Object tapKey, long tapTimeout) {
        this.ssp = ssp;
        this.dsp = dsp;
        this.key = key;
        this.tapKey = tapKey;
        this.tapTimeout = tapTimeout;
        if (key.equals(tapKey) && ssp == dsp) {
            throw new IllegalArgumentException("Possible deadlock - key equals tap-key within same space");
        }
        ssp.addListener(key, this);
    }

    @Override
    public void notify(Object key, Object value) {
        this.dsp.out(this.tapKey, value, this.tapTimeout);
    }

    public void close() {
        if (this.ssp != null) {
            this.ssp.removeListener(this.key, this);
            this.ssp = null;
        }
    }
}

