/*
 * Decompiled with CFR 0.152.
 */
package org.jpos.space;

import java.io.Serializable;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.server.ExportException;
import java.rmi.server.RemoteObject;
import java.rmi.server.RemoteRef;
import java.rmi.server.RemoteStub;
import java.rmi.server.UnicastRemoteObject;
import java.util.Set;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.jpos.core.Configurable;
import org.jpos.core.Configuration;
import org.jpos.core.ConfigurationException;
import org.jpos.space.LocalSpace;
import org.jpos.space.RemoteSpace;
import org.jpos.space.Space;
import org.jpos.space.SpaceFactory;

public class SpaceProxy
implements RemoteSpace,
Configurable {
    Space sp;
    Configuration cfg;
    private RemoteRef ref;
    private RemoteStub stub;

    public SpaceProxy() throws RemoteException {
        this.sp = SpaceFactory.getSpace();
        this.startService();
    }

    public SpaceProxy(String spaceUri) throws RemoteException {
        this.sp = SpaceFactory.getSpace(spaceUri);
        this.startService();
    }

    private void startService() throws RemoteException {
        try {
            LocateRegistry.createRegistry(1099);
        }
        catch (ExportException exportException) {
            // empty catch block
        }
        this.stub = UnicastRemoteObject.exportObject(this);
        this.ref = this.stub.getRef();
    }

    @Override
    public void out(Serializable key, Serializable value) throws RemoteException {
        this.sp.out(key, value);
    }

    @Override
    public void out(Serializable key, Serializable value, long timeout) throws RemoteException {
        this.sp.out(key, value, timeout);
    }

    @Override
    public Serializable in(Serializable key) throws RemoteException {
        return (Serializable)this.sp.in(key);
    }

    @Override
    public Serializable rd(Serializable key) throws RemoteException {
        return (Serializable)this.sp.rd(key);
    }

    @Override
    public Serializable in(Serializable key, long timeout) throws RemoteException {
        return (Serializable)this.sp.in(key, timeout);
    }

    @Override
    public Serializable rd(Serializable key, long timeout) throws RemoteException {
        return (Serializable)this.sp.rd(key, timeout);
    }

    @Override
    public Serializable inp(Serializable key) throws RemoteException {
        return (Serializable)this.sp.inp(key);
    }

    @Override
    public Serializable rdp(Serializable key) throws RemoteException {
        return (Serializable)this.sp.rdp(key);
    }

    public void shutdown() {
        try {
            if (UnicastRemoteObject.unexportObject(this, false)) {
                return;
            }
            Thread.sleep(5000L);
            UnicastRemoteObject.unexportObject(this, true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void setConfiguration(Configuration cfg) throws ConfigurationException {
        this.cfg = cfg;
        try {
            InitialContext ctx = new InitialContext();
            ctx.rebind(cfg.get("name"), (Object)this.stub);
        }
        catch (NamingException e) {
            throw new ConfigurationException(e);
        }
    }

    public Set getKeySet() {
        if (this.sp instanceof LocalSpace) {
            return ((LocalSpace)this.sp).getKeySet();
        }
        return null;
    }

    public String toString() {
        if (this.ref == null) {
            return this.getClass().getName() + "[<unexported>]";
        }
        return this.getClass().getName() + "[" + this.ref.remoteToString() + "]";
    }

    public int hashCode() {
        if (this.ref == null) {
            return super.hashCode();
        }
        return this.ref.remoteHashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof RemoteObject) {
            if (this.ref == null) {
                return obj == this;
            }
            RemoteRef otherRef = ((RemoteObject)obj).getRef();
            return this.ref.remoteEquals(otherRef);
        }
        if (obj != null) {
            return obj.equals(this);
        }
        return false;
    }
}

