/*
 * Decompiled with CFR 0.152.
 */
package org.jpos.space;

import java.util.StringTokenizer;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import org.jpos.space.JDBMSpace;
import org.jpos.space.JESpace;
import org.jpos.space.Space;
import org.jpos.space.SpaceError;
import org.jpos.space.TSpace;
import org.jpos.util.ConcurrentUtil;
import org.jpos.util.NameRegistrar;

public class SpaceFactory {
    public static final String TSPACE = "tspace";
    public static final String TRANSIENT = "transient";
    public static final String PERSISTENT = "persistent";
    public static final String SPACELET = "spacelet";
    public static final String JDBM = "jdbm";
    public static final String JE = "je";
    public static final String DEFAULT = "default";
    private static ScheduledThreadPoolExecutor gcExecutor = ConcurrentUtil.newScheduledThreadPoolExecutor();

    public static Space getSpace() {
        return SpaceFactory.getSpace(TSPACE, DEFAULT, null);
    }

    public static Space getSpace(String spaceUri) {
        if (spaceUri == null) {
            return SpaceFactory.getSpace();
        }
        String scheme = null;
        String name = null;
        String param = null;
        StringTokenizer st = new StringTokenizer(spaceUri, ":");
        int count = st.countTokens();
        if (count == 0) {
            scheme = TSPACE;
            name = DEFAULT;
        } else if (count == 1) {
            scheme = TSPACE;
            name = st.nextToken();
        } else {
            scheme = st.nextToken();
            name = st.nextToken();
        }
        if (st.hasMoreTokens()) {
            param = st.nextToken();
        }
        return SpaceFactory.getSpace(scheme, name, param);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Space getSpace(String scheme, String name, String param) {
        Space sp = null;
        String uri = SpaceFactory.normalize(scheme, name, param);
        Class<SpaceFactory> clazz = SpaceFactory.class;
        synchronized (SpaceFactory.class) {
            try {
                sp = (Space)NameRegistrar.get(uri);
            }
            catch (NameRegistrar.NotFoundException e) {
                if (SPACELET.equals(scheme)) {
                    throw new SpaceError(uri + " not found.");
                }
                sp = SpaceFactory.createSpace(scheme, name, param);
                NameRegistrar.register(uri, sp);
            }
            if (sp == null) {
                throw new SpaceError("Invalid space: " + uri);
            }
            return sp;
        }
    }

    public static ScheduledThreadPoolExecutor getGCExecutor() {
        return gcExecutor;
    }

    private static Space createSpace(String scheme, String name, String param) {
        Runnable sp = null;
        if (TSPACE.equals(scheme) || TRANSIENT.equals(scheme)) {
            sp = new TSpace();
        } else if (JDBM.equals(scheme) || PERSISTENT.equals(scheme)) {
            sp = param != null ? JDBMSpace.getSpace(name, param) : JDBMSpace.getSpace(name);
        } else if (JE.equals(scheme)) {
            sp = param != null ? JESpace.getSpace(name, param) : JESpace.getSpace(name);
        }
        return sp;
    }

    private static String normalize(String scheme, String name, String param) {
        StringBuilder sb = new StringBuilder(scheme);
        sb.append(':');
        sb.append(name);
        if (param != null) {
            sb.append(':');
            sb.append(param);
        }
        return sb.toString();
    }
}

