/*
 * Decompiled with CFR 0.152.
 */
package org.jpos.space;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.security.MessageDigest;
import java.util.Arrays;
import org.jpos.iso.ISOUtil;
import org.jpos.space.SpaceError;
import org.jpos.space.Template;

public class MD5Template
implements Template,
Serializable {
    private static final long serialVersionUID = -1204861759575740048L;
    byte[] digest;
    Object key;

    public MD5Template(Object key, Object value) {
        this.key = key;
        this.digest = this.digest(value);
    }

    public MD5Template(Object key, byte[] digest) {
        this.key = key;
        this.digest = digest;
    }

    public byte[] digest(Object obj) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            return md.digest(MD5Template.serialize(obj));
        }
        catch (Exception e) {
            throw new SpaceError(e);
        }
    }

    @Override
    public boolean equals(Object obj) {
        return Arrays.equals(this.digest(obj), this.digest);
    }

    public int hashCode() {
        assert (false) : "hashCode not designed";
        return 42;
    }

    @Override
    public Object getKey() {
        return this.key;
    }

    public byte[] getDigest() {
        return this.digest;
    }

    public String getDigestAsString() {
        return ISOUtil.hexString(this.digest);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("key='");
        sb.append(this.key);
        sb.append("', digest=");
        sb.append(this.getDigestAsString());
        return sb.toString();
    }

    public static byte[] serialize(Object obj) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(obj);
        oos.close();
        return baos.toByteArray();
    }
}

