/*
 * Decompiled with CFR 0.152.
 */
package org.jpos.space;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.Environment;
import com.sleepycat.je.EnvironmentConfig;
import com.sleepycat.je.Transaction;
import com.sleepycat.persist.EntityCursor;
import com.sleepycat.persist.EntityStore;
import com.sleepycat.persist.PrimaryIndex;
import com.sleepycat.persist.SecondaryIndex;
import com.sleepycat.persist.StoreConfig;
import com.sleepycat.persist.model.Entity;
import com.sleepycat.persist.model.Persistent;
import com.sleepycat.persist.model.PrimaryKey;
import com.sleepycat.persist.model.Relationship;
import com.sleepycat.persist.model.SecondaryKey;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.jpos.space.LocalSpace;
import org.jpos.space.ObjectTemplate;
import org.jpos.space.Space;
import org.jpos.space.SpaceError;
import org.jpos.space.SpaceFactory;
import org.jpos.space.SpaceListener;
import org.jpos.space.TSpace;
import org.jpos.space.Template;
import org.jpos.util.Log;
import org.jpos.util.Loggeable;

public class JESpace<K, V>
extends Log
implements LocalSpace<K, V>,
Loggeable,
Runnable {
    Environment dbe = null;
    EntityStore store = null;
    PrimaryIndex<Long, Ref> pIndex = null;
    PrimaryIndex<Long, GCRef> gcpIndex = null;
    SecondaryIndex<String, Long, Ref> sIndex = null;
    SecondaryIndex<Long, Long, GCRef> gcsIndex = null;
    Semaphore gcSem = new Semaphore(1);
    LocalSpace<Object, SpaceListener> sl;
    public static final long GC_DELAY = 60000L;
    private Future gcTask;
    static final Map<String, Space> spaceRegistrar = new HashMap<String, Space>();

    public JESpace(String name, String path) throws SpaceError {
        try {
            EnvironmentConfig envConfig = new EnvironmentConfig();
            StoreConfig storeConfig = new StoreConfig();
            envConfig.setAllowCreate(true);
            envConfig.setTransactional(true);
            envConfig.setLockTimeout(5L, TimeUnit.SECONDS);
            storeConfig.setAllowCreate(true);
            storeConfig.setTransactional(true);
            File dir = new File(path);
            dir.mkdirs();
            this.dbe = new Environment(dir, envConfig);
            this.store = new EntityStore(this.dbe, name, storeConfig);
            this.pIndex = this.store.getPrimaryIndex(Long.class, Ref.class);
            this.gcpIndex = this.store.getPrimaryIndex(Long.class, GCRef.class);
            this.sIndex = this.store.getSecondaryIndex(this.pIndex, String.class, "key");
            this.gcsIndex = this.store.getSecondaryIndex(this.gcpIndex, Long.class, "expires");
            this.gcTask = SpaceFactory.getGCExecutor().scheduleAtFixedRate(this, 60000L, 60000L, TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            throw new SpaceError(e);
        }
    }

    @Override
    public void out(K key, V value) {
        this.out(key, value, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void out(K key, V value, long timeout) {
        Transaction txn = null;
        try {
            txn = this.dbe.beginTransaction(null, null);
            Ref ref = new Ref(key.toString(), value, timeout);
            this.pIndex.put((Object)ref);
            if (timeout > 0L) {
                this.gcpIndex.putNoReturn((Object)new GCRef(ref.getId(), ref.getExpiration()));
            }
            txn.commit();
            txn = null;
            JESpace jESpace = this;
            synchronized (jESpace) {
                this.notifyAll();
            }
            if (this.sl != null) {
                this.notifyListeners(key, value);
            }
        }
        catch (Exception e) {
            throw new SpaceError(e);
        }
        finally {
            if (txn != null) {
                this.abort(txn);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void push(K key, V value, long timeout) {
        Transaction txn = null;
        try {
            txn = this.dbe.beginTransaction(null, null);
            Ref ref = new Ref(key.toString(), value, timeout);
            this.pIndex.put((Object)ref);
            this.pIndex.delete((Object)ref.getId());
            ref.reverseId();
            this.pIndex.put((Object)ref);
            txn.commit();
            txn = null;
            JESpace jESpace = this;
            synchronized (jESpace) {
                this.notifyAll();
            }
            if (this.sl != null) {
                this.notifyListeners(key, value);
            }
        }
        catch (Exception e) {
            throw new SpaceError(e);
        }
        finally {
            if (txn != null) {
                this.abort(txn);
            }
        }
    }

    @Override
    public void push(K key, V value) {
        this.push(key, value, 0L);
    }

    @Override
    public V rdp(Object key) {
        try {
            return (V)this.getObject(key, false);
        }
        catch (DatabaseException e) {
            throw new SpaceError(e);
        }
    }

    @Override
    public synchronized V in(Object key) {
        V obj;
        while ((obj = this.inp(key)) == null) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        return obj;
    }

    @Override
    public synchronized V in(Object key, long timeout) {
        V obj;
        long now = System.currentTimeMillis();
        long end = now + timeout;
        while ((obj = this.inp(key)) == null && (now = System.currentTimeMillis()) < end) {
            try {
                this.wait(end - now);
            }
            catch (InterruptedException ignored) {}
        }
        return obj;
    }

    @Override
    public synchronized V rd(Object key) {
        V obj;
        while ((obj = this.rdp(key)) == null) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        return obj;
    }

    @Override
    public synchronized V rd(Object key, long timeout) {
        V obj;
        long now = System.currentTimeMillis();
        long end = now + timeout;
        while ((obj = this.rdp(key)) == null && (now = System.currentTimeMillis()) < end) {
            try {
                this.wait(end - now);
            }
            catch (InterruptedException ignored) {}
        }
        return obj;
    }

    @Override
    public V inp(Object key) {
        try {
            return (V)this.getObject(key, true);
        }
        catch (DatabaseException e) {
            throw new SpaceError(e);
        }
    }

    @Override
    public boolean existAny(Object[] keys) {
        for (Object key : keys) {
            if (this.rdp(key) == null) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean existAny(Object[] keys, long timeout) {
        long now = System.currentTimeMillis();
        long end = now + timeout;
        while ((now = System.currentTimeMillis()) < end) {
            if (this.existAny(keys)) {
                return true;
            }
            JESpace jESpace = this;
            synchronized (jESpace) {
                try {
                    this.wait(end - now);
                }
                catch (InterruptedException ignored) {
                    // empty catch block
                }
            }
        }
        return false;
    }

    @Override
    public synchronized void put(K key, V value, long timeout) {
        while (this.inp(key) != null) {
        }
        this.out(key, value, timeout);
    }

    @Override
    public synchronized void put(K key, V value) {
        while (this.inp(key) != null) {
        }
        this.out(key, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void gc() throws DatabaseException {
        Transaction txn;
        block15: {
            EntityCursor cursor;
            block13: {
                block14: {
                    txn = null;
                    cursor = null;
                    if (this.gcSem.tryAcquire()) break block13;
                    if (cursor == null) break block14;
                    cursor.close();
                }
                if (txn != null) {
                    this.abort(txn);
                }
                this.gcSem.release();
                return;
            }
            try {
                txn = this.dbe.beginTransaction(null, null);
                cursor = this.gcsIndex.entities(txn, (Object)0L, true, (Object)System.currentTimeMillis(), false, null);
                for (GCRef gcRef : cursor) {
                    this.pIndex.delete((Object)gcRef.getId());
                    cursor.delete();
                }
                cursor.close();
                cursor = null;
                txn.commit();
                txn = null;
                if (this.sl != null) {
                    JESpace jESpace = this;
                    synchronized (jESpace) {
                        if (this.sl != null && this.sl.getKeySet().isEmpty()) {
                            this.sl = null;
                        }
                    }
                }
                if (cursor == null) break block15;
            }
            catch (Throwable throwable) {
                if (cursor != null) {
                    cursor.close();
                }
                if (txn != null) {
                    this.abort(txn);
                }
                this.gcSem.release();
                throw throwable;
            }
            cursor.close();
        }
        if (txn != null) {
            this.abort(txn);
        }
        this.gcSem.release();
    }

    @Override
    public void run() {
        try {
            this.gc();
        }
        catch (DatabaseException e) {
            this.warn((Object)e);
        }
    }

    public void close() throws DatabaseException {
        this.gcSem.acquireUninterruptibly();
        this.gcTask.cancel(false);
        while (!this.gcTask.isDone()) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.store.close();
        this.dbe.close();
    }

    public static synchronized JESpace getSpace(String name, String path) {
        JESpace sp = (JESpace)spaceRegistrar.get(name);
        if (sp == null) {
            sp = new JESpace(name, path);
            spaceRegistrar.put(name, sp);
        }
        return sp;
    }

    public static JESpace getSpace(String name) {
        return JESpace.getSpace(name, name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getObject(Object key, boolean remove) throws DatabaseException {
        Transaction txn = null;
        EntityCursor cursor = null;
        Template tmpl = null;
        if (key instanceof Template) {
            tmpl = (Template)key;
            key = tmpl.getKey();
        }
        try {
            txn = this.dbe.beginTransaction(null, null);
            cursor = this.sIndex.subIndex((Object)key.toString()).entities(txn, null);
            for (Ref ref : cursor) {
                if (ref.isActive()) {
                    if (tmpl != null && !tmpl.equals(ref.getValue())) continue;
                    if (remove) {
                        cursor.delete();
                        if (ref.hasExpiration()) {
                            this.gcpIndex.delete(txn, (Object)ref.getId());
                        }
                    }
                    cursor.close();
                    cursor = null;
                    txn.commit();
                    txn = null;
                    Object object = ref.getValue();
                    return object;
                }
                cursor.delete();
                if (!ref.hasExpiration()) continue;
                this.gcpIndex.delete(txn, (Object)ref.getId());
            }
            cursor.close();
            cursor = null;
            txn.commit();
            txn = null;
            Object var6_6 = null;
            return var6_6;
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
            if (txn != null) {
                txn.abort();
            }
        }
    }

    private void abort(Transaction txn) throws SpaceError {
        try {
            txn.abort();
        }
        catch (DatabaseException e) {
            throw new SpaceError(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LocalSpace<Object, SpaceListener> getSL() {
        JESpace jESpace = this;
        synchronized (jESpace) {
            if (this.sl == null) {
                this.sl = new TSpace<Object, SpaceListener>();
            }
        }
        return this.sl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListeners(Object key, Object value) {
        HashSet<SpaceListener> listeners = new HashSet<SpaceListener>();
        JESpace jESpace = this;
        synchronized (jESpace) {
            if (this.sl == null) {
                return;
            }
            SpaceListener s = null;
            while ((s = (SpaceListener)this.sl.inp(key)) != null) {
                listeners.add(s);
            }
            for (SpaceListener spl : listeners) {
                this.sl.out(key, spl);
            }
        }
        for (SpaceListener spl : listeners) {
            spl.notify(key, value);
        }
    }

    @Override
    public synchronized void addListener(Object key, SpaceListener listener) {
        this.getSL().out(key, listener);
    }

    @Override
    public synchronized void addListener(Object key, SpaceListener listener, long timeout) {
        this.getSL().out(key, listener);
    }

    @Override
    public synchronized void removeListener(Object key, SpaceListener listener) {
        if (this.sl != null) {
            this.sl.inp(new ObjectTemplate(key, listener));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set getKeySet() {
        HashSet<Object> res = new HashSet<Object>();
        Transaction txn = null;
        EntityCursor cursor = null;
        try {
            txn = this.dbe.beginTransaction(null, null);
            cursor = this.sIndex.entities(txn, null);
            for (Ref ref : cursor) {
                res.add(ref.getKey());
            }
            cursor.close();
            cursor = null;
            txn.commit();
            txn = null;
        }
        catch (IllegalStateException e) {
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
            if (txn != null) {
                txn.abort();
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size(Object key) {
        Transaction txn = null;
        EntityCursor cursor = null;
        try {
            txn = this.dbe.beginTransaction(null, null);
            cursor = this.sIndex.subIndex((Object)key.toString()).entities(txn, null);
            int keyCount = 0;
            for (Ref ref : cursor) {
                if (!ref.isActive()) continue;
                ++keyCount;
            }
            cursor.close();
            cursor = null;
            txn.commit();
            txn = null;
            int n = keyCount;
            return n;
        }
        catch (IllegalStateException e) {
            int n = -1;
            return n;
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
            if (txn != null) {
                txn.abort();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dump(PrintStream p, String indent) {
        Transaction txn = null;
        EntityCursor cursor = null;
        int count = 0;
        try {
            txn = this.dbe.beginTransaction(null, null);
            cursor = this.sIndex.entities(txn, null);
            String key = null;
            int keyCount = 0;
            for (Ref ref : cursor) {
                if (ref.getKey().equals(key)) {
                    ++keyCount;
                    continue;
                }
                if (key != null) {
                    this.dumpKey(p, indent, key, keyCount);
                    ++count;
                }
                keyCount = 1;
                key = ref.getKey().toString();
            }
            if (key != null) {
                this.dumpKey(p, indent, key, keyCount);
                ++count;
            }
            p.println(indent + "<keycount>" + count + "</keycount>");
            cursor.close();
            cursor = null;
            txn.commit();
            txn = null;
        }
        catch (IllegalStateException e) {
            p.println(indent + "<keycount>0</keycount>");
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
            if (txn != null) {
                txn.abort();
            }
        }
    }

    private void dumpKey(PrintStream p, String indent, String key, int count) {
        if (count > 0) {
            p.printf("%s<key size='%d'>%s</key>\n", indent, count, key);
        } else {
            p.printf("%s<key>%s</key>\n", indent, key);
        }
    }

    @Entity
    public static class GCRef {
        @PrimaryKey
        private long id;
        @SecondaryKey(relate=Relationship.MANY_TO_ONE)
        private long expires;

        public GCRef() {
        }

        public GCRef(long id, long expires) {
            this.id = id;
            this.expires = expires;
        }

        public long getId() {
            return this.id;
        }

        public boolean isExpired() {
            return this.expires > 0L && this.expires < System.currentTimeMillis();
        }

        public long getExpiration() {
            return this.expires;
        }
    }

    @Entity
    public static class Ref {
        @PrimaryKey(sequence="Ref.id")
        private long id;
        @SecondaryKey(relate=Relationship.MANY_TO_ONE)
        private String key;
        private long expires;
        private Object value;

        public Ref() {
        }

        public Ref(String key, Object value, long timeout) {
            this.key = key;
            this.value = this.serialize(value);
            if (timeout > 0L) {
                this.expires = System.currentTimeMillis() + timeout;
            }
        }

        public long getId() {
            return this.id;
        }

        public void reverseId() {
            this.id = -this.id;
        }

        public boolean isExpired() {
            return this.expires > 0L && this.expires < System.currentTimeMillis();
        }

        public boolean isActive() {
            return !this.isExpired();
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.deserialize(this.value);
        }

        public long getExpiration() {
            return this.expires;
        }

        public boolean hasExpiration() {
            return this.expires > 0L;
        }

        private boolean isPersistent(Class c) {
            return c.isPrimitive() || c.isAnnotationPresent(Entity.class) || c.isAnnotationPresent(Persistent.class);
        }

        private Object serialize(Object obj) {
            Class<?> cls = obj.getClass();
            if (this.isPersistent(cls)) {
                return obj;
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try {
                ObjectOutputStream os = new ObjectOutputStream(baos);
                os.writeObject(obj);
                obj = baos.toByteArray();
            }
            catch (IOException e) {
                throw new SpaceError(e);
            }
            return obj;
        }

        private Object deserialize(Object obj) {
            Class<?> cls = obj.getClass();
            if (this.isPersistent(cls)) {
                return obj;
            }
            ByteArrayInputStream bais = new ByteArrayInputStream((byte[])obj);
            try {
                ObjectInputStream is = new ObjectInputStream(bais);
                return is.readObject();
            }
            catch (Exception e) {
                throw new SpaceError(e);
            }
        }
    }
}

