/*
 * Decompiled with CFR 0.152.
 */
package org.jpos.space;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.TimerTask;
import jdbm.RecordManager;
import jdbm.RecordManagerFactory;
import jdbm.helper.FastIterator;
import jdbm.helper.Serializer;
import jdbm.htree.HTree;
import org.jpos.space.Space;
import org.jpos.space.SpaceError;
import org.jpos.space.Template;
import org.jpos.util.DefaultTimer;

public class JDBMSpace<K, V>
extends TimerTask
implements Space<K, V> {
    protected HTree htree;
    protected RecordManager recman;
    protected static final Serializer refSerializer = new Ref();
    protected static final Map<String, Space> spaceRegistrar = new HashMap<String, Space>();
    protected boolean autoCommit = true;
    protected String name;
    public static final long GCDELAY = 300000L;

    protected JDBMSpace(String name, String filename) {
        this.name = name;
        try {
            Properties props = new Properties();
            props.put("jdbm.cache.size", "512");
            this.recman = RecordManagerFactory.createRecordManager((String)filename, (Properties)props);
            long recid = this.recman.getNamedObject("space");
            if (recid != 0L) {
                this.htree = HTree.load((RecordManager)this.recman, (long)recid);
            } else {
                this.htree = HTree.createInstance((RecordManager)this.recman);
                this.recman.setNamedObject("space", this.htree.getRecid());
            }
            this.recman.commit();
        }
        catch (IOException e) {
            throw new SpaceError(e);
        }
        DefaultTimer.getTimer().schedule((TimerTask)this, 300000L, 300000L);
    }

    public static JDBMSpace getSpace() {
        return JDBMSpace.getSpace("space");
    }

    public static JDBMSpace getSpace(String name) {
        return JDBMSpace.getSpace(name, name);
    }

    public static synchronized JDBMSpace getSpace(String name, String filename) {
        JDBMSpace sp = (JDBMSpace)spaceRegistrar.get(name);
        if (sp == null) {
            sp = new JDBMSpace(name, filename);
            spaceRegistrar.put(name, sp);
        }
        return sp;
    }

    public void setAutoCommit(boolean b) {
        this.autoCommit = b;
    }

    public void commit() {
        try {
            this.recman.commit();
            this.notifyAll();
        }
        catch (IOException e) {
            throw new SpaceError(e);
        }
    }

    public void rollback() {
        try {
            this.recman.rollback();
        }
        catch (IOException e) {
            throw new SpaceError(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = JDBMSpace.class;
        synchronized (JDBMSpace.class) {
            spaceRegistrar.remove(this.name);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            object = this;
            synchronized (object) {
                try {
                    this.recman.close();
                    this.recman = null;
                }
                catch (IOException e) {
                    throw new SpaceError(e);
                }
            }
            return;
        }
    }

    @Override
    public void out(K key, V value) {
        this.out(key, value, -1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void out(K key, V value, long timeout) {
        if (key == null || value == null) {
            throw new NullPointerException("key=" + key + ", value=" + value);
        }
        try {
            JDBMSpace jDBMSpace = this;
            synchronized (jDBMSpace) {
                long recid = this.recman.insert(value);
                long expiration = timeout == -1L ? Long.MAX_VALUE : System.currentTimeMillis() + timeout;
                Ref dataRef = new Ref(recid, expiration);
                long dataRefRecId = this.recman.insert((Object)dataRef, refSerializer);
                Head head = (Head)this.htree.get(key);
                if (head == null) {
                    head = new Head();
                    head.first = dataRefRecId;
                    head.last = dataRefRecId;
                    head.count = 1L;
                } else {
                    long previousLast = head.last;
                    Ref lastRef = (Ref)this.recman.fetch(previousLast, refSerializer);
                    lastRef.next = dataRefRecId;
                    head.last = dataRefRecId;
                    ++head.count;
                    this.recman.update(previousLast, (Object)lastRef, refSerializer);
                }
                this.htree.put(key, (Object)head);
                if (this.autoCommit) {
                    this.recman.commit();
                    this.notifyAll();
                }
            }
        }
        catch (IOException e) {
            throw new SpaceError(e);
        }
    }

    @Override
    public void push(K key, V value) {
        this.push((Object)key, (Object)value, -1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void push(Object key, Object value, long timeout) {
        if (key == null || value == null) {
            throw new NullPointerException("key=" + key + ", value=" + value);
        }
        try {
            JDBMSpace jDBMSpace = this;
            synchronized (jDBMSpace) {
                long recid = this.recman.insert(value);
                long expiration = timeout == -1L ? Long.MAX_VALUE : System.currentTimeMillis() + timeout;
                Ref dataRef = new Ref(recid, expiration);
                Head head = (Head)this.htree.get(key);
                if (head == null) {
                    head = new Head();
                    head.first = head.last = this.recman.insert((Object)dataRef, refSerializer);
                } else {
                    dataRef.next = head.first;
                    head.first = this.recman.insert((Object)dataRef, refSerializer);
                }
                ++head.count;
                this.htree.put(key, (Object)head);
                if (this.autoCommit) {
                    this.recman.commit();
                    this.notifyAll();
                }
            }
        }
        catch (IOException e) {
            throw new SpaceError(e);
        }
    }

    @Override
    public synchronized V rdp(Object key) {
        try {
            if (key instanceof Template) {
                return (V)this.getObject((Template)key, false);
            }
            Object obj = null;
            Ref ref = this.getFirst(key, false);
            if (ref != null) {
                obj = this.recman.fetch(ref.recid);
            }
            if (this.autoCommit) {
                this.recman.commit();
            }
            return (V)obj;
        }
        catch (IOException e) {
            throw new SpaceError(e);
        }
    }

    @Override
    public synchronized V inp(Object key) {
        try {
            if (key instanceof Template) {
                return (V)this.getObject((Template)key, true);
            }
            Object obj = null;
            Ref ref = this.getFirst(key, true);
            if (ref != null) {
                obj = this.recman.fetch(ref.recid);
                this.recman.delete(ref.recid);
            }
            if (this.autoCommit) {
                this.recman.commit();
            }
            return (V)obj;
        }
        catch (IOException e) {
            throw new SpaceError(e);
        }
    }

    @Override
    public synchronized V in(Object key) {
        V obj;
        while ((obj = this.inp(key)) == null) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        return obj;
    }

    @Override
    public synchronized V in(Object key, long timeout) {
        V obj;
        long now = System.currentTimeMillis();
        long end = now + timeout;
        while ((obj = this.inp(key)) == null && (now = System.currentTimeMillis()) < end) {
            try {
                this.wait(end - now);
            }
            catch (InterruptedException ignored) {}
        }
        return obj;
    }

    @Override
    public synchronized V rd(Object key) {
        V obj;
        while ((obj = this.rdp(key)) == null) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        return obj;
    }

    @Override
    public synchronized V rd(Object key, long timeout) {
        V obj;
        long now = System.currentTimeMillis();
        long end = now + timeout;
        while ((obj = this.rdp(key)) == null && (now = System.currentTimeMillis()) < end) {
            try {
                this.wait(end - now);
            }
            catch (InterruptedException ignored) {}
        }
        return obj;
    }

    public long size(Object key) {
        try {
            Head head = (Head)this.htree.get(key);
            return head != null ? head.count : 0L;
        }
        catch (IOException e) {
            throw new SpaceError(e);
        }
    }

    @Override
    public boolean existAny(Object[] keys) {
        for (Object key : keys) {
            if (this.rdp(key) == null) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean existAny(Object[] keys, long timeout) {
        long now = System.currentTimeMillis();
        long end = now + timeout;
        while ((now = System.currentTimeMillis()) < end) {
            if (this.existAny(keys)) {
                return true;
            }
            JDBMSpace jDBMSpace = this;
            synchronized (jDBMSpace) {
                try {
                    this.wait(end - now);
                }
                catch (InterruptedException ignored) {
                    // empty catch block
                }
            }
        }
        return false;
    }

    @Override
    public synchronized void put(K key, V value, long timeout) {
        while (this.inp(key) != null) {
        }
        this.out(key, value, timeout);
    }

    @Override
    public synchronized void put(K key, V value) {
        while (this.inp(key) != null) {
        }
        this.out(key, value);
    }

    private void purge(Object key) throws IOException {
        Head head = (Head)this.htree.get(key);
        Ref previousRef = null;
        if (head != null) {
            long recid = head.first;
            while (recid >= 0L) {
                Ref r = (Ref)this.recman.fetch(recid, refSerializer);
                if (r.isExpired()) {
                    this.recman.delete(r.recid);
                    this.recman.delete(recid);
                    --head.count;
                    if (previousRef == null) {
                        head.first = r.next;
                    } else {
                        previousRef.next = r.next;
                        this.recman.update(head.last, (Object)previousRef, refSerializer);
                    }
                } else {
                    previousRef = r;
                    head.last = recid;
                }
                recid = r.next;
            }
            if (head.first == -1L) {
                this.htree.remove(key);
            } else {
                this.htree.put(key, (Object)head);
            }
        }
    }

    @Override
    public void run() {
        try {
            this.gc();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void gc() {
        String GCKEY = "GC$" + Integer.toString(this.hashCode());
        long TIMEOUT = 86400000L;
        try {
            Object obj;
            JDBMSpace jDBMSpace = this;
            synchronized (jDBMSpace) {
                if (this.rdp(GCKEY) != null) {
                    return;
                }
                this.out(GCKEY, Boolean.TRUE, 86400000L);
            }
            FastIterator iter = this.htree.keys();
            try {
                while ((obj = iter.next()) != null) {
                    this.out(GCKEY, obj, 86400000L);
                    Thread.yield();
                }
            }
            catch (ConcurrentModificationException e) {
                // empty catch block
            }
            while ((obj = this.inp(GCKEY)) != null) {
                JDBMSpace jDBMSpace2 = this;
                synchronized (jDBMSpace2) {
                    this.purge(obj);
                    this.recman.commit();
                }
                Thread.yield();
            }
        }
        catch (IOException e) {
            throw new SpaceError(e);
        }
    }

    public String getKeys() {
        StringBuilder sb = new StringBuilder();
        try {
            Object obj;
            FastIterator iter = this.htree.keys();
            while ((obj = iter.next()) != null) {
                if (sb.length() > 0) {
                    sb.append(' ');
                }
                sb.append(obj.toString());
            }
        }
        catch (IOException e) {
            throw new SpaceError(e);
        }
        return sb.toString();
    }

    private Ref getFirst(Object key, boolean remove) throws IOException {
        Head head = (Head)this.htree.get(key);
        Ref ref = null;
        if (head != null) {
            long recid = head.first;
            while (recid >= 0L) {
                Ref r = (Ref)this.recman.fetch(recid, refSerializer);
                if (r.isExpired()) {
                    this.recman.delete(r.recid);
                    this.recman.delete(recid);
                    recid = r.next;
                    --head.count;
                    continue;
                }
                ref = r;
                if (!remove) break;
                this.recman.delete(recid);
                recid = ref.next;
                --head.count;
                break;
            }
            if (head.first != recid) {
                if (recid < 0L) {
                    this.htree.remove(key);
                } else {
                    head.first = recid;
                    this.htree.put(key, (Object)head);
                }
            }
        }
        return ref;
    }

    private void unlinkRef(long recid, Head head, Ref r, Ref previousRef, long previousRecId) throws IOException {
        this.recman.delete(r.recid);
        this.recman.delete(recid);
        --head.count;
        if (previousRef == null) {
            head.first = r.next;
        } else {
            previousRef.next = r.next;
            this.recman.update(previousRecId, (Object)previousRef, refSerializer);
        }
    }

    private Object getObject(Template tmpl, boolean remove) throws IOException {
        Object obj = null;
        Object key = tmpl.getKey();
        Head head = (Head)this.htree.get(key);
        Ref previousRef = null;
        long previousRecId = 0L;
        int unlinkCount = 0;
        if (head != null) {
            long recid = head.first;
            while (recid >= 0L) {
                Ref r = (Ref)this.recman.fetch(recid, refSerializer);
                if (r.isExpired()) {
                    this.unlinkRef(recid, head, r, previousRef, previousRecId);
                    ++unlinkCount;
                } else {
                    Object o = this.recman.fetch(r.recid);
                    if (o != null && tmpl.equals(o)) {
                        obj = o;
                        if (!remove) break;
                        this.unlinkRef(recid, head, r, previousRef, previousRecId);
                        ++unlinkCount;
                        break;
                    }
                    previousRef = r;
                    previousRecId = recid;
                }
                recid = r.next;
            }
            if (unlinkCount > 0) {
                if (head.first == -1L) {
                    this.htree.remove(key);
                } else {
                    this.htree.put(key, (Object)head);
                }
            }
        }
        return obj;
    }

    static void putLong(byte[] b, int off, long val) {
        b[off + 7] = (byte)val;
        b[off + 6] = (byte)(val >>> 8);
        b[off + 5] = (byte)(val >>> 16);
        b[off + 4] = (byte)(val >>> 24);
        b[off + 3] = (byte)(val >>> 32);
        b[off + 2] = (byte)(val >>> 40);
        b[off + 1] = (byte)(val >>> 48);
        b[off] = (byte)(val >>> 56);
    }

    static long getLong(byte[] b, int off) {
        return ((long)b[off + 7] & 0xFFL) + (((long)b[off + 6] & 0xFFL) << 8) + (((long)b[off + 5] & 0xFFL) << 16) + (((long)b[off + 4] & 0xFFL) << 24) + (((long)b[off + 3] & 0xFFL) << 32) + (((long)b[off + 2] & 0xFFL) << 40) + (((long)b[off + 1] & 0xFFL) << 48) + (((long)b[off] & 0xFFL) << 56);
    }

    static class Ref
    implements Serializer {
        long recid;
        long expires;
        long next;
        static final long serialVersionUID = 1L;

        public Ref() {
        }

        public Ref(long recid, long expires) {
            this.recid = recid;
            this.expires = expires;
            this.next = -1L;
        }

        public boolean isExpired() {
            return this.expires < System.currentTimeMillis();
        }

        public String toString() {
            return this.getClass().getName() + "@" + Integer.toHexString(this.hashCode()) + ":[recid=" + this.recid + ",next=" + this.next + ",expired=" + this.isExpired() + "]";
        }

        public byte[] serialize(Object obj) throws IOException {
            Ref d = (Ref)obj;
            byte[] buf = new byte[24];
            JDBMSpace.putLong(buf, 0, d.recid);
            JDBMSpace.putLong(buf, 8, d.next);
            JDBMSpace.putLong(buf, 16, d.expires);
            return buf;
        }

        public Object deserialize(byte[] serialized) throws IOException {
            Ref d = new Ref();
            d.recid = JDBMSpace.getLong(serialized, 0);
            d.next = JDBMSpace.getLong(serialized, 8);
            d.expires = JDBMSpace.getLong(serialized, 16);
            return d;
        }
    }

    static class Head
    implements Externalizable {
        public long first = -1L;
        public long last = -1L;
        public long count;
        static final long serialVersionUID = 2L;

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeLong(this.first);
            out.writeLong(this.last);
            out.writeLong(this.count);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException {
            this.first = in.readLong();
            this.last = in.readLong();
            this.count = in.readLong();
        }

        public String toString() {
            return this.getClass().getName() + "@" + Integer.toHexString(this.hashCode()) + ":[first=" + this.first + ",last=" + this.last + "]";
        }
    }
}

