/*
 * Decompiled with CFR 0.152.
 */
package org.jpos.security.jceadapter;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.TreeMap;
import javax.crypto.SecretKey;
import org.javatuples.Pair;
import org.jpos.core.Configuration;
import org.jpos.core.ConfigurationException;
import org.jpos.iso.ISODate;
import org.jpos.iso.ISOException;
import org.jpos.iso.ISOUtil;
import org.jpos.security.BaseSMAdapter;
import org.jpos.security.EncryptedPIN;
import org.jpos.security.KeyScheme;
import org.jpos.security.MKDMethod;
import org.jpos.security.PaddingMethod;
import org.jpos.security.SKDMethod;
import org.jpos.security.SMException;
import org.jpos.security.SecureDESKey;
import org.jpos.security.Util;
import org.jpos.security.WeakPINException;
import org.jpos.security.jceadapter.JCEHandler;
import org.jpos.security.jceadapter.JCEHandlerException;
import org.jpos.util.LogEvent;
import org.jpos.util.Logger;
import org.jpos.util.SimpleMsg;

public class JCESecurityModule
extends BaseSMAdapter {
    private static final int LMK_PAIRS_NO = 14;
    private static final int[] variants = new int[]{0, 166, 90, 106, 222, 43, 80, 116, 156, 250};
    private static final int[] schemeVariants = new int[]{0, 166, 90, 106, 222, 43};
    private static final int KEY_U_LEFT = 1;
    private static final int KEY_U_RIGHT = 2;
    private static final int KEY_T_LEFT = 3;
    private static final int KEY_T_MEDIUM = 4;
    private static final int KEY_T_RIGHT = 5;
    private static MessageDigest SHA1_MESSAGE_DIGEST = null;
    private Map<String, Integer> keyTypeToLMKIndex;
    private Map<Integer, SecretKey> lmks = new TreeMap<Integer, SecretKey>();
    private static final Integer PINLMKIndex;
    private static final short LMK_KEY_LENGTH = 128;
    private static final short MIN_PIN_LENGTH = 4;
    private static final short MAX_PIN_LENGTH = 12;
    private static final byte[] fPaddingBlock;
    private static final byte[] zeroBlock;
    private JCEHandler jceHandler;

    public JCESecurityModule() {
    }

    public JCESecurityModule(String lmkFile) throws SMException {
        this.init(null, lmkFile, false);
    }

    public JCESecurityModule(String lmkFile, String jceProviderClassName) throws SMException {
        this.init(jceProviderClassName, lmkFile, false);
    }

    public JCESecurityModule(Configuration cfg, Logger logger, String realm) throws ConfigurationException {
        this.setLogger(logger, realm);
        this.setConfiguration(cfg);
    }

    @Override
    public void setConfiguration(Configuration cfg) throws ConfigurationException {
        this.cfg = cfg;
        try {
            this.init(cfg.get("provider"), cfg.get("lmk"), cfg.getBoolean("rebuildlmk"));
        }
        catch (SMException e) {
            throw new ConfigurationException(e);
        }
    }

    @Override
    public SecureDESKey generateKeyImpl(short keyLength, String keyType) throws SMException {
        SecureDESKey generatedSecureKey = null;
        Key generatedClearKey = this.jceHandler.generateDESKey(keyLength);
        generatedSecureKey = this.encryptToLMK(keyLength, keyType, generatedClearKey);
        return generatedSecureKey;
    }

    @Override
    public SecureDESKey importKeyImpl(short keyLength, String keyType, byte[] encryptedKey, SecureDESKey kek, boolean checkParity) throws SMException {
        SecureDESKey importedKey = null;
        Key clearKEY = this.jceHandler.decryptDESKey(keyLength, encryptedKey, this.decryptFromLMK(kek), checkParity);
        importedKey = this.encryptToLMK(keyLength, keyType, clearKEY);
        return importedKey;
    }

    @Override
    public byte[] exportKeyImpl(SecureDESKey key, SecureDESKey kek) throws SMException {
        byte[] exportedKey = null;
        Key clearKey = this.decryptFromLMK(key);
        exportedKey = this.jceHandler.encryptDESKey(key.getKeyLength(), clearKey, this.decryptFromLMK(kek));
        return exportedKey;
    }

    private int getKeyTypeIndex(short keyLength, String keyType) throws SMException {
        int index = 0;
        if (keyType == null) {
            return index;
        }
        StringTokenizer st = new StringTokenizer(keyType, ":;");
        if (st.hasMoreTokens()) {
            String majorType = st.nextToken();
            Integer idx = this.keyTypeToLMKIndex.get(majorType);
            if (idx == null) {
                throw new SMException("Unsupported key type: " + majorType);
            }
            index = idx;
        }
        if (st.hasMoreTokens()) {
            try {
                index |= Integer.valueOf(st.nextToken().substring(0, 1)) << 8;
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        return index;
    }

    private static KeyScheme getScheme(int keyLength, String keyType) {
        KeyScheme scheme = KeyScheme.Z;
        switch (keyLength) {
            case 64: {
                scheme = KeyScheme.Z;
                break;
            }
            case 128: {
                scheme = KeyScheme.X;
                break;
            }
            case 192: {
                scheme = KeyScheme.Y;
            }
        }
        if (keyType == null) {
            return scheme;
        }
        StringTokenizer st = new StringTokenizer(keyType, ":;");
        if (st.hasMoreTokens()) {
            st.nextToken();
        }
        if (st.hasMoreTokens()) {
            try {
                scheme = KeyScheme.valueOf(st.nextToken().substring(1, 2));
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        return scheme;
    }

    @Override
    public EncryptedPIN encryptPINImpl(String pin, String accountNumber) throws SMException {
        EncryptedPIN encryptedPIN = null;
        byte[] clearPINBlock = this.calculatePINBlock(pin, (byte)0, accountNumber);
        byte[] translatedPINBlock = this.jceHandler.encryptData(clearPINBlock, this.getLMK(PINLMKIndex));
        encryptedPIN = new EncryptedPIN(translatedPINBlock, 0, accountNumber, false);
        return encryptedPIN;
    }

    @Override
    public String decryptPINImpl(EncryptedPIN pinUnderLmk) throws SMException {
        String pin = null;
        byte[] clearPINBlock = this.jceHandler.decryptData(pinUnderLmk.getPINBlock(), this.getLMK(PINLMKIndex));
        pin = this.calculatePIN(clearPINBlock, pinUnderLmk.getPINBlockFormat(), pinUnderLmk.getAccountNumber());
        return pin;
    }

    @Override
    public EncryptedPIN importPINImpl(EncryptedPIN pinUnderKd1, SecureDESKey kd1) throws SMException {
        EncryptedPIN pinUnderLmk = null;
        String accountNumber = pinUnderKd1.getAccountNumber();
        byte destinationPINBlockFormat = 0;
        byte[] clearPINBlock = this.jceHandler.decryptData(pinUnderKd1.getPINBlock(), this.decryptFromLMK(kd1));
        String pin = this.calculatePIN(clearPINBlock, pinUnderKd1.getPINBlockFormat(), accountNumber);
        clearPINBlock = this.calculatePINBlock(pin, destinationPINBlockFormat, accountNumber);
        byte[] translatedPINBlock = this.jceHandler.encryptData(clearPINBlock, this.getLMK(PINLMKIndex));
        pinUnderLmk = new EncryptedPIN(translatedPINBlock, destinationPINBlockFormat, accountNumber, false);
        return pinUnderLmk;
    }

    @Override
    public EncryptedPIN exportPINImpl(EncryptedPIN pinUnderLmk, SecureDESKey kd2, byte destinationPINBlockFormat) throws SMException {
        EncryptedPIN exportedPIN = null;
        String accountNumber = pinUnderLmk.getAccountNumber();
        byte[] clearPINBlock = this.jceHandler.decryptData(pinUnderLmk.getPINBlock(), this.getLMK(PINLMKIndex));
        String pin = this.calculatePIN(clearPINBlock, pinUnderLmk.getPINBlockFormat(), accountNumber);
        clearPINBlock = this.calculatePINBlock(pin, destinationPINBlockFormat, accountNumber);
        byte[] translatedPINBlock = this.jceHandler.encryptData(clearPINBlock, this.decryptFromLMK(kd2));
        exportedPIN = new EncryptedPIN(translatedPINBlock, destinationPINBlockFormat, accountNumber, false);
        return exportedPIN;
    }

    @Override
    public EncryptedPIN generatePINImpl(String accountNumber, int pinLen, List<String> excludes) throws SMException {
        long pinl;
        String pin;
        if (excludes == null) {
            excludes = Arrays.asList(new Object[0]);
        }
        SecureRandom rd = new SecureRandom();
        int max = (int)Math.pow(10.0, Math.min(pinLen, 9));
        int max2 = (int)Math.pow(10.0, Math.max(pinLen - 9, 0));
        do {
            pinl = rd.nextInt(max);
            if (pinLen <= 9) continue;
            pinl *= (long)max2;
            pinl += (long)rd.nextInt(max2);
        } while (excludes.contains(pin = ISOUtil.zeropad(pinl, pinLen)));
        return this.encryptPINImpl(pin, accountNumber);
    }

    private static String decimalizeVisa(byte[] b) {
        char[] bec = ISOUtil.hexString(b).toUpperCase().toCharArray();
        char[] bhc = new char[bec.length];
        int k = 0;
        for (char c : bec) {
            if (c >= 'A') continue;
            bhc[k++] = c;
        }
        int adjust = 17;
        for (char c : bec) {
            if (c < 'A') continue;
            bhc[k++] = (char)(c - adjust);
        }
        return new String(bhc);
    }

    private Key concatKeys(SecureDESKey keyA, SecureDESKey keyB) throws SMException {
        if (keyA != null && keyA.getKeyLength() == 64 && keyB != null && keyB.getKeyLength() == 64) {
            Key cvkAclear = this.decryptFromLMK(keyA);
            Key cvkBclear = this.decryptFromLMK(keyB);
            return this.jceHandler.formDESKey((short)128, ISOUtil.concat(cvkAclear.getEncoded(), cvkBclear.getEncoded()));
        }
        if (keyA != null && keyA.getKeyLength() != 64) {
            return this.decryptFromLMK(keyA);
        }
        if (keyB != null && keyB.getKeyLength() != 64) {
            return this.decryptFromLMK(keyB);
        }
        return null;
    }

    private String calculateCVV(String accountNo, Key cvk, Date expDate, String serviceCode) throws SMException {
        Key udka = this.jceHandler.formDESKey((short)64, Arrays.copyOfRange(cvk.getEncoded(), 0, 8));
        byte[] block = ISOUtil.hex2byte(ISOUtil.zeropadRight(accountNo + ISODate.formatDate(expDate, "yyMM") + serviceCode, 32));
        byte[] ba = Arrays.copyOfRange(block, 0, 8);
        byte[] bb = Arrays.copyOfRange(block, 8, 16);
        byte[] bc = this.jceHandler.encryptData(ba, udka);
        byte[] bd = ISOUtil.xor(bc, bb);
        byte[] be = this.jceHandler.encryptData(bd, cvk);
        return JCESecurityModule.decimalizeVisa(be).substring(0, 3);
    }

    @Override
    protected String calculateCVVImpl(String accountNo, SecureDESKey cvkA, SecureDESKey cvkB, Date expDate, String serviceCode) throws SMException {
        return this.calculateCVV(accountNo, this.concatKeys(cvkA, cvkB), expDate, serviceCode);
    }

    @Override
    protected boolean verifyCVVImpl(String accountNo, SecureDESKey cvkA, SecureDESKey cvkB, String cvv, Date expDate, String serviceCode) throws SMException {
        String result = this.calculateCVV(accountNo, this.concatKeys(cvkA, cvkB), expDate, serviceCode);
        return result.equals(cvv);
    }

    @Override
    protected boolean verifydCVVImpl(String accountNo, SecureDESKey imkac, String dcvv, Date expDate, String serviceCode, byte[] atc, MKDMethod mkdm) throws SMException {
        if (mkdm == null) {
            mkdm = MKDMethod.OPTION_A;
        }
        byte[] panpsn = JCESecurityModule.formatPANPSN(accountNo, null, mkdm);
        Key mkac = this.deriveICCMasterKey(this.decryptFromLMK(imkac), panpsn);
        String alteredPAN = ISOUtil.hexString(atc) + accountNo.substring(4);
        String res = this.calculateCVV(alteredPAN, mkac, expDate, serviceCode);
        return res.equals(dcvv);
    }

    @Override
    protected boolean verifyCVC3Impl(SecureDESKey imkcvc3, String accountNo, String acctSeqNo, byte[] atc, byte[] upn, byte[] data, MKDMethod mkdm, String cvc3) throws SMException {
        if (mkdm == null) {
            mkdm = MKDMethod.OPTION_A;
        }
        byte[] panpsn = JCESecurityModule.formatPANPSN(accountNo, acctSeqNo, mkdm);
        Key mkcvc3 = this.deriveICCMasterKey(this.decryptFromLMK(imkcvc3), panpsn);
        byte[] ivcvc3 = data;
        if (ivcvc3.length != 2) {
            ivcvc3 = this.calculateIVCVC3(mkcvc3, data);
        }
        byte[] b = ISOUtil.concat(ivcvc3, upn);
        b = ISOUtil.concat(b, atc);
        b = this.jceHandler.encryptData(b, mkcvc3);
        int cvc3l = (b[6] & 0xFF) << 8;
        String calcCVC3 = String.format("%05d", cvc3l |= b[7] & 0xFF);
        cvc3 = cvc3 == null ? "" : cvc3;
        calcCVC3 = calcCVC3.substring(5 - cvc3.length());
        return calcCVC3.equals(cvc3);
    }

    private byte[] calculateIVCVC3(Key mkcvc3, byte[] data) throws JCEHandlerException {
        byte[] paddedData = this.paddingISO9797Method2(data);
        byte[] mac = this.calculateMACISO9797Alg3(mkcvc3, paddedData);
        return Arrays.copyOfRange(mac, 6, 8);
    }

    private byte[] paddingISO9797Method2(byte[] d) {
        byte[] t = new byte[d.length - d.length % 8 + 8];
        System.arraycopy(d, 0, t, 0, d.length);
        for (int i = d.length; i < t.length; ++i) {
            t[i] = (byte)(i == d.length ? 128 : 0);
        }
        d = t;
        return d;
    }

    private byte[] calculateMACISO9797Alg3(Key key, byte[] d) throws JCEHandlerException {
        Key kl = this.jceHandler.formDESKey((short)64, Arrays.copyOfRange(key.getEncoded(), 0, 8));
        Key kr = this.jceHandler.formDESKey((short)64, Arrays.copyOfRange(key.getEncoded(), 8, 16));
        if (d.length % 8 != 0) {
            byte[] t = new byte[d.length - d.length % 8 + 8];
            System.arraycopy(d, 0, t, 0, d.length);
            d = t;
        }
        byte[] y_i = ISOUtil.hex2byte("0000000000000000");
        byte[] yi = new byte[8];
        for (int i = 0; i < d.length; i += 8) {
            System.arraycopy(d, i, yi, 0, yi.length);
            y_i = this.jceHandler.encryptData(ISOUtil.xor(yi, y_i), kl);
        }
        y_i = this.jceHandler.decryptData(y_i, kr);
        y_i = this.jceHandler.encryptData(y_i, kl);
        return y_i;
    }

    private static byte[] formatPANPSN(String pan, String psn, MKDMethod mkdm) throws SMException {
        byte[] b;
        switch (mkdm) {
            case OPTION_A: {
                b = JCESecurityModule.formatPANPSNOptionA(pan, psn);
                break;
            }
            case OPTION_B: {
                b = JCESecurityModule.formatPANPSNOptionB(pan, psn);
                break;
            }
            default: {
                throw new SMException("Unsupported ICC Master Key derivation method");
            }
        }
        return b;
    }

    private static byte[] preparePANPSN(String pan, String psn) {
        if (psn == null || psn.isEmpty()) {
            psn = "00";
        }
        String ret = pan + psn;
        return ISOUtil.hex2byte(ret);
    }

    private static byte[] formatPANPSNOptionA(String pan, String psn) {
        if (pan.length() < 14) {
            try {
                pan = ISOUtil.zeropad(pan, 14);
            }
            catch (ISOException ex) {
                // empty catch block
            }
        }
        byte[] b = JCESecurityModule.preparePANPSN(pan, psn);
        return Arrays.copyOfRange(b, b.length - 8, b.length);
    }

    private static byte[] formatPANPSNOptionB(String pan, String psn) {
        byte[] b = JCESecurityModule.preparePANPSN(pan, psn);
        byte[] r = SHA1_MESSAGE_DIGEST.digest(b);
        String rs = JCESecurityModule.decimalizeVisa(r);
        return ISOUtil.hex2byte(rs.substring(0, 16));
    }

    private Key deriveICCMasterKey(Key imk, byte[] panpsn) throws JCEHandlerException {
        byte[] l = Arrays.copyOfRange(panpsn, 0, 8);
        l = this.jceHandler.encryptData(l, imk);
        byte[] r = Arrays.copyOfRange(panpsn, 0, 8);
        r = ISOUtil.xor(r, fPaddingBlock);
        r = this.jceHandler.encryptData(r, imk);
        byte[] mk = ISOUtil.concat(l, r);
        Util.adjustDESParity(mk);
        return this.jceHandler.formDESKey((short)128, mk);
    }

    private String calculatePVV(EncryptedPIN pinUnderLmk, Key key, int keyIdx, List<String> excludes) throws SMException {
        String pin = this.decryptPINImpl(pinUnderLmk);
        if (excludes != null && excludes.contains(pin)) {
            throw new WeakPINException("Given PIN is on excludes list");
        }
        String block = pinUnderLmk.getAccountNumber().substring(1);
        block = block + Integer.toString(keyIdx % 10);
        block = block + pin.substring(0, 4);
        byte[] b = ISOUtil.hex2byte(block);
        b = this.jceHandler.encryptData(b, key);
        return JCESecurityModule.decimalizeVisa(b).substring(0, 4);
    }

    @Override
    protected String calculatePVVImpl(EncryptedPIN pinUnderLmk, SecureDESKey pvkA, SecureDESKey pvkB, int pvkIdx, List<String> excludes) throws SMException {
        Key key = this.concatKeys(pvkA, pvkB);
        return this.calculatePVV(pinUnderLmk, key, pvkIdx, excludes);
    }

    @Override
    public boolean verifyPVVImpl(EncryptedPIN pinUnderKd1, SecureDESKey kd1, SecureDESKey pvkA, SecureDESKey pvkB, int pvki, String pvv) throws SMException {
        Key key = this.concatKeys(pvkA, pvkB);
        EncryptedPIN pinUnderLmk = this.importPINImpl(pinUnderKd1, kd1);
        String result = this.calculatePVV(pinUnderLmk, key, pvki, null);
        return result.equals(pvv);
    }

    @Override
    public EncryptedPIN translatePINImpl(EncryptedPIN pinUnderKd1, SecureDESKey kd1, SecureDESKey kd2, byte destinationPINBlockFormat) throws SMException {
        Key clearKd1 = this.decryptFromLMK(kd1);
        Key clearKd2 = this.decryptFromLMK(kd2);
        EncryptedPIN translatedPIN = this.translatePINExt(null, pinUnderKd1, clearKd1, clearKd2, destinationPINBlockFormat, null, PaddingMethod.MCHIP);
        return translatedPIN;
    }

    private EncryptedPIN translatePINExt(EncryptedPIN oldPinUnderKd1, EncryptedPIN pinUnderKd1, Key kd1, Key kd2, byte destinationPINBlockFormat, Key udk, PaddingMethod padm) throws SMException {
        EncryptedPIN translatedPIN = null;
        String accountNumber = pinUnderKd1.getAccountNumber();
        byte[] clearPINBlock = this.jceHandler.decryptData(pinUnderKd1.getPINBlock(), kd1);
        String pin = this.calculatePIN(clearPINBlock, pinUnderKd1.getPINBlockFormat(), accountNumber);
        byte[] translatedPINBlock = null;
        if (this.isVSDCPinBlockFormat(destinationPINBlockFormat)) {
            String udka = ISOUtil.hexString(Arrays.copyOfRange(udk.getEncoded(), 0, 8));
            if (destinationPINBlockFormat == 42) {
                byte[] oldClearPINBlock = this.jceHandler.decryptData(oldPinUnderKd1.getPINBlock(), kd1);
                String oldPIN = this.calculatePIN(oldClearPINBlock, oldPinUnderKd1.getPINBlockFormat(), accountNumber);
                clearPINBlock = this.calculatePINBlock(pin + ":" + oldPIN, destinationPINBlockFormat, udka);
            } else {
                clearPINBlock = this.calculatePINBlock(pin, destinationPINBlockFormat, udka);
            }
            accountNumber = udka.substring(4);
        } else {
            clearPINBlock = this.calculatePINBlock(pin, destinationPINBlockFormat, accountNumber);
        }
        switch (padm) {
            case VSDC: {
                clearPINBlock = ISOUtil.concat(new byte[]{8}, clearPINBlock);
                clearPINBlock = this.paddingISO9797Method2(clearPINBlock);
                break;
            }
            case CCD: {
                clearPINBlock = this.paddingISO9797Method2(clearPINBlock);
                break;
            }
        }
        translatedPINBlock = padm == PaddingMethod.CCD ? this.jceHandler.encryptDataCBC(clearPINBlock, kd2, zeroBlock) : this.jceHandler.encryptData(clearPINBlock, kd2);
        translatedPIN = new EncryptedPIN(translatedPINBlock, destinationPINBlockFormat, accountNumber, false);
        return translatedPIN;
    }

    private Key deriveSK_VISA(Key mkac, byte[] atc) throws JCEHandlerException {
        byte[] skl = new byte[8];
        System.arraycopy(atc, atc.length - 2, skl, 6, 2);
        skl = ISOUtil.xor(skl, Arrays.copyOfRange(mkac.getEncoded(), 0, 8));
        byte[] skr = new byte[8];
        System.arraycopy(atc, atc.length - 2, skr, 6, 2);
        skr = ISOUtil.xor(skr, ISOUtil.hex2byte("000000000000FFFF"));
        skr = ISOUtil.xor(skr, Arrays.copyOfRange(mkac.getEncoded(), 8, 16));
        Util.adjustDESParity(skl);
        Util.adjustDESParity(skr);
        return this.jceHandler.formDESKey((short)128, ISOUtil.concat(skl, skr));
    }

    private Key deriveCommonSK_SM(Key mksm, byte[] rand) throws JCEHandlerException {
        byte[] rl = Arrays.copyOf(rand, 8);
        rl[2] = -16;
        byte[] skl = this.jceHandler.encryptData(rl, mksm);
        byte[] rr = Arrays.copyOf(rand, 8);
        rr[2] = 15;
        byte[] skr = this.jceHandler.encryptData(rr, mksm);
        Util.adjustDESParity(skl);
        Util.adjustDESParity(skr);
        return this.jceHandler.formDESKey((short)128, ISOUtil.concat(skl, skr));
    }

    @Override
    protected byte[] generateSM_MACImpl(MKDMethod mkdm, SKDMethod skdm, SecureDESKey imksmi, String accountNo, String accntSeqNo, byte[] atc, byte[] arqc, byte[] data) throws SMException {
        Key smi;
        if (mkdm == null) {
            mkdm = MKDMethod.OPTION_A;
        }
        byte[] panpsn = JCESecurityModule.formatPANPSN(accountNo, accntSeqNo, mkdm);
        Key mksmi = this.deriveICCMasterKey(this.decryptFromLMK(imksmi), panpsn);
        switch (skdm) {
            case VSDC: {
                smi = this.deriveSK_VISA(mksmi, atc);
                data = this.paddingISO9797Method2(data);
                break;
            }
            case MCHIP: 
            case EMV_CSKD: {
                smi = this.deriveCommonSK_SM(mksmi, arqc);
                data = this.paddingISO9797Method2(data);
                break;
            }
            default: {
                throw new SMException("Session Key Derivation " + (Object)((Object)skdm) + " not supported");
            }
        }
        return this.calculateMACISO9797Alg3(smi, data);
    }

    @Override
    protected Pair<EncryptedPIN, byte[]> translatePINGenerateSM_MACImpl(MKDMethod mkdm, SKDMethod skdm, PaddingMethod padm, SecureDESKey imksmi, String accountNo, String accntSeqNo, byte[] atc, byte[] arqc, byte[] data, EncryptedPIN currentPIN, EncryptedPIN newPIN, SecureDESKey kd1, SecureDESKey imksmc, SecureDESKey imkac, byte destinationPINBlockFormat) throws SMException {
        PaddingMethod derivedPADM;
        Key smc;
        if (mkdm == null) {
            mkdm = MKDMethod.OPTION_A;
        }
        byte[] panpsn = JCESecurityModule.formatPANPSN(accountNo, accntSeqNo, mkdm);
        Key mksmc = this.deriveICCMasterKey(this.decryptFromLMK(imksmc), panpsn);
        switch (skdm) {
            case VSDC: {
                smc = this.deriveSK_VISA(mksmc, atc);
                derivedPADM = PaddingMethod.VSDC;
                break;
            }
            case MCHIP: {
                smc = this.deriveCommonSK_SM(mksmc, arqc);
                derivedPADM = PaddingMethod.MCHIP;
                break;
            }
            case EMV_CSKD: {
                smc = this.deriveCommonSK_SM(mksmc, arqc);
                derivedPADM = PaddingMethod.CCD;
                break;
            }
            default: {
                throw new SMException("Session Key Derivation " + (Object)((Object)skdm) + " not supported");
            }
        }
        if (padm == null) {
            padm = derivedPADM;
        }
        Key udk = null;
        if (this.isVSDCPinBlockFormat(destinationPINBlockFormat)) {
            udk = this.deriveICCMasterKey(this.decryptFromLMK(imkac), panpsn);
        }
        EncryptedPIN pin = this.translatePINExt(currentPIN, newPIN, this.decryptFromLMK(kd1), smc, destinationPINBlockFormat, udk, padm);
        data = ISOUtil.concat(data, pin.getPINBlock());
        byte[] mac = this.generateSM_MACImpl(mkdm, skdm, imksmi, accountNo, accntSeqNo, atc, arqc, data);
        return new Pair((Object)pin, (Object)mac);
    }

    private boolean isVSDCPinBlockFormat(byte pinBlockFormat) {
        return pinBlockFormat == 41 || pinBlockFormat == 42;
    }

    @Override
    protected byte[] generateCBC_MACImpl(byte[] data, SecureDESKey kd) throws SMException {
        LogEvent evt = new LogEvent(this, "jce-provider-cbc-mac");
        try {
            return this.generateMACImpl(data, kd, this.cfg.get("cbc-mac", "ISO9797ALG3MACWITHISO7816-4PADDING"), evt);
        }
        catch (Exception e) {
            Logger.log(evt);
            throw e instanceof SMException ? (SMException)e : new SMException(e);
        }
    }

    @Override
    protected byte[] generateEDE_MACImpl(byte[] data, SecureDESKey kd) throws SMException {
        LogEvent evt = new LogEvent(this, "jce-provider-ede-mac");
        try {
            return this.generateMACImpl(data, kd, this.cfg.get("ede-mac", "DESEDEMAC"), evt);
        }
        catch (Exception e) {
            Logger.log(evt);
            throw e instanceof SMException ? (SMException)e : new SMException(e);
        }
    }

    private byte[] generateMACImpl(byte[] data, SecureDESKey kd, String macAlgorithm, LogEvent evt) throws SMException {
        try {
            return this.jceHandler.generateMAC(data, this.decryptFromLMK(kd), macAlgorithm);
        }
        catch (JCEHandlerException e) {
            evt.addMessage(e);
            if (e.getCause() instanceof InvalidKeyException) {
                throw new SMException(e);
            }
            throw new SMException("Unable to load MAC algorithm whose name is: " + macAlgorithm + ". Check that is used correct JCE provider and/or it is proper configured for this module.", e);
        }
    }

    String generateClearKeyComponent(short keyLength) throws SMException {
        String clearKeyComponenetHexString;
        SimpleMsg[] cmdParameters = new SimpleMsg[]{new SimpleMsg("parameter", "Key Length", keyLength)};
        LogEvent evt = new LogEvent(this, "s-m-operation");
        evt.addMessage(new SimpleMsg("command", "Generate Clear Key Component", cmdParameters));
        try {
            Key clearKey = this.jceHandler.generateDESKey(keyLength);
            byte[] clearKeyData = this.jceHandler.extractDESKeyMaterial(keyLength, clearKey);
            clearKeyComponenetHexString = ISOUtil.hexString(clearKeyData);
            evt.addMessage(new SimpleMsg("result", "Generated Clear Key Componenet", clearKeyComponenetHexString));
        }
        catch (JCEHandlerException e) {
            evt.addMessage(e);
            throw e;
        }
        finally {
            Logger.log(evt);
        }
        return clearKeyComponenetHexString;
    }

    @Override
    protected byte[] generateKeyCheckValueImpl(SecureDESKey secureDESKey) throws SMException {
        return this.calculateKeyCheckValue(this.decryptFromLMK(secureDESKey));
    }

    SecureDESKey formKEYfromThreeClearComponents(short keyLength, String keyType, String clearComponent1HexString, String clearComponent2HexString, String clearComponent3HexString) throws SMException {
        SecureDESKey secureDESKey;
        LogEvent evt = new LogEvent(this, "s-m-operation");
        try {
            byte[] clearComponent1 = ISOUtil.hex2byte(clearComponent1HexString);
            byte[] clearComponent2 = ISOUtil.hex2byte(clearComponent2HexString);
            byte[] clearComponent3 = ISOUtil.hex2byte(clearComponent3HexString);
            byte[] clearKeyBytes = ISOUtil.xor(ISOUtil.xor(clearComponent1, clearComponent2), clearComponent3);
            Key clearKey = null;
            clearKey = this.jceHandler.formDESKey(keyLength, clearKeyBytes);
            secureDESKey = this.encryptToLMK(keyLength, keyType, clearKey);
            SimpleMsg[] cmdParameters = new SimpleMsg[]{new SimpleMsg("parameter", "Key Length", keyLength), new SimpleMsg("parameter", "Key Type", keyType), new SimpleMsg("parameter", "Component 1 Check Value", this.calculateKeyCheckValue(this.jceHandler.formDESKey(keyLength, clearComponent1))), new SimpleMsg("parameter", "Component 2 Check Value", this.calculateKeyCheckValue(this.jceHandler.formDESKey(keyLength, clearComponent2))), new SimpleMsg("parameter", "Component 3 Check Value", this.calculateKeyCheckValue(this.jceHandler.formDESKey(keyLength, clearComponent3)))};
            evt.addMessage(new SimpleMsg("command", "Form Key from Three Clear Components", cmdParameters));
            evt.addMessage(new SimpleMsg("result", "Formed Key", secureDESKey));
        }
        catch (JCEHandlerException e) {
            evt.addMessage(e);
            throw e;
        }
        finally {
            Logger.log(evt);
        }
        return secureDESKey;
    }

    byte[] calculateKeyCheckValue(Key key) throws SMException {
        byte[] encryptedZeroBlock = this.jceHandler.encryptData(zeroBlock, key);
        return ISOUtil.trim(encryptedZeroBlock, 3);
    }

    private SecureDESKey encryptToLMK(short keyLength, String keyType, Key clearDESKey) throws SMException {
        byte[] clearKeyBytes = this.jceHandler.extractDESKeyMaterial(keyLength, clearDESKey);
        byte[] bl = new byte[8];
        byte[] bm = new byte[8];
        byte[] br = new byte[8];
        byte[] encrypted = null;
        Util.adjustDESParity(clearKeyBytes);
        int lmkIndex = this.getKeyTypeIndex(keyLength, keyType);
        switch (JCESecurityModule.getScheme(keyLength, keyType)) {
            case Z: 
            case X: 
            case Y: {
                SecretKey novar = this.getLMK(lmkIndex);
                encrypted = this.jceHandler.encryptData(clearKeyBytes, novar);
                break;
            }
            case U: {
                SecretKey left = this.getLMK(0x1000 | lmkIndex & 0xFFF);
                SecretKey right = this.getLMK(0x2000 | lmkIndex & 0xFFF);
                System.arraycopy(clearKeyBytes, 0, bl, 0, bl.length);
                System.arraycopy(clearKeyBytes, bl.length, br, 0, br.length);
                bl = this.jceHandler.encryptData(bl, left);
                br = this.jceHandler.encryptData(br, right);
                encrypted = ISOUtil.concat(bl, br);
                break;
            }
            case T: {
                SecretKey left = this.getLMK(0x3000 | lmkIndex & 0xFFF);
                SecretKey medium = this.getLMK(0x4000 | lmkIndex & 0xFFF);
                SecretKey right = this.getLMK(0x5000 | lmkIndex & 0xFFF);
                System.arraycopy(clearKeyBytes, 0, bl, 0, bl.length);
                System.arraycopy(clearKeyBytes, bl.length, bm, 0, bm.length);
                System.arraycopy(clearKeyBytes, bl.length + bm.length, br, 0, br.length);
                bl = this.jceHandler.encryptData(bl, left);
                bm = this.jceHandler.encryptData(bm, medium);
                br = this.jceHandler.encryptData(br, right);
                encrypted = ISOUtil.concat(bl, bm);
                encrypted = ISOUtil.concat(encrypted, br);
            }
        }
        SecureDESKey secureDESKey = new SecureDESKey(keyLength, keyType, encrypted, this.calculateKeyCheckValue(clearDESKey));
        return secureDESKey;
    }

    private Key decryptFromLMK(SecureDESKey secureDESKey) throws SMException {
        Key key = null;
        byte[] keyBytes = secureDESKey.getKeyBytes();
        byte[] bl = new byte[8];
        byte[] bm = new byte[8];
        byte[] br = new byte[8];
        byte[] clearKeyBytes = null;
        Integer lmkIndex = this.getKeyTypeIndex(secureDESKey.getKeyLength(), secureDESKey.getKeyType());
        if (lmkIndex == null) {
            throw new SMException("Unsupported key type: " + secureDESKey.getKeyType());
        }
        lmkIndex = lmkIndex | secureDESKey.getVariant() << 8;
        switch (secureDESKey.getScheme()) {
            case Z: 
            case X: 
            case Y: {
                clearKeyBytes = this.jceHandler.decryptData(keyBytes, this.getLMK(lmkIndex));
                break;
            }
            case U: {
                SecretKey left = this.getLMK(0x1000 | lmkIndex & 0xFFF);
                SecretKey right = this.getLMK(0x2000 | lmkIndex & 0xFFF);
                System.arraycopy(keyBytes, 0, bl, 0, bl.length);
                System.arraycopy(keyBytes, bl.length, br, 0, br.length);
                bl = this.jceHandler.decryptData(bl, left);
                br = this.jceHandler.decryptData(br, right);
                clearKeyBytes = ISOUtil.concat(bl, br);
                clearKeyBytes = ISOUtil.concat(clearKeyBytes, 0, clearKeyBytes.length, clearKeyBytes, 0, br.length);
                break;
            }
            case T: {
                SecretKey left = this.getLMK(0x3000 | lmkIndex & 0xFFF);
                SecretKey medium = this.getLMK(0x4000 | lmkIndex & 0xFFF);
                SecretKey right = this.getLMK(0x5000 | lmkIndex & 0xFFF);
                System.arraycopy(keyBytes, 0, bl, 0, bl.length);
                System.arraycopy(keyBytes, bl.length, bm, 0, bm.length);
                System.arraycopy(keyBytes, bl.length + bm.length, br, 0, br.length);
                bl = this.jceHandler.decryptData(bl, left);
                bm = this.jceHandler.decryptData(bm, medium);
                br = this.jceHandler.decryptData(br, right);
                clearKeyBytes = ISOUtil.concat(bl, bm);
                clearKeyBytes = ISOUtil.concat(clearKeyBytes, br);
            }
        }
        if (!Util.isDESParityAdjusted(clearKeyBytes)) {
            throw new JCEHandlerException("Parity not adjusted");
        }
        key = this.jceHandler.formDESKey(secureDESKey.getKeyLength(), clearKeyBytes);
        return key;
    }

    private char[] formatPINBlock(String pin, int checkDigit) {
        char[] block = ISOUtil.hexString(fPaddingBlock).toCharArray();
        char[] pinLenHex = String.format("%02X", pin.length()).toCharArray();
        pinLenHex[0] = (char)(48 + checkDigit);
        System.arraycopy(pinLenHex, 0, block, 0, pinLenHex.length);
        System.arraycopy(pin.toCharArray(), 0, block, pinLenHex.length, pin.length());
        return block;
    }

    private String[] splitPins(String pins) {
        String[] pin = new String[2];
        StringTokenizer st = new StringTokenizer(pins, " :;,.");
        pin[0] = st.nextToken();
        if (st.hasMoreTokens()) {
            pin[1] = st.nextToken();
        }
        return pin;
    }

    private byte[] calculatePINBlock(String pin, byte pinBlockFormat, String accountNumber) throws SMException {
        byte[] pinBlock = null;
        String oldPin = null;
        if (pinBlockFormat == 42) {
            String[] p = this.splitPins(pin);
            pin = p[0];
            oldPin = p[1];
            if (oldPin.length() < 4 || oldPin.length() > 12) {
                throw new SMException("Invalid OLD PIN length: " + oldPin.length());
            }
            if (!ISOUtil.isNumeric(oldPin, 10)) {
                throw new SMException("Invalid OLD PIN decimal digits: " + oldPin);
            }
        }
        if (pin.length() < 4 || pin.length() > 12) {
            throw new SMException("Invalid PIN length: " + pin.length());
        }
        if (!ISOUtil.isNumeric(pin, 10)) {
            throw new SMException("Invalid PIN decimal digits: " + pin);
        }
        if (this.isVSDCPinBlockFormat(pinBlockFormat)) {
            if (accountNumber.length() != 16) {
                throw new SMException("Invalid UDK-A: " + accountNumber + ". The length of the UDK-A must be 16 hexadecimal digits");
            }
        } else if (accountNumber.length() != 12) {
            throw new SMException("Invalid Account Number: " + accountNumber + ". The length of the account number must be 12 (the 12 right-most digits of the account number excluding the check digit)");
        }
        switch (pinBlockFormat) {
            case 0: 
            case 1: {
                byte[] block1 = ISOUtil.hex2byte(new String(this.formatPINBlock(pin, 0)));
                byte[] block2 = ISOUtil.hex2byte("0000" + accountNumber);
                pinBlock = ISOUtil.xor(block1, block2);
                break;
            }
            case 3: {
                char[] block = ISOUtil.hexString(fPaddingBlock).toCharArray();
                System.arraycopy(pin.toCharArray(), 0, block, 0, pin.length());
                pinBlock = ISOUtil.hex2byte(new String(block));
                break;
            }
            case 34: {
                pinBlock = ISOUtil.hex2byte(new String(this.formatPINBlock(pin, 2)));
                break;
            }
            case 35: {
                byte[] block1 = ISOUtil.hex2byte(new String(this.formatPINBlock(pin, 2)));
                byte[] block2 = ISOUtil.hex2byte("0000" + accountNumber);
                pinBlock = ISOUtil.xor(block1, block2);
                break;
            }
            case 41: {
                byte[] block1 = ISOUtil.hex2byte(new String(this.formatPINBlock(pin, 0)));
                byte[] block2 = ISOUtil.hex2byte("00000000" + accountNumber.substring(accountNumber.length() - 8));
                pinBlock = ISOUtil.xor(block1, block2);
                break;
            }
            case 42: {
                byte[] block1 = ISOUtil.hex2byte(new String(this.formatPINBlock(pin, 0)));
                byte[] block2 = ISOUtil.hex2byte("00000000" + accountNumber.substring(accountNumber.length() - 8));
                byte[] block3 = ISOUtil.hex2byte(ISOUtil.zeropadRight(oldPin, 16));
                pinBlock = ISOUtil.xor(block1, block2);
                pinBlock = ISOUtil.xor(pinBlock, block3);
                break;
            }
            default: {
                throw new SMException("Unsupported PIN format: " + pinBlockFormat);
            }
        }
        return pinBlock;
    }

    private void validatePinBlock(char[] pblock, int checkDigit, int padidx, int offset) throws SMException {
        this.validatePinBlock(pblock, checkDigit, padidx, offset, 'F');
    }

    private void validatePinBlock(char[] pblock, int checkDigit, int padidx, int offset, char padDigit) throws SMException {
        if (checkDigit >= 0 && pblock[0] - 48 != checkDigit) {
            throw new SMException("PIN Block Error - invalid check digit");
        }
        int i = pblock.length - 1;
        while (i >= padidx) {
            if (pblock[i--] == padDigit) continue;
            throw new SMException("PIN Block Error - invalid padding");
        }
        while (i >= offset) {
            if (pblock[i--] < 'A') continue;
            throw new SMException("PIN Block Error - illegal pin digit");
        }
        int pinLength = padidx - offset;
        if (pinLength < 4 || pinLength > 12) {
            throw new SMException("PIN Block Error - invalid pin length: " + pinLength);
        }
    }

    private String calculatePIN(byte[] pinBlock, byte pinBlockFormat, String accountNumber) throws SMException {
        String pin = null;
        if (this.isVSDCPinBlockFormat(pinBlockFormat)) {
            if (accountNumber.length() != 16) {
                throw new SMException("Invalid UDK-A: " + accountNumber + ". The length of the UDK-A must be 16 hexadecimal digits");
            }
        } else if (accountNumber.length() != 12) {
            throw new SMException("Invalid Account Number: " + accountNumber + ". The length of the account number must be 12 (the 12 right-most digits of the account number excluding the check digit)");
        }
        switch (pinBlockFormat) {
            case 0: 
            case 1: {
                byte[] bl2 = ISOUtil.hex2byte("0000" + accountNumber);
                byte[] bl1 = ISOUtil.xor(pinBlock, bl2);
                int pinLength = bl1[0] & 0xF;
                char[] block1 = ISOUtil.hexString(bl1).toCharArray();
                int offset = 2;
                int checkDigit = 0;
                int padidx = pinLength + offset;
                this.validatePinBlock(block1, checkDigit, padidx, offset);
                pin = new String(Arrays.copyOfRange(block1, offset, padidx));
                break;
            }
            case 3: {
                String bl1 = ISOUtil.hexString(pinBlock);
                int padidx = bl1.indexOf(70);
                if (padidx < 0) {
                    padidx = 12;
                }
                char[] block1 = bl1.toCharArray();
                int checkDigit = -1;
                int offset = 0;
                this.validatePinBlock(block1, checkDigit, padidx, offset);
                pin = new String(Arrays.copyOfRange(block1, offset, padidx));
                break;
            }
            case 34: {
                int pinLength = pinBlock[0] & 0xF;
                char[] block1 = ISOUtil.hexString(pinBlock).toCharArray();
                int offset = 2;
                int checkDigit = 2;
                int padidx = pinLength + offset;
                this.validatePinBlock(block1, checkDigit, padidx, offset);
                pin = new String(Arrays.copyOfRange(block1, offset, padidx));
                break;
            }
            case 35: {
                byte[] bl2 = ISOUtil.hex2byte("0000" + accountNumber);
                byte[] bl1 = ISOUtil.xor(pinBlock, bl2);
                int pinLength = bl1[0] & 0xF;
                char[] block1 = ISOUtil.hexString(bl1).toCharArray();
                int offset = 2;
                int checkDigit = 2;
                int padidx = pinLength + offset;
                this.validatePinBlock(block1, checkDigit, padidx, offset);
                pin = new String(Arrays.copyOfRange(block1, offset, padidx));
                break;
            }
            case 41: {
                byte[] bl2 = ISOUtil.hex2byte("00000000" + accountNumber.substring(accountNumber.length() - 8));
                byte[] bl1 = ISOUtil.xor(pinBlock, bl2);
                int pinLength = bl1[0] & 0xF;
                char[] block1 = ISOUtil.hexString(bl1).toCharArray();
                int offset = 2;
                int checkDigit = 0;
                int padidx = pinLength + offset;
                this.validatePinBlock(block1, checkDigit, padidx, offset);
                pin = new String(Arrays.copyOfRange(block1, offset, padidx));
                break;
            }
            case 42: {
                byte[] bl2 = ISOUtil.hex2byte("00000000" + accountNumber.substring(accountNumber.length() - 8));
                byte[] bl1 = ISOUtil.xor(pinBlock, bl2);
                int pinLength = bl1[0] & 0xF;
                char[] block1 = ISOUtil.hexString(bl1).toCharArray();
                int offset = 2;
                int checkDigit = 0;
                int padidx = pinLength + offset;
                this.validatePinBlock(block1, checkDigit, padidx, offset, '0');
                pin = new String(Arrays.copyOfRange(block1, offset, padidx));
                break;
            }
            default: {
                throw new SMException("Unsupported PIN Block format: " + pinBlockFormat);
            }
        }
        return pin;
    }

    private void init(String jceProviderClassName, String lmkFile, boolean lmkRebuild) throws SMException {
        File lmk = new File(lmkFile);
        try {
            this.keyTypeToLMKIndex = new TreeMap<String, Integer>();
            this.keyTypeToLMKIndex.put("ZMK", 0);
            this.keyTypeToLMKIndex.put("ZPK", 1);
            this.keyTypeToLMKIndex.put("PVK", 2);
            this.keyTypeToLMKIndex.put("TPK", 2);
            this.keyTypeToLMKIndex.put("TMK", 2);
            this.keyTypeToLMKIndex.put("TAK", 3);
            this.keyTypeToLMKIndex.put("CVK", 1026);
            this.keyTypeToLMKIndex.put("ZAK", 8);
            this.keyTypeToLMKIndex.put("BDK", 9);
            this.keyTypeToLMKIndex.put("MK-AC", 265);
            this.keyTypeToLMKIndex.put("MK-SMI", 521);
            this.keyTypeToLMKIndex.put("MK-SMC", 777);
            this.keyTypeToLMKIndex.put("MK-CVC3", 1801);
            Provider provider = null;
            LogEvent evt = new LogEvent(this, "jce-provider");
            try {
                if (jceProviderClassName == null || jceProviderClassName.compareTo("") == 0) {
                    evt.addMessage("No JCE Provider specified. Attempting to load default provider (SunJCE).");
                    jceProviderClassName = "com.sun.crypto.provider.SunJCE";
                }
                provider = (Provider)Class.forName(jceProviderClassName).newInstance();
                Security.addProvider(provider);
                evt.addMessage("name", provider.getName());
            }
            catch (Exception e) {
                evt.addMessage(e);
                throw new SMException("Unable to load jce provider whose class name is: " + jceProviderClassName);
            }
            finally {
                Logger.log(evt);
            }
            this.jceHandler = new JCEHandler(provider);
            if (lmkRebuild) {
                evt = new LogEvent(this, "local-master-keys");
                evt.addMessage("Rebuilding new Local Master Keys in file: \"" + lmk.getCanonicalPath() + "\".");
                Logger.log(evt);
                this.generateLMK();
                this.writeLMK(lmk);
                evt = new LogEvent(this, "local-master-keys");
                evt.addMessage("Local Master Keys built successfully in file: \"" + lmk.getCanonicalPath() + "\".");
                Logger.log(evt);
            }
            if (!lmk.exists()) {
                throw new SMException("Error loading Local Master Keys, file: \"" + lmk.getCanonicalPath() + "\" does not exist." + " Please specify a valid LMK file, or rebuild a new one.");
            }
            this.readLMK(lmk);
            evt = new LogEvent(this, "local-master-keys");
            evt.addMessage("Loaded successfully from file: \"" + lmk.getCanonicalPath() + "\"");
            Logger.log(evt);
        }
        catch (Exception e) {
            if (e instanceof SMException) {
                throw (SMException)e;
            }
            throw new SMException(e);
        }
    }

    private byte[] applySchemeVariant(byte[] lmkdata, int variant) {
        byte[] vardata = new byte[lmkdata.length];
        System.arraycopy(lmkdata, 0, vardata, 0, lmkdata.length);
        vardata[8] = (byte)(vardata[8] ^ variant);
        return vardata;
    }

    private byte[] applyVariant(byte[] lmkdata, int variant) {
        byte[] vardata = new byte[lmkdata.length];
        System.arraycopy(lmkdata, 0, vardata, 0, lmkdata.length);
        vardata[0] = (byte)(vardata[0] ^ variant);
        return vardata;
    }

    private void spreadLMKVariants(byte[] lmkData, int idx) throws SMException {
        int i = 0;
        for (int v : variants) {
            int k = 0;
            byte[] variantData = this.applyVariant(lmkData, v);
            for (int sv : schemeVariants) {
                byte[] svData = this.applySchemeVariant(variantData, sv);
                svData = ISOUtil.concat(svData, 0, this.jceHandler.getBytesLength((short)128), svData, 0, this.jceHandler.getBytesLength((short)64));
                int key = idx;
                key += 256 * i;
                this.lmks.put(key += 4096 * k++, (SecretKey)this.jceHandler.formDESKey((short)128, svData));
            }
            ++i;
        }
    }

    private void generateLMK() throws SMException {
        this.lmks.clear();
        try {
            for (int i = 0; i <= 14; ++i) {
                SecretKey lmkKey = (SecretKey)this.jceHandler.generateDESKey((short)128);
                this.spreadLMKVariants(lmkKey.getEncoded(), i);
            }
        }
        catch (JCEHandlerException e) {
            throw new SMException("Can't generate Local Master Keys", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readLMK(File lmkFile) throws SMException {
        this.lmks.clear();
        try {
            Properties lmkProps = new Properties();
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(lmkFile));
            try {
                lmkProps.load(in);
            }
            finally {
                ((InputStream)in).close();
            }
            for (int i = 0; i <= 14; ++i) {
                byte[] lmkData = ISOUtil.hex2byte(lmkProps.getProperty(String.format("LMK0x%1$02x", i)).substring(0, 32));
                this.spreadLMKVariants(lmkData, i);
            }
        }
        catch (Exception e) {
            throw new SMException("Can't read Local Master Keys from file: " + lmkFile, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeLMK(File lmkFile) throws SMException {
        Properties lmkProps = new Properties();
        try {
            for (int i = 0; i <= 14; ++i) {
                lmkProps.setProperty(String.format("LMK0x%1$02x", i), ISOUtil.hexString(this.lmks.get(i).getEncoded()));
            }
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(lmkFile));
            try {
                lmkProps.store(out, "Local Master Keys");
            }
            finally {
                ((OutputStream)out).close();
            }
        }
        catch (Exception e) {
            throw new SMException("Can't write Local Master Keys to file: " + lmkFile, e);
        }
    }

    private SecretKey getLMK(Integer lmkIndex) throws SMException {
        SecretKey lmk = this.lmks.get(lmkIndex);
        if (lmk == null) {
            throw new SMException(String.format("Invalid key code: LMK0x%1$04x", lmkIndex));
        }
        return lmk;
    }

    static {
        try {
            SHA1_MESSAGE_DIGEST = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        PINLMKIndex = 4;
        fPaddingBlock = ISOUtil.hex2byte("FFFFFFFFFFFFFFFF");
        zeroBlock = ISOUtil.hex2byte("0000000000000000");
    }
}

