/*
 * Decompiled with CFR 0.152.
 */
package org.jpos.security.jceadapter;

import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.Mac;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.jpos.iso.ISOUtil;
import org.jpos.security.Util;
import org.jpos.security.jceadapter.JCEHandlerException;

public class JCEHandler {
    static final String ALG_DES = "DES";
    static final String ALG_TRIPLE_DES = "DESede";
    static final String DES_MODE_ECB = "ECB";
    static final String DES_MODE_CBC = "CBC";
    static final String DES_NO_PADDING = "NoPadding";
    static final Map<MacEngineKey, Mac> macEngines = new HashMap<MacEngineKey, Mac>();
    Provider provider = null;

    public JCEHandler(String jceProviderClassName) throws JCEHandlerException {
        try {
            this.provider = (Provider)Class.forName(jceProviderClassName).newInstance();
            Security.addProvider(this.provider);
        }
        catch (Exception e) {
            throw new JCEHandlerException(e);
        }
    }

    public JCEHandler(Provider provider) {
        this.provider = provider;
    }

    public Key generateDESKey(short keyLength) throws JCEHandlerException {
        Key generatedClearKey = null;
        try {
            KeyGenerator k1 = null;
            k1 = keyLength > 64 ? KeyGenerator.getInstance(ALG_TRIPLE_DES, this.provider.getName()) : KeyGenerator.getInstance(ALG_DES, this.provider.getName());
            generatedClearKey = k1.generateKey();
            byte[] clearKeyBytes = this.extractDESKeyMaterial(keyLength, generatedClearKey);
            Util.adjustDESParity(clearKeyBytes);
            generatedClearKey = this.formDESKey(keyLength, clearKeyBytes);
        }
        catch (Exception e) {
            if (e instanceof JCEHandlerException) {
                throw (JCEHandlerException)e;
            }
            throw new JCEHandlerException(e);
        }
        return generatedClearKey;
    }

    public byte[] encryptDESKey(short keyLength, Key clearDESKey, Key encryptingKey) throws JCEHandlerException {
        byte[] encryptedDESKey = null;
        byte[] clearKeyBytes = this.extractDESKeyMaterial(keyLength, clearDESKey);
        Util.adjustDESParity(clearKeyBytes);
        encryptedDESKey = this.doCryptStuff(clearKeyBytes, encryptingKey, 1);
        return encryptedDESKey;
    }

    protected byte[] extractDESKeyMaterial(short keyLength, Key clearDESKey) throws JCEHandlerException {
        byte[] clearKeyBytes = null;
        String keyAlg = clearDESKey.getAlgorithm();
        String keyFormat = clearDESKey.getFormat();
        if (keyFormat.compareTo("RAW") != 0) {
            throw new JCEHandlerException("Unsupported DES key encoding format: " + keyFormat);
        }
        if (!keyAlg.startsWith(ALG_DES)) {
            throw new JCEHandlerException("Unsupported key algorithm: " + keyAlg);
        }
        clearKeyBytes = clearDESKey.getEncoded();
        clearKeyBytes = ISOUtil.trim(clearKeyBytes, this.getBytesLength(keyLength));
        return clearKeyBytes;
    }

    public Key decryptDESKey(short keyLength, byte[] encryptedDESKey, Key encryptingKey, boolean checkParity) throws JCEHandlerException {
        Key key = null;
        byte[] clearKeyBytes = this.doCryptStuff(encryptedDESKey, encryptingKey, 2);
        if (checkParity && !Util.isDESParityAdjusted(clearKeyBytes)) {
            throw new JCEHandlerException("Parity not adjusted");
        }
        key = this.formDESKey(keyLength, clearKeyBytes);
        return key;
    }

    protected Key formDESKey(short keyLength, byte[] clearKeyBytes) throws JCEHandlerException {
        SecretKeySpec key = null;
        switch (keyLength) {
            case 64: {
                key = new SecretKeySpec(clearKeyBytes, ALG_DES);
                break;
            }
            case 128: {
                clearKeyBytes = ISOUtil.concat(clearKeyBytes, 0, this.getBytesLength((short)128), clearKeyBytes, 0, this.getBytesLength((short)64));
            }
            case 192: {
                key = new SecretKeySpec(clearKeyBytes, ALG_TRIPLE_DES);
            }
        }
        if (key == null) {
            throw new JCEHandlerException("Unsupported DES key length: " + keyLength + " bits");
        }
        return key;
    }

    public byte[] encryptData(byte[] data, Key key) throws JCEHandlerException {
        byte[] encryptedData = this.doCryptStuff(data, key, 1);
        return encryptedData;
    }

    public byte[] decryptData(byte[] encryptedData, Key key) throws JCEHandlerException {
        byte[] clearData = this.doCryptStuff(encryptedData, key, 2);
        return clearData;
    }

    public byte[] encryptDataCBC(byte[] data, Key key, byte[] iv) throws JCEHandlerException {
        return this.doCryptStuff(data, key, 1, DES_MODE_CBC, iv);
    }

    public byte[] decryptDataCBC(byte[] encryptedData, Key key, byte[] iv) throws JCEHandlerException {
        return this.doCryptStuff(encryptedData, key, 2, DES_MODE_CBC, iv);
    }

    byte[] doCryptStuff(byte[] data, Key key, int cipherMode) throws JCEHandlerException {
        return this.doCryptStuff(data, key, cipherMode, DES_MODE_ECB, null);
    }

    byte[] doCryptStuff(byte[] data, Key key, int CipherMode, String desMode, byte[] iv) throws JCEHandlerException {
        byte[] result;
        String transformation = key.getAlgorithm().startsWith(ALG_DES) ? key.getAlgorithm() + "/" + desMode + "/" + DES_NO_PADDING : key.getAlgorithm();
        IvParameterSpec aps = null;
        try {
            Cipher c1 = Cipher.getInstance(transformation, this.provider.getName());
            if (DES_MODE_CBC.equals(desMode)) {
                aps = new IvParameterSpec(iv);
            }
            c1.init(CipherMode, key, aps);
            result = c1.doFinal(data);
        }
        catch (Exception e) {
            throw new JCEHandlerException(e);
        }
        return result;
    }

    int getBytesLength(short keyLength) throws JCEHandlerException {
        int bytesLength = 0;
        switch (keyLength) {
            case 64: {
                bytesLength = 8;
                break;
            }
            case 128: {
                bytesLength = 16;
                break;
            }
            case 192: {
                bytesLength = 24;
                break;
            }
            default: {
                throw new JCEHandlerException("Unsupported key length: " + keyLength + " bits");
            }
        }
        return bytesLength;
    }

    Mac assignMACEngine(MacEngineKey engine) throws JCEHandlerException {
        if (macEngines.containsKey(engine)) {
            return macEngines.get(engine);
        }
        Mac mac = null;
        try {
            mac = Mac.getInstance(engine.getMacAlgorithm(), this.provider);
            mac.init(engine.getMacKey());
        }
        catch (NoSuchAlgorithmException e) {
            throw new JCEHandlerException(e);
        }
        catch (InvalidKeyException e) {
            throw new JCEHandlerException(e);
        }
        macEngines.put(engine, mac);
        return mac;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] generateMAC(byte[] data, Key kd, String macAlgorithm) throws JCEHandlerException {
        Mac mac;
        Mac mac2 = mac = this.assignMACEngine(new MacEngineKey(macAlgorithm, kd));
        synchronized (mac2) {
            mac.reset();
            return mac.doFinal(data);
        }
    }

    protected static class MacEngineKey {
        private String macAlgorithm;
        private Key macKey;

        protected MacEngineKey(String macAlgorithm, Key macKey) {
            this.macAlgorithm = macAlgorithm;
            this.macKey = macKey;
        }

        public String getMacAlgorithm() {
            return this.macAlgorithm;
        }

        public Key getMacKey() {
            return this.macKey;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.macAlgorithm == null ? 0 : this.macAlgorithm.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            MacEngineKey other = (MacEngineKey)obj;
            if (this.macAlgorithm == null) {
                if (other.macAlgorithm != null) {
                    return false;
                }
            } else {
                if (!this.macAlgorithm.equals(other.macAlgorithm)) {
                    return false;
                }
                if (this.macKey != other.macKey) {
                    return false;
                }
            }
            return true;
        }
    }
}

