/*
 * Decompiled with CFR 0.152.
 */
package org.jpos.security;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import org.jpos.core.Configurable;
import org.jpos.core.Configuration;
import org.jpos.core.ConfigurationException;
import org.jpos.iso.ISOUtil;
import org.jpos.security.SecureDESKey;
import org.jpos.security.SecureKey;
import org.jpos.security.SecureKeyStore;
import org.jpos.util.LogEvent;
import org.jpos.util.LogSource;
import org.jpos.util.Logger;

public class SimpleKeyFile
implements SecureKeyStore,
Configurable,
LogSource {
    Properties props = new Properties();
    File file;
    String header = "Key File";
    protected Logger logger = null;
    protected String realm = null;

    public SimpleKeyFile() {
    }

    public SimpleKeyFile(String keyFileName) throws SecureKeyStore.SecureKeyStoreException {
        this.init(keyFileName);
    }

    public void init(String keyFileName) throws SecureKeyStore.SecureKeyStoreException {
        this.file = new File(keyFileName);
        try {
            if (!this.file.exists()) {
                this.file.createNewFile();
            }
            this.load();
        }
        catch (Exception e) {
            throw new SecureKeyStore.SecureKeyStoreException(e);
        }
    }

    @Override
    public void setLogger(Logger logger, String realm) {
        this.logger = logger;
        this.realm = realm;
    }

    @Override
    public Logger getLogger() {
        return this.logger;
    }

    @Override
    public String getRealm() {
        return this.realm;
    }

    @Override
    public void setConfiguration(Configuration cfg) throws ConfigurationException {
        try {
            this.init(cfg.get("key-file"));
            this.header = cfg.get("file-header", this.header);
        }
        catch (Exception e) {
            throw new ConfigurationException(e);
        }
    }

    @Override
    public synchronized SecureKey getKey(String alias) throws SecureKeyStore.SecureKeyStoreException {
        SecureKey secureKey = null;
        LogEvent evt = new LogEvent(this, "get-key");
        evt.addMessage("alias", alias);
        try {
            this.load();
            String keyClassName = this.getProperty(alias, "class");
            Class<?> c = Class.forName(keyClassName);
            secureKey = (SecureKey)c.newInstance();
            if (!(secureKey instanceof SecureDESKey)) {
                throw new SecureKeyStore.SecureKeyStoreException("Unsupported SecureKey class: " + secureKey.getClass().getName());
            }
            byte[] keyBytes = ISOUtil.hex2byte(this.getProperty(alias, "key"));
            short keyLength = Short.parseShort(this.getProperty(alias, "length"));
            String keyType = this.getProperty(alias, "type");
            byte[] KeyCheckValue = ISOUtil.hex2byte(this.getProperty(alias, "checkvalue"));
            secureKey = new SecureDESKey(keyLength, keyType, keyBytes, KeyCheckValue);
            evt.addMessage(secureKey);
        }
        catch (Exception e) {
            evt.addMessage(e);
            throw e instanceof SecureKeyStore.SecureKeyStoreException ? (SecureKeyStore.SecureKeyStoreException)e : new SecureKeyStore.SecureKeyStoreException(e);
        }
        finally {
            Logger.log(evt);
        }
        return secureKey;
    }

    @Override
    public synchronized void setKey(String alias, SecureKey secureKey) throws SecureKeyStore.SecureKeyStoreException {
        LogEvent evt = new LogEvent(this, "set-key");
        evt.addMessage("alias", alias);
        evt.addMessage(secureKey);
        try {
            if (!(secureKey instanceof SecureDESKey)) {
                throw new SecureKeyStore.SecureKeyStoreException("Unsupported SecureKey class: " + secureKey.getClass().getName());
            }
            this.load();
            this.setProperty(alias, "class", secureKey.getClass().getName());
            this.setProperty(alias, "key", ISOUtil.hexString(secureKey.getKeyBytes()));
            this.setProperty(alias, "length", Short.toString(secureKey.getKeyLength()));
            this.setProperty(alias, "type", secureKey.getKeyType());
            String keyCheckValueHexString = ISOUtil.hexString(((SecureDESKey)secureKey).getKeyCheckValue());
            this.setProperty(alias, "checkvalue", keyCheckValueHexString);
            this.store();
        }
        catch (Exception e) {
            evt.addMessage(e);
            throw e instanceof SecureKeyStore.SecureKeyStoreException ? (SecureKeyStore.SecureKeyStoreException)e : new SecureKeyStore.SecureKeyStoreException(e);
        }
        finally {
            Logger.log(evt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void load() throws SecureKeyStore.SecureKeyStoreException {
        try {
            if (!this.file.canRead()) {
                throw new SecureKeyStore.SecureKeyStoreException("Can't read from file: " + this.file.getCanonicalPath());
            }
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(this.file));
            try {
                this.props.load(in);
            }
            finally {
                ((InputStream)in).close();
            }
        }
        catch (Exception e) {
            throw new SecureKeyStore.SecureKeyStoreException(e);
        }
    }

    void store() throws SecureKeyStore.SecureKeyStoreException {
        try {
            if (!this.file.canWrite()) {
                throw new SecureKeyStore.SecureKeyStoreException("Can't write to file: " + this.file.getCanonicalPath());
            }
            FileOutputStream out = new FileOutputStream(this.file);
            this.props.store(out, this.header);
            out.flush();
            out.close();
        }
        catch (Exception e) {
            throw new SecureKeyStore.SecureKeyStoreException(e);
        }
    }

    public String getProperty(String alias, String subName) throws SecureKeyStore.SecureKeyStoreException {
        String key = alias + "." + subName;
        String value = this.props.getProperty(key);
        if (value == null) {
            throw new SecureKeyStore.SecureKeyStoreException("Key can't be retrieved. Can't get property: " + key);
        }
        return value.trim();
    }

    public void setProperty(String alias, String subName, String value) {
        String key = alias + "." + subName;
        this.props.setProperty(key, value);
    }

    @Override
    public Map<String, SecureKey> getKeys() throws SecureKeyStore.SecureKeyStoreException {
        Hashtable<String, SecureKey> keys = new Hashtable<String, SecureKey>();
        for (Object k : this.props.keySet()) {
            String alias = ((String)k).split("\\.")[0];
            if (keys.containsKey(alias)) continue;
            keys.put(alias, this.getKey(alias));
        }
        return keys;
    }
}

