/*
 * Decompiled with CFR 0.152.
 */
package org.jpos.security;

import java.io.PrintStream;
import java.util.StringTokenizer;
import org.jpos.iso.ISOUtil;
import org.jpos.security.KeyScheme;
import org.jpos.security.SecureKey;

public class SecureDESKey
extends SecureKey {
    private static final long serialVersionUID = -9145281998779008306L;
    protected byte[] keyCheckValue = null;
    protected Byte variant;
    protected KeyScheme scheme;

    public SecureDESKey() {
    }

    public SecureDESKey(short keyLength, String keyType, byte variant, KeyScheme scheme, byte[] keyBytes, byte[] keyCheckValue) {
        this.setKeyLength(keyLength);
        this.setKeyType(keyType);
        this.setVariant(variant);
        this.setScheme(scheme);
        this.setKeyBytes(keyBytes);
        this.setKeyCheckValue(keyCheckValue);
    }

    public SecureDESKey(short keyLength, String keyType, byte[] keyBytes, byte[] keyCheckValue) {
        this.setKeyLength(keyLength);
        this.setKeyType(keyType);
        this.setKeyBytes(keyBytes);
        this.setKeyCheckValue(keyCheckValue);
        this.getVariant();
        this.getScheme();
    }

    public SecureDESKey(short keyLength, String keyType, String keyHexString, String keyCheckValueHexString) {
        this(keyLength, keyType, ISOUtil.hex2byte(keyHexString), ISOUtil.hex2byte(keyCheckValueHexString));
    }

    public SecureDESKey(short keyLength, String keyType, byte variant, KeyScheme scheme, String keyHexString, String keyCheckValueHexString) {
        this(keyLength, keyType, variant, scheme, ISOUtil.hex2byte(keyHexString), ISOUtil.hex2byte(keyCheckValueHexString));
    }

    public void setKeyCheckValue(byte[] keyCheckValue) {
        this.keyCheckValue = keyCheckValue;
    }

    public byte[] getKeyCheckValue() {
        return this.keyCheckValue;
    }

    public void setVariant(byte variant) {
        this.variant = variant;
    }

    public byte getVariant() {
        if (this.variant != null) {
            return this.variant;
        }
        this.variant = 0;
        StringTokenizer st = new StringTokenizer(this.keyType, ":;");
        if (st.hasMoreTokens()) {
            st.nextToken();
        }
        if (st.hasMoreTokens()) {
            try {
                this.variant = Byte.valueOf(st.nextToken().substring(0, 1));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.variant;
    }

    public void setScheme(KeyScheme scheme) {
        this.scheme = scheme;
    }

    public KeyScheme getScheme() {
        if (this.scheme != null) {
            return this.scheme;
        }
        switch (this.keyLength) {
            case 64: {
                this.scheme = KeyScheme.Z;
                break;
            }
            case 128: {
                this.scheme = KeyScheme.X;
                break;
            }
            case 192: {
                this.scheme = KeyScheme.Y;
            }
        }
        StringTokenizer st = new StringTokenizer(this.keyType, ":;");
        if (st.hasMoreTokens()) {
            st.nextToken();
        }
        if (st.hasMoreTokens()) {
            try {
                this.scheme = KeyScheme.valueOf(st.nextToken().substring(1, 2));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.scheme;
    }

    @Override
    public void dump(PrintStream p, String indent) {
        String inner = indent + "  ";
        p.print(indent + "<secure-des-key");
        p.print(" length=\"" + this.getKeyLength() + "\"");
        p.print(" type=\"" + this.keyType + "\"");
        p.print(" variant=\"" + this.getVariant() + "\"");
        p.print(" scheme=\"" + (Object)((Object)this.getScheme()) + "\"");
        if (this.keyName != null) {
            p.print(" name=\"" + this.keyName + "\"");
        }
        p.println(">");
        p.println(inner + "<data>" + ISOUtil.hexString(this.getKeyBytes()) + "</data>");
        p.println(inner + "<check-value>" + ISOUtil.hexString(this.getKeyCheckValue()) + "</check-value>");
        p.println(indent + "</secure-des-key>");
    }
}

