/*
 * Decompiled with CFR 0.152.
 */
package org.jpos.security;

import java.util.Date;
import java.util.List;
import org.javatuples.Pair;
import org.jpos.security.ARPCMethod;
import org.jpos.security.EncryptedPIN;
import org.jpos.security.KeySerialNumber;
import org.jpos.security.MKDMethod;
import org.jpos.security.PaddingMethod;
import org.jpos.security.SKDMethod;
import org.jpos.security.SMException;
import org.jpos.security.SecureDESKey;

public interface SMAdapter {
    public static final short LENGTH_DES = 64;
    public static final short LENGTH_DES3_2KEY = 128;
    public static final short LENGTH_DES3_3KEY = 192;
    public static final String TYPE_ZMK = "ZMK";
    public static final String TYPE_ZPK = "ZPK";
    public static final String TYPE_TMK = "TMK";
    public static final String TYPE_TPK = "TPK";
    public static final String TYPE_TAK = "TAK";
    public static final String TYPE_PVK = "PVK";
    public static final String TYPE_CVK = "CVK";
    public static final String TYPE_BDK = "BDK";
    public static final String TYPE_ZAK = "ZAK";
    public static final String TYPE_MK_AC = "MK-AC";
    public static final String TYPE_MK_SMI = "MK-SMI";
    public static final String TYPE_MK_SMC = "MK-SMC";
    public static final String TYPE_MK_CVC3 = "MK-CVC3";
    public static final byte FORMAT01 = 1;
    public static final byte FORMAT02 = 2;
    public static final byte FORMAT03 = 3;
    public static final byte FORMAT04 = 4;
    public static final byte FORMAT05 = 5;
    public static final byte FORMAT34 = 34;
    public static final byte FORMAT35 = 35;
    public static final byte FORMAT41 = 41;
    public static final byte FORMAT42 = 42;
    public static final byte FORMAT00 = 0;

    public SecureDESKey generateKey(short var1, String var2) throws SMException;

    public byte[] generateKeyCheckValue(SecureDESKey var1) throws SMException;

    public SecureDESKey importKey(short var1, String var2, byte[] var3, SecureDESKey var4, boolean var5) throws SMException;

    public byte[] exportKey(SecureDESKey var1, SecureDESKey var2) throws SMException;

    public EncryptedPIN encryptPIN(String var1, String var2) throws SMException;

    public EncryptedPIN encryptPIN(String var1, String var2, boolean var3) throws SMException;

    public String decryptPIN(EncryptedPIN var1) throws SMException;

    public EncryptedPIN importPIN(EncryptedPIN var1, SecureDESKey var2) throws SMException;

    public EncryptedPIN translatePIN(EncryptedPIN var1, SecureDESKey var2, SecureDESKey var3, byte var4) throws SMException;

    public EncryptedPIN importPIN(EncryptedPIN var1, KeySerialNumber var2, SecureDESKey var3) throws SMException;

    public EncryptedPIN translatePIN(EncryptedPIN var1, KeySerialNumber var2, SecureDESKey var3, SecureDESKey var4, byte var5) throws SMException;

    public EncryptedPIN exportPIN(EncryptedPIN var1, SecureDESKey var2, byte var3) throws SMException;

    public EncryptedPIN generatePIN(String var1, int var2) throws SMException;

    public EncryptedPIN generatePIN(String var1, int var2, List<String> var3) throws SMException;

    public String calculatePVV(EncryptedPIN var1, SecureDESKey var2, SecureDESKey var3, int var4) throws SMException;

    public String calculatePVV(EncryptedPIN var1, SecureDESKey var2, SecureDESKey var3, int var4, List<String> var5) throws SMException;

    public String calculatePVV(EncryptedPIN var1, SecureDESKey var2, SecureDESKey var3, SecureDESKey var4, int var5) throws SMException;

    public String calculatePVV(EncryptedPIN var1, SecureDESKey var2, SecureDESKey var3, SecureDESKey var4, int var5, List<String> var6) throws SMException;

    public boolean verifyPVV(EncryptedPIN var1, SecureDESKey var2, SecureDESKey var3, SecureDESKey var4, int var5, String var6) throws SMException;

    public String calculateIBMPINOffset(EncryptedPIN var1, SecureDESKey var2, String var3, String var4, int var5) throws SMException;

    public String calculateIBMPINOffset(EncryptedPIN var1, SecureDESKey var2, String var3, String var4, int var5, List<String> var6) throws SMException;

    public String calculateIBMPINOffset(EncryptedPIN var1, SecureDESKey var2, SecureDESKey var3, String var4, String var5, int var6) throws SMException;

    public String calculateIBMPINOffset(EncryptedPIN var1, SecureDESKey var2, SecureDESKey var3, String var4, String var5, int var6, List<String> var7) throws SMException;

    public boolean verifyIBMPINOffset(EncryptedPIN var1, SecureDESKey var2, SecureDESKey var3, String var4, String var5, String var6, int var7) throws SMException;

    public EncryptedPIN deriveIBMPIN(String var1, SecureDESKey var2, String var3, String var4, int var5, String var6) throws SMException;

    public String calculateCVV(String var1, SecureDESKey var2, SecureDESKey var3, Date var4, String var5) throws SMException;

    public boolean verifyCVV(String var1, SecureDESKey var2, SecureDESKey var3, String var4, Date var5, String var6) throws SMException;

    public boolean verifydCVV(String var1, SecureDESKey var2, String var3, Date var4, String var5, byte[] var6, MKDMethod var7) throws SMException;

    public boolean verifyCVC3(SecureDESKey var1, String var2, String var3, byte[] var4, byte[] var5, byte[] var6, MKDMethod var7, String var8) throws SMException;

    public boolean verifyARQC(MKDMethod var1, SKDMethod var2, SecureDESKey var3, String var4, String var5, byte[] var6, byte[] var7, byte[] var8, byte[] var9) throws SMException;

    public byte[] generateARPC(MKDMethod var1, SKDMethod var2, SecureDESKey var3, String var4, String var5, byte[] var6, byte[] var7, byte[] var8, ARPCMethod var9, byte[] var10, byte[] var11) throws SMException;

    public byte[] verifyARQCGenerateARPC(MKDMethod var1, SKDMethod var2, SecureDESKey var3, String var4, String var5, byte[] var6, byte[] var7, byte[] var8, byte[] var9, ARPCMethod var10, byte[] var11, byte[] var12) throws SMException;

    public byte[] generateSM_MAC(MKDMethod var1, SKDMethod var2, SecureDESKey var3, String var4, String var5, byte[] var6, byte[] var7, byte[] var8) throws SMException;

    public Pair<EncryptedPIN, byte[]> translatePINGenerateSM_MAC(MKDMethod var1, SKDMethod var2, PaddingMethod var3, SecureDESKey var4, String var5, String var6, byte[] var7, byte[] var8, byte[] var9, EncryptedPIN var10, EncryptedPIN var11, SecureDESKey var12, SecureDESKey var13, SecureDESKey var14, byte var15) throws SMException;

    public byte[] generateCBC_MAC(byte[] var1, SecureDESKey var2) throws SMException;

    public byte[] generateEDE_MAC(byte[] var1, SecureDESKey var2) throws SMException;

    public SecureDESKey translateKeyFromOldLMK(SecureDESKey var1) throws SMException;

    public void eraseOldLMK() throws SMException;
}

