/*
 * Decompiled with CFR 0.152.
 */
package org.jpos.security;

import java.io.PrintStream;
import java.io.Serializable;
import java.security.InvalidParameterException;
import org.jpos.iso.ISOException;
import org.jpos.iso.ISOUtil;
import org.jpos.util.Loggeable;

public class EncryptedPIN
implements Serializable,
Loggeable {
    private static final long serialVersionUID = -9117335317030664867L;
    String accountNumber;
    byte[] pinBlock;
    byte pinBlockFormat;

    public EncryptedPIN() {
    }

    public EncryptedPIN(byte[] pinBlock, byte pinBlockFormat, String accountNumber) {
        this.setPINBlock(pinBlock);
        this.setPINBlockFormat(pinBlockFormat);
        this.setAccountNumber(EncryptedPIN.extractAccountNumberPart(accountNumber));
    }

    public EncryptedPIN(byte[] pinBlock, byte pinBlockFormat, String accountNumber, boolean extract) {
        this.setPINBlock(pinBlock);
        this.setPINBlockFormat(pinBlockFormat);
        this.setAccountNumber(extract ? EncryptedPIN.extractAccountNumberPart(accountNumber) : accountNumber);
    }

    public EncryptedPIN(String pinBlockHexString, byte pinBlockFormat, String accountNumber) {
        this(ISOUtil.hex2byte(pinBlockHexString), pinBlockFormat, accountNumber);
    }

    public EncryptedPIN(String pinBlockHexString, byte pinBlockFormat, String accountNumber, boolean extract) {
        this(ISOUtil.hex2byte(pinBlockHexString), pinBlockFormat, accountNumber, extract);
    }

    @Override
    public void dump(PrintStream p, String indent) {
        String inner = indent + "  ";
        p.print(indent + "<encrypted-pin");
        p.print(" format=\"0" + this.getPINBlockFormat() + "\"");
        p.println(">");
        p.println(inner + "<pin-block>" + ISOUtil.hexString(this.getPINBlock()) + "</pin-block>");
        p.println(inner + "<account-number>" + this.getAccountNumber() + "</account-number>");
        p.println(indent + "</encrypted-pin>");
    }

    public void setPINBlock(byte[] pinBlock) {
        this.pinBlock = pinBlock;
    }

    public byte[] getPINBlock() {
        return this.pinBlock;
    }

    public void setPINBlockFormat(byte pinBlockFormat) {
        this.pinBlockFormat = pinBlockFormat;
    }

    public byte getPINBlockFormat() {
        return this.pinBlockFormat;
    }

    public void setAccountNumber(String extractedAccountNumber) {
        if (extractedAccountNumber.length() != 12) {
            throw new InvalidParameterException("Extracted account number length should be 12, got '" + ISOUtil.protect(extractedAccountNumber) + "'");
        }
        this.accountNumber = extractedAccountNumber;
    }

    public String getAccountNumber() {
        return this.accountNumber;
    }

    public static String extractAccountNumberPart(String accountNumber) {
        String accountNumberPart = null;
        try {
            accountNumberPart = ISOUtil.takeLastN(accountNumber, 13);
            accountNumberPart = ISOUtil.takeFirstN(accountNumberPart, 12);
        }
        catch (ISOException iSOException) {
            // empty catch block
        }
        return accountNumberPart;
    }
}

