/*
 * Decompiled with CFR 0.152.
 */
package org.jpos.security;

import java.io.PrintStream;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import org.jpos.util.Loggeable;

public class CryptographicServiceMessage
implements Loggeable {
    Hashtable fields = new Hashtable();
    Vector orderedTags = new Vector();
    String mcl;
    public static final String MCL_RSI = "RSI";
    public static final String MCL_KSM = "KSM";
    public static final String MCL_RSM = "RSM";
    public static final String MCL_ESM = "ESM";
    public static final String TAG_RCV = "RCV";
    public static final String TAG_ORG = "ORG";
    public static final String TAG_SVR = "SVR";
    public static final String TAG_KD = "KD";
    public static final String TAG_CTP = "CTP";
    public static final String TAG_CTR = "CTR";
    public static final String TAG_ERF = "ERF";

    public CryptographicServiceMessage() {
    }

    public CryptographicServiceMessage(String mcl) {
        this.setMCL(mcl);
    }

    public void setMCL(String mcl) {
        this.mcl = mcl;
    }

    public String getMCL() {
        return this.mcl;
    }

    public void addField(String tag, String content) {
        tag = tag.toUpperCase();
        this.fields.put(tag, content);
        this.orderedTags.add(tag);
    }

    public String getFieldContent(String tag) {
        return (String)this.fields.get(tag.toUpperCase());
    }

    public String toString() {
        StringBuilder csm = new StringBuilder();
        csm.append("CSM(MCL/");
        csm.append(this.getMCL());
        csm.append(" ");
        for (Object tagObject : this.orderedTags) {
            String tag = (String)tagObject;
            csm.append(tag);
            csm.append("/");
            csm.append(this.getFieldContent(tag));
            csm.append(" ");
        }
        csm.append(")");
        return csm.toString();
    }

    @Override
    public void dump(PrintStream p, String indent) {
        String inner = indent + "  ";
        p.print(indent + "<csm");
        p.print(" class=\"" + this.getMCL() + "\"");
        p.println(">");
        for (Object tagObject : this.orderedTags) {
            String tag = (String)tagObject;
            p.println(inner + "<field tag=\"" + tag + "\" value=\"" + this.getFieldContent(tag) + "\"/>");
        }
        p.println(indent + "</csm>");
    }

    public static CryptographicServiceMessage parse(String csmString) throws ParsingException {
        CryptographicServiceMessage csm = new CryptographicServiceMessage();
        StringTokenizer st = new StringTokenizer(csmString, "() \t\n\r\f");
        if (!st.nextToken().equalsIgnoreCase("CSM")) {
            throw new ParsingException("Invalid CSM, doesn't start with the \"CSM(\" tag: " + csmString);
        }
        do {
            String field;
            int separatorIndex;
            if ((separatorIndex = (field = st.nextToken()).indexOf(47)) > 0) {
                String tag = field.substring(0, separatorIndex).toUpperCase();
                String content = "";
                if (separatorIndex < field.length()) {
                    content = field.substring(separatorIndex + 1);
                }
                if (tag.equalsIgnoreCase("MCL")) {
                    csm.setMCL(content);
                    continue;
                }
                csm.addField(tag, content);
                continue;
            }
            throw new ParsingException("Invalid field, doesn't have a tag: " + field);
        } while (st.hasMoreTokens());
        if (csm.getMCL() == null) {
            throw new ParsingException("Invalid CSM, doesn't contain an MCL: " + csmString);
        }
        return csm;
    }

    public static class ParsingException
    extends Exception {
        private static final long serialVersionUID = 6984718759445061L;

        public ParsingException() {
        }

        public ParsingException(String detail) {
            super(detail);
        }
    }
}

